/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToblerHyperelliptical
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Tobler Hyperelliptical";
    private static final double DEFAULT_ALPHA = 0.0;
    private static final double DEFAULT_GAMMA = 1.183136;
    private static final double DEFAULT_K = 2.5;
    private final double alpha_ = 0.0;
    private final double gamma_ = 1.183136;
    private final double kterm_ = 2.5;
    private double alphaM1_ = -1.0;
    private double invGamma_ = 0.8452113704595245;
    private double invK_ = 0.4;
    private double alphaM1OverGamma_ = this.alphaM1_ * this.invGamma_;
    private double gammaToTheK_ = Math.pow(1.183136, 2.5);
    private double affineSq_ = 1.0;
    private double invaffineSq_ = 1.0;
    private int adaptFailures_;

    public ToblerHyperelliptical(int width, int height) {
        this(width, height, 0, 0);
    }

    public ToblerHyperelliptical(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.finishConstruction();
    }

    @Override
    protected void prepareScaling() {
        this.alphaM1_ = -1.0;
        this.invGamma_ = 0.8452113704595245;
        this.invK_ = 0.4;
        this.alphaM1OverGamma_ = this.alphaM1_ * this.invGamma_;
        this.gammaToTheK_ = Math.pow(1.183136, 2.5);
        double yf = this.iterateYOverRS(90.0, false);
        this.affineSq_ = Double.isNaN(yf) || Double.isInfinite(yf) ? 1.0 : 1.5707963267948966 / yf;
        this.invaffineSq_ = 1.0 / this.affineSq_;
        this.setMaxXYOverRS(Math.PI, 1.5707963267948966);
    }

    @Override
    protected final void finishScaling() {
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        double absLat = Math.abs(lat);
        double lambdaRad = this.lonToLambdaRad(lon);
        if (absLat < 1.0E-10) {
            x = lambdaRad;
            y = 0.0;
        } else if (absLat > 89.99999) {
            y = 1.183136;
            x = lambdaRad * (0.0 - this.alphaM1OverGamma_ * this.hyperelliptic(y, false));
        } else {
            y = this.iterateYOverRS(absLat, false);
            if (Double.isNaN(y) || Double.isInfinite(y)) {
                return null;
            }
            x = lambdaRad * (0.0 - this.alphaM1OverGamma_ * this.hyperelliptic(y, false));
        }
        y *= this.affineSq_;
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double sinPhi;
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absY = Math.abs(y);
        if (Math.abs(x) > (double)this.dxMax_ || absY > (double)this.dyMax_) {
            return null;
        }
        if (absY > this.ymRS_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = absY * this.invRS_ * this.invaffineSq_;
        if (absY < 1.0E-5) {
            lambdaRad = xOverRS;
            sinPhi = 0.0;
        } else {
            lambdaRad = xOverRS / (0.0 - this.alphaM1OverGamma_ * this.hyperelliptic(yOverRS, false));
            sinPhi = 0.0 * yOverRS - this.alphaM1OverGamma_ * this.integral(yOverRS);
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phiRad = Math.asin(sinPhi);
        if (x < 0.0) {
            phiRad = -phiRad;
        }
        if (y < 0.0) {
            phiRad = -phiRad;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        ToblerHyperelliptical toblerHyperelliptical = this;
        synchronized (toblerHyperelliptical) {
            double y;
            double phiRad = 0.0;
            for (int iy = 0; iy < this.dyMax_ && !((y = (double)iy + 0.5) > this.ymRS_); ++iy) {
                double x;
                double xOverRS;
                double lambdaRad;
                double yOverRS = y * this.invRS_ * this.invaffineSq_;
                double sinPhi = 0.0 * yOverRS - this.alphaM1OverGamma_ * this.integral(yOverRS);
                phiRad = Math.asin(sinPhi);
                double xTerm = 1.0 / (0.0 - this.alphaM1OverGamma_ * this.hyperelliptic(yOverRS, false));
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (xOverRS = (x = (double)ix + 0.5) * this.invRS_) * xTerm) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    private double iterateYOverRS(double absphi, boolean debug) {
        if (absphi > 89.99999) {
            return 1.183136;
        }
        double phiRad = Math.toRadians(absphi);
        double sinPhi = Math.sin(phiRad);
        double y = 1.183136 * phiRad / 1.5707963267948966;
        if (y > 1.183136) {
            y *= 0.5;
        }
        for (int iter = 0; iter < 33; ++iter) {
            double integral = this.integral(y);
            double hyper = this.hyperelliptic(y, debug);
            double func = sinPhi - 0.0 * y + this.alphaM1OverGamma_ * integral;
            double dfunc = -0.0 + this.alphaM1OverGamma_ * hyper;
            double dy = -func / dfunc;
            if (debug) {
                LOGGER.debug("Iteration {} for {}", (Object)iter, (Object)absphi);
                LOGGER.debug(" -- hyper {}, integral {}", (Object)hyper, (Object)integral);
                LOGGER.debug(" -- func {}, dfunc {}", (Object)func, (Object)dfunc);
                LOGGER.debug(" -- y {}, dy {}, y {}", y, dy, y + dy);
            }
            if ((y += dy) > 1.183136) {
                y = 1.183126;
            }
            if (Math.abs(dy) < 1.0E-5) break;
        }
        return y;
    }

    private double hyperelliptic(double y, boolean debug) {
        double yToTheK = Math.pow(y, 2.5);
        double diff = this.gammaToTheK_ - yToTheK;
        double result = Math.pow(diff, this.invK_);
        if (debug && (Double.isNaN(result) || Double.isInfinite(result))) {
            LOGGER.debug("   y {}, y^k {}", (Object)y, (Object)yToTheK);
            LOGGER.debug("   g {}, g^k {}", (Object)1.183136, (Object)this.gammaToTheK_);
            LOGGER.debug("   diff {}, result {}", (Object)diff, (Object)result);
        }
        return result;
    }

    private double integral(double y) {
        return this.adaptive(0.0, y, 1.0E-5);
    }

    private double adaptive(double a, double b, double epsilon) {
        double q1;
        double fe;
        double h = b - a;
        double c = 0.5 * (a + b);
        double d = 0.5 * (a + c);
        double e = 0.5 * (b + c);
        double fa = this.hyperelliptic(a, false);
        double fb = this.hyperelliptic(b, false);
        double fc = this.hyperelliptic(c, false);
        double fd = this.hyperelliptic(d, false);
        double q2 = h * (fa + 4.0 * fd + 2.0 * fc + 4.0 * (fe = this.hyperelliptic(e, false)) + fb) / 12.0;
        if (Math.abs(q2 - (q1 = h * (fa + 4.0 * fc + fb) / 6.0)) > epsilon) {
            try {
                return this.adaptive(a, c, epsilon) + this.adaptive(c, b, epsilon);
            }
            catch (Exception exc) {
                LOGGER.trace("failure {}", (Object)(++this.adaptFailures_));
            }
        }
        return q2 + (q2 - q1) / 15.0;
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        super.drawBorderLines(g2d);
    }

    @Override
    protected void drawMeridianNoLabel(Graphics2D g2d, double lon, double maxLat) {
        super.drawMeridianNoLabel(g2d, lon, maxLat);
    }
}

