/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.dialog;

import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanSaveSettingsGroupDialog
extends JDialog {
    private JButton cancelBtn_;
    private JButton createBtn_;
    private JTextField nameTF_;
    private boolean success_;

    public PanSaveSettingsGroupDialog(PanFrame ff) {
        super(ff, "Save Settings", true);
        this.setResizable(false);
        this.createLayout();
        this.attachListeners();
        Rectangle rr = ff.getBounds();
        Dimension psize = this.getContentPane().getPreferredSize();
        int x = (rr.width - psize.width) / 2;
        int y = (rr.height - psize.height) / 2;
        this.setLocation(rr.x + x, rr.y + y);
    }

    private void createLayout() {
        JLabel message = new JLabel("What name should I assign to the saved settings?");
        this.nameTF_ = new JTextField("Saved Settings", 20);
        this.cancelBtn_ = new JButton("Cancel");
        this.createBtn_ = new JButton("Save");
        QuickBox buttonBox = PlatformUtils.isMacintosh() ? QuickBox.createRightBox(this.cancelBtn_, this.createBtn_) : QuickBox.createRightBox(this.createBtn_, this.cancelBtn_);
        JPanel contentPanel = new JPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(2, 4, 0, 2);
        contentPanel.setLayout(fgl);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        contentPanel.add((Component)message, new FGConstraint(0, 0));
        contentPanel.add((Component)this.nameTF_, new FGConstraint(0, 1, 0.5));
        contentPanel.add((Component)buttonBox, new FGConstraint(0, 3, 1.0));
        this.getContentPane().add(contentPanel);
        this.getRootPane().setDefaultButton(this.createBtn_);
        GuiUtils.fixDefaultButtonColor(this.createBtn_);
        this.pack();
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            EventQueue.invokeLater(() -> this.nameTF_.requestFocusInWindow());
        }
        super.setVisible(vis);
    }

    private void attachListeners() {
        this.createBtn_.addActionListener(e -> {
            this.success_ = true;
            this.setVisible(false);
        });
        this.cancelBtn_.addActionListener(e -> {
            this.success_ = false;
            this.setVisible(false);
        });
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    @Override
    public String getName() {
        return this.nameTF_.getText();
    }
}

