/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.ui.FloatComboBox;
import gov.nasa.giss.ui.FontComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLabelsPrefsPanel
extends PanAbstractPrefsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private FontComboBox fontCombo_;
    private FloatComboBox titleLabelSizeCombo_;
    private FloatComboBox subtitleLabelSizeCombo_;
    private FloatComboBox footnoteLabelSizeCombo_;
    private PanCheckBox super10CB_;
    private boolean refreshing_;

    public PanLabelsPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Labels"));
        this.setOpaque(false);
        JLabel topText = new JLabel("When creating a plot, set\u2026");
        JLabel l1label_ = new JLabel("Labels: ");
        JLabel l3label_ = new JLabel("Exponents: ");
        GuiUtils.matchLabelWidths(l1label_, l3label_);
        this.fontCombo_ = FontComboBox.create();
        this.titleLabelSizeCombo_ = FloatComboBox.create(8.0f, 40.0f);
        this.subtitleLabelSizeCombo_ = FloatComboBox.create(8.0f, 40.0f);
        this.footnoteLabelSizeCombo_ = FloatComboBox.create(5.0f, 24.0f);
        this.super10CB_ = PanCheckBox.create("Replace \"E\" notation with superscripted 10");
        FlexingGridLayout fgl = new FlexingGridLayout(3, 4, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setRigidHeight(true);
        this.setLayout(fgl);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 3, 1));
        this.add((Component)l1label_, new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Typeface:\u2009"), this.fontCombo_), new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Sizes: "), new JLabel("Title:\u2009"), this.titleLabelSizeCombo_, new JLabel("\u2014 Subtitle:\u2009"), this.subtitleLabelSizeCombo_, new JLabel("\u2014 Footnotes:\u2009"), this.footnoteLabelSizeCombo_), new FGConstraint(1, ++row));
        this.add((Component)l3label_, new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.super10CB_), new FGConstraint(1, row));
    }

    private void attachListeners() {
        this.fontCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:labels.font", this.fontCombo_.getSelectedItem().toString());
        });
        this.titleLabelSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.setFloat("plot:title.size", this.titleLabelSizeCombo_.getValue());
        });
        this.subtitleLabelSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.setFloat("plot:subtitle.size", this.subtitleLabelSizeCombo_.getValue());
        });
        this.footnoteLabelSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.setFloat("plot:footnote.size", this.footnoteLabelSizeCombo_.getValue());
        });
        this.super10CB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:labels.super10", this.super10CB_.isSelected());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.fontCombo_.setSelectedItem(prefs_.getString("plot:labels.font"));
        this.titleLabelSizeCombo_.setValue(prefs_.getFloat("plot:title.size"));
        this.subtitleLabelSizeCombo_.setValue(prefs_.getFloat("plot:subtitle.size"));
        this.footnoteLabelSizeCombo_.setValue(prefs_.getFloat("plot:footnote.size"));
        this.super10CB_.setSelected(prefs_.getBoolean("plot:labels.super10"));
        this.refreshing_ = false;
    }
}

