/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.text;

import gov.nasa.giss.text.StringUtils;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LatitudeDocument
extends PlainDocument {
    @Override
    public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
        String newValue;
        if (string == null) {
            return;
        }
        String minusSign = StringUtils.getMinusSign();
        String decimalSep = StringUtils.getDecimalSeparator();
        int length = this.getLength();
        if (length == 0) {
            newValue = string;
        } else {
            String currentContent = this.getText(0, length);
            StringBuilder currentBuffer = new StringBuilder(currentContent);
            currentBuffer.insert(offset, string);
            newValue = currentBuffer.toString();
        }
        try {
            double d = newValue.equals(minusSign) || newValue.equals(decimalSep) ? 0.0 : StringUtils.parseDouble(newValue);
            if (d > 90.0 || d < -90.0) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(offset, string, attributes);
        }
        catch (NumberFormatException exception) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

