/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.util.task;

import gov.nasa.giss.util.task.Task;
import gov.nasa.giss.util.task.TaskEvent;
import gov.nasa.giss.util.task.TaskListener;
import gov.nasa.giss.util.task.TaskQueueEvent;
import gov.nasa.giss.util.task.TaskQueueListener;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskQueue
implements TaskListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Object lock_ = new Object();
    private final ArrayList<Task> tasklist_ = new ArrayList();
    private Task currentTask_;
    private final ArrayList<TaskQueueListener> listeners_ = new ArrayList(24);

    public static TaskQueue getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private TaskQueue() {
    }

    public int size() {
        return this.tasklist_.size();
    }

    public Task getCurrentTask() {
        if (this.size() == 0) {
            return null;
        }
        return this.currentTask_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Task task) {
        if (task == null) {
            return;
        }
        Object object = this.lock_;
        synchronized (object) {
            task.addTaskListener(this);
            this.tasklist_.add(task);
        }
        if (this.size() == 1) {
            this.startNextTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Task task) {
        if (task == null) {
            return false;
        }
        if (task == this.currentTask_) {
            LOGGER.trace("Cannot remove task in progress.");
            return false;
        }
        if (!this.tasklist_.contains(task)) {
            return false;
        }
        Object object = this.lock_;
        synchronized (object) {
            task.removeTaskListener(this);
            this.tasklist_.remove(task);
        }
        return true;
    }

    private boolean startNextTask() {
        Task task;
        if (this.currentTask_ != null) {
            return false;
        }
        if (this.size() < 1) {
            return false;
        }
        this.currentTask_ = task = this.tasklist_.get(0);
        EventQueue.invokeLater(() -> task.execute());
        LOGGER.trace("");
        this.fireTaskStarted(task);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueueListener(TaskQueueListener ll) {
        ArrayList<TaskQueueListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            this.listeners_.add(ll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueueListener(TaskQueueListener ll) {
        ArrayList<TaskQueueListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            this.listeners_.remove(ll);
        }
    }

    public synchronized void removeQueueListeners() {
        this.listeners_.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTaskStarted(Task task) {
        LOGGER.trace("{}", (Object)task.getDescription());
        TaskQueueEvent tqe = new TaskQueueEvent(this, task, 1001);
        ArrayList<TaskQueueListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            int isize = this.listeners_.size();
            if (isize > 0) {
                for (int i = isize - 1; i >= 0; --i) {
                    this.listeners_.get(i).taskStarted(tqe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueueEmptied() {
        TaskQueueEvent tqe = new TaskQueueEvent(this, null, 1099);
        ArrayList<TaskQueueListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            int isize = this.listeners_.size();
            if (isize > 0) {
                for (int i = isize - 1; i >= 0; --i) {
                    this.listeners_.get(i).queueEmptied(tqe);
                }
            }
        }
    }

    @Override
    public void taskCommenced(TaskEvent e) {
        Task task = (Task)e.getSource();
        LOGGER.trace("");
        this.fireTaskStarted(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskCanceled(TaskEvent e) {
        Task task = (Task)e.getSource();
        TaskQueueEvent tqe = new TaskQueueEvent(this, task, 1003);
        ArrayList<TaskQueueListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            int isize = this.listeners_.size();
            if (isize > 0) {
                for (int i = isize - 1; i >= 0; --i) {
                    this.listeners_.get(i).taskCanceled(tqe);
                }
            }
        }
        this.taskFinished(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskCompleted(TaskEvent e) {
        Task task = (Task)e.getSource();
        TaskQueueEvent tqe = new TaskQueueEvent(this, task, 1002);
        ArrayList<TaskQueueListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            int isize = this.listeners_.size();
            if (isize > 0) {
                for (int i = isize - 1; i >= 0; --i) {
                    this.listeners_.get(i).taskCompleted(tqe);
                }
            }
        }
        this.taskFinished(task);
    }

    private void taskFinished(Task task) {
        if (task == null) {
            LOGGER.warn("Null task.");
            return;
        }
        if (task == this.currentTask_) {
            this.currentTask_ = null;
        }
        this.remove(task);
        if (this.size() > 0) {
            this.startNextTask();
        } else {
            this.fireQueueEmptied();
        }
    }

    private static class Singleton {
        private static final TaskQueue INSTANCE = new TaskQueue();

        private Singleton() {
        }
    }
}

