/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class Wagner4
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Wagner IV";
    private static final double CONST_P = 1.0471975511965976;
    private static final double SIN_P = Math.sin(1.0471975511965976);
    private static final double TWO_P = 2.0943951023931953;
    private static final double CSUBP = 2.0943951023931953 + Math.sin(2.0943951023931953);
    private static final double INV_CSUBP = 1.0 / CSUBP;
    private static final double CONST_R = Math.sqrt(Math.PI * 2 * SIN_P * INV_CSUBP);
    private static final double CSUBX = CONST_R * 0.6366197723675814;
    private static final double CSUBY = CONST_R / SIN_P;
    private static final double INV_CSUBX = 1.0 / CSUBX;
    private static final double INV_CSUBY = 1.0 / CSUBY;
    private static final double MAX_X_OVER_RS = CSUBX * Math.PI;
    private static final double MAX_Y_OVER_RS = CSUBY * SIN_P;

    public Wagner4(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner4(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiRad = Math.toRadians(lat);
        double phiFactor = CSUBP * Math.sin(phiRad);
        double psiRad = 0.5 * phiRad;
        for (int iter = 0; iter < 33; ++iter) {
            double twoPsiRad = 2.0 * psiRad;
            double func = twoPsiRad + Math.sin(twoPsiRad) - phiFactor;
            double dfunc = 2.0 * (1.0 + Math.cos(twoPsiRad));
            double dpsiRad = -func / dfunc;
            psiRad += dpsiRad;
            if (Math.abs(dpsiRad) < 1.0E-5) break;
        }
        double x = CSUBX * this.lonToLambdaRad(lon) * Math.cos(psiRad);
        double y = CSUBY * Math.sin(psiRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double psiRad = Math.asin(y * this.invRS_ * INV_CSUBY);
        double twoPsiRad = 2.0 * psiRad;
        double phiRad = Math.asin((twoPsiRad + Math.sin(twoPsiRad)) * INV_CSUBP);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.invRS_ * INV_CSUBX / Math.cos(psiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Wagner4 wagner4 = this;
        synchronized (wagner4) {
            double y;
            double psiRad;
            double twoPsiRad;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin(((twoPsiRad = 2.0 * (psiRad = Math.asin((y = (double)iy + 0.5) * this.invRS_ * INV_CSUBY))) + Math.sin(twoPsiRad)) * INV_CSUBP)) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRS_ * INV_CSUBX / Math.cos(psiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawMeridianNoLabel(Graphics2D g2d, double lon, double maxLat) {
        double lambda = this.lonToLambda(lon);
        double absLambda = Math.abs(lambda);
        if (absLambda > 179.99999) {
            return;
        }
        Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
        Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
        if (absLambda < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
        } else {
            double lambdaRad = Math.toRadians(lambda);
            double absLambdaRad = Math.toRadians(absLambda);
            Point2D.Double dotEq = this.transformLL2XY(lon, 0.0);
            double rectW = 2.0 * CSUBX * absLambdaRad * this.rS_;
            double rectX = lambdaRad < 0.0 ? dotEq.x : dotEq.x - rectW;
            double rectH = 2.0 * CSUBY * this.rS_;
            double rectY = (double)this.outCenterY_ - CSUBY * this.rS_;
            if (lambdaRad > 0.0) {
                GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotS, dotN);
            } else {
                GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotN, dotS);
            }
        }
    }
}

