/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.prefs.PanBookmarkNode;
import gov.nasa.giss.panoply.prefs.PanBookmarkType;
import gov.nasa.giss.panoply.prefs.PanExtraPrefsNode;
import gov.nasa.giss.panoply.ui.PanFrame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.DatasetUrl;

public class PanBookmark
extends PanBookmarkNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String UNNAMED = "Unnamed";
    private static String homeDir_ = System.getProperty("user.home");
    private PanBookmarkType btype_;
    private String addStr_;

    private PanBookmark() {
    }

    public PanBookmark(PanExtraPrefsNode parent, PanBookmarkType btype, Object address, String name) throws IOException, URISyntaxException {
        this(btype, address, name);
        super.setParent(parent);
    }

    public PanBookmark(String btstr, Object address, String name) throws IOException, URISyntaxException {
        Objects.requireNonNull(btstr, "Null bookmark type");
        PanBookmarkType btype = PanBookmarkType.matching(btstr);
        if (btype == null) {
            throw new IllegalArgumentException("Uknown bookmark type " + btstr);
        }
        this.initMe(btype, address, name);
    }

    public PanBookmark(PanBookmarkType btype, Object address, String name) throws IOException, URISyntaxException {
        Objects.requireNonNull(btype, "Null bookmark type");
        this.initMe(btype, address, name);
    }

    private void initMe(PanBookmarkType btype, Object address, String name) throws FileNotFoundException, IOException, URISyntaxException {
        block17: {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block16: {
                                this.btype_ = btype;
                                this.setName(name);
                                if (!(address instanceof URI)) break block16;
                                this.addStr_ = ((URI)address).toString();
                                break block17;
                            }
                            if (!(address instanceof URL)) break block18;
                            this.addStr_ = ((URL)address).toString();
                            break block17;
                        }
                        if (!(address instanceof File)) break block19;
                        File f = (File)address;
                        if (!f.exists()) {
                            LOGGER.debug("No File at File {}", (Object)f.getCanonicalPath());
                            throw new FileNotFoundException("No local file at '" + f.getCanonicalPath() + "'");
                        }
                        this.addStr_ = ((File)address).toString();
                        break block17;
                    }
                    if (!(address instanceof DatasetUrl)) break block20;
                    this.addStr_ = ((DatasetUrl)address).getTrueurl();
                    break block17;
                }
                if (!(address instanceof String)) break block21;
                this.addStr_ = (String)address;
                switch (btype) {
                    case LOCAL_DATASET: {
                        this.addStr_ = this.addStr_.replaceFirst("file:", "");
                        this.addStr_ = this.addStr_.replaceAll("/+", "/");
                        this.addStr_ = this.addStr_.replaceAll("%20", " ");
                        this.addStr_ = this.addStr_.replaceAll("%23", "#");
                        URI uri = null;
                        File f = null;
                        try {
                            uri = new URI("file:" + this.addStr_);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (uri != null) {
                            try {
                                f = new File(uri);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                            }
                            catch (Exception exc) {
                                LOGGER.trace("{} creating File from URI {}", (Object)exc.getClass().getSimpleName(), (Object)uri);
                            }
                        }
                        if (f instanceof File && !f.exists()) {
                            f = null;
                        }
                        if (f == null) {
                            try {
                                f = new File(this.addStr_);
                            }
                            catch (Exception exc) {
                                throw new FileNotFoundException("Could not create File object from '" + this.addStr_ + "'.");
                            }
                        }
                        if (f instanceof File && !f.exists()) {
                            throw new FileNotFoundException("No local file at '" + this.addStr_ + "'.");
                        }
                        break block17;
                    }
                    case REMOTE_DATASET: 
                    case CATALOG: {
                        break block17;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown bookmark type");
                    }
                }
            }
            throw new IllegalArgumentException("Bookmark address must be a File, URL, or URI, or a String that may be parsed as one of those types.");
        }
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public Object getObject() {
        return this.addStr_;
    }

    @Override
    public String getName() {
        if (this.isNameSet()) {
            return super.getName();
        }
        String s = this.addStr_;
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    @Override
    public String getAddress() {
        if (this.addStr_ == null) {
            return "Null address";
        }
        Object s = this.addStr_;
        if (this.addStr_.startsWith("file:") && ((String)(s = ((String)s).substring(5))).startsWith(homeDir_)) {
            s = "~" + ((String)s).substring(homeDir_.length());
        }
        s = ((String)s).replaceAll("%20", " ");
        s = ((String)s).replaceAll("%23", "#");
        return s;
    }

    public PanBookmarkType getAccessType() {
        return this.btype_;
    }

    public void open(PanFrame pframe) {
        switch (this.btype_) {
            case LOCAL_DATASET: {
                PanFileUtils.openLocalDataset(pframe, this.addStr_);
                break;
            }
            case REMOTE_DATASET: {
                PanFileUtils.openDatasetUsingTask(this.addStr_);
                break;
            }
            case CATALOG: {
                PanFileUtils.openCatalogUsingTask(pframe, this.addStr_);
                break;
            }
            default: {
                LOGGER.debug("Switch default case: How did we get here? {}", (Object)this.btype_);
            }
        }
    }

    public PanBookmark copy() {
        try {
            String name = this.isNameSet() ? this.getName() : null;
            return new PanBookmark(this.getAccessType(), this.getObject(), name);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not copy bookmark due to {}", (Object)exc.getClass().getSimpleName());
            return null;
        }
    }
}

