/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.util.PanAxisTickColor;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.FloatComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.ColorComboBox;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class Pan2DGridPrefsPanel
extends PanAbstractPrefsPanel {
    private DescribedEnumComboBox gridStyleCombo_;
    private ColorComboBox gridColorCombo_;
    private PanIntSpinner gridWeightSpinner_;
    private PanCheckBox axesOffsetCB_;
    private FloatComboBox xlabelSizeCombo_;
    private FloatComboBox ylabelSizeCombo_;
    private DescribedEnumComboBox tickColorCombo_;
    private PanIntSpinner tickWeightSpinner_;
    private FloatComboBox xtickSizeCombo_;
    private FloatComboBox ytickSizeCombo_;
    private boolean refreshing_;

    public Pan2DGridPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Color Contour Plot Grid"));
        this.setOpaque(false);
        JLabel topText = new JLabel("When creating a color contour plot, set\u2026");
        this.gridStyleCombo_ = new DescribedEnumComboBox(PanStrokePattern.class);
        this.gridColorCombo_ = new ColorComboBox();
        this.gridColorCombo_.setSelectedColor(prefs_.getColor("plot:ccplot.grid.color"));
        this.gridWeightSpinner_ = PanIntSpinner.weight("plot:ccplot.grid.weight", prefs_.getInt("plot:ccplot.grid.weight"), 0, 200);
        this.axesOffsetCB_ = PanCheckBox.create("Offset axes from grid edges", prefs_.getBoolean("plot:ccplot.axes.offset"));
        this.xlabelSizeCombo_ = FloatComboBox.create(5.0f, 32.0f);
        this.xlabelSizeCombo_.setName("plot:ccplot.xaxis.label.size");
        this.ylabelSizeCombo_ = FloatComboBox.create(5.0f, 32.0f);
        this.ylabelSizeCombo_.setName("plot:ccplot.yaxis.label.size");
        this.tickColorCombo_ = new DescribedEnumComboBox(PanAxisTickColor.class);
        this.tickColorCombo_.setName("plot:ccplot.axes.tickmark.color");
        this.tickWeightSpinner_ = PanIntSpinner.weight("plot:ccplot.axes.tickmark.weight", prefs_.getInt("plot:ccplot.axes.tickmark.weight"), 25, 200);
        this.xtickSizeCombo_ = FloatComboBox.create(5.0f, 24.0f);
        this.xtickSizeCombo_.setName("plot:ccplot.xaxis.tick.size");
        this.ytickSizeCombo_ = FloatComboBox.create(5.0f, 24.0f);
        this.ytickSizeCombo_.setName("plot:ccplot.yaxis.tick.size");
        FlexingGridLayout fgl = new FlexingGridLayout(3, 8, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 3, 1));
        this.add(Box.createVerticalStrut(4), new FGConstraint(0, ++row));
        this.add((Component)new JLabel("Gridline: "), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Style:\u2009"), this.gridStyleCombo_), new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Color:\u2009"), this.gridColorCombo_, new JLabel("\u2014 Weight:\u2009"), this.gridWeightSpinner_, new JLabel("%")), new FGConstraint(1, ++row));
        this.add((Component)this.axesOffsetCB_, new FGConstraint(1, ++row));
        this.add((Component)new JLabel("Axes Ticks: "), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Color:\u2009"), this.tickColorCombo_, new JLabel("\u2014 Weight\u2009"), this.tickWeightSpinner_, new JLabel("%")), new FGConstraint(1, row));
        this.add((Component)new JLabel("X-Axis Sizes: "), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Caption:\u2009"), this.xlabelSizeCombo_, new JLabel("\u2014 Tick Labels\u2009"), this.xtickSizeCombo_), new FGConstraint(1, row));
        this.add((Component)new JLabel("Y-Axis Sizes: "), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Caption:\u2009"), this.ylabelSizeCombo_, new JLabel("\u2014 Tick Labels\u2009"), this.ytickSizeCombo_), new FGConstraint(1, row));
    }

    private void attachListeners() {
        this.gridStyleCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:ccplot.grid.style", this.gridStyleCombo_.getEnumName());
        });
        this.gridColorCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:ccplot.grid.color", this.gridColorCombo_.getSelectedColor());
        });
        this.gridWeightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:ccplot.grid.weight", this.gridWeightSpinner_.getIntValue());
        });
        this.axesOffsetCB_.addItemListener(e -> prefs_.set("plot:ccplot.axes.offset", this.axesOffsetCB_.isSelected()));
        this.xlabelSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.xlabelSizeCombo_.getValue();
            prefs_.setFloat("plot:ccplot.xaxis.label.size", value);
        });
        this.ylabelSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.ylabelSizeCombo_.getValue();
            prefs_.setFloat("plot:ccplot.yaxis.label.size", value);
        });
        this.tickColorCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:ccplot.axes.tickmark.color", this.tickColorCombo_.getEnumName());
        });
        this.tickWeightSpinner_.addChangeListener(e -> prefs_.setInt("plot:ccplot.axes.tickmark.weight", this.tickWeightSpinner_.getIntValue()));
        this.xtickSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.xtickSizeCombo_.getValue();
            prefs_.setFloat("plot:ccplot.xaxis.tick.size", value);
        });
        this.ytickSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.ytickSizeCombo_.getValue();
            prefs_.setFloat("plot:ccplot.yaxis.tick.size", value);
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.gridStyleCombo_.setSelItemMatching(prefs_.getString("plot:ccplot.grid.style"));
        this.gridColorCombo_.setSelectedColor(prefs_.getColor("plot:ccplot.grid.color"));
        this.gridWeightSpinner_.setValue(prefs_.getInt("plot:ccplot.grid.weight"));
        this.axesOffsetCB_.setSelected(prefs_.getBoolean("plot:ccplot.axes.offset"));
        this.xlabelSizeCombo_.setValue(prefs_.getFloat("plot:ccplot.xaxis.label.size"));
        this.ylabelSizeCombo_.setValue(prefs_.getFloat("plot:ccplot.yaxis.label.size"));
        this.tickColorCombo_.setSelItemMatching(prefs_.getString("plot:ccplot.axes.tickmark.color"));
        this.tickWeightSpinner_.setValue(prefs_.getInt("plot:ccplot.axes.tickmark.weight"));
        this.xtickSizeCombo_.setValue(prefs_.getFloat("plot:ccplot.xaxis.tick.size"));
        this.ytickSizeCombo_.setValue(prefs_.getFloat("plot:ccplot.yaxis.tick.size"));
        this.refreshing_ = false;
    }
}

