/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.util.PanContourLocation;
import gov.nasa.giss.panoply.util.PanContourStyle;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.FloatComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.ColorComboBox;
import java.awt.Component;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanContourPrefsPanel
extends PanAbstractPrefsPanel {
    private DescribedEnumComboBox styleCombo_;
    private DescribedEnumComboBox locationCombo_;
    private ColorComboBox colorCombo_;
    private PanIntSpinner weightSpinner_;
    private PanCheckBox clabelVisCB_;
    private JLabel clabelSizeLabel_;
    private FloatComboBox clabelSizeCombo_;
    private boolean refreshing_;

    public PanContourPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.locationCombo_ = new DescribedEnumComboBox(PanContourLocation.class);
        this.styleCombo_ = new DescribedEnumComboBox(PanContourStyle.class);
        this.colorCombo_ = new ColorComboBox();
        this.weightSpinner_ = PanIntSpinner.weight(null, 100, 0, 500);
        this.clabelVisCB_ = PanCheckBox.create("Visible,");
        this.clabelSizeLabel_ = new JLabel(" Size:\u2009");
        this.clabelSizeCombo_ = FloatComboBox.create(5.0f, 15.0f);
        FlexingGridLayout fgl = new FlexingGridLayout(4, 5, 0, 2);
        fgl.setColumnWeight(3, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(GuiUtils.createPaddedTitleBorder("Contours"));
        this.add((Component)new JLabel("Location:\u2009"), new FGConstraint(0, 0, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.locationCombo_), new FGConstraint(1, 0));
        this.add((Component)new JLabel("Style:\u2009"), new FGConstraint(0, 1, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.styleCombo_), new FGConstraint(1, 1));
        this.add((Component)new JLabel("Color:\u2009"), new FGConstraint(0, 2, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.colorCombo_, new JLabel("\u2014 Weight:\u2009"), this.weightSpinner_), new FGConstraint(1, 2));
        this.add((Component)new JLabel("Labels:\u2009"), new FGConstraint(0, 3, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.clabelVisCB_, this.clabelSizeLabel_, this.clabelSizeCombo_), new FGConstraint(1, 3));
    }

    private void attachListeners() {
        this.styleCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            PanContourStyle cstyle = (PanContourStyle)this.styleCombo_.getSelectedItem();
            prefs_.set("plot:contour.style", cstyle.toString());
            this.clabelVisCB_.setEnabled(cstyle != PanContourStyle.NONE);
            this.clabelSizeLabel_.setEnabled(cstyle != PanContourStyle.NONE);
            this.clabelSizeCombo_.setEnabled(cstyle != PanContourStyle.NONE);
        });
        this.locationCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:contour.location", this.locationCombo_.getEnumName());
        });
        this.colorCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:contour.color", this.colorCombo_.getSelectedColor());
        });
        this.weightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:contour.weight", this.weightSpinner_.getIntValue());
        });
        this.clabelVisCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:contour.label.vis", this.clabelVisCB_.isSelected());
        });
        this.clabelSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.clabelSizeCombo_.getValue();
            prefs_.setFloat("plot:contour.label.size", value);
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.styleCombo_.setSelItemMatching(prefs_.getString("plot:contour.style"));
        this.locationCombo_.setSelItemMatching(prefs_.getString("plot:contour.location"));
        this.colorCombo_.setSelectedColor(prefs_.getColor("plot:contour.color"));
        this.weightSpinner_.setValue(prefs_.getInt("plot:contour.weight"));
        this.clabelVisCB_.setSelected(prefs_.getBoolean("plot:contour.label.vis"));
        this.clabelSizeCombo_.setValue(prefs_.getFloat("plot:contour.label.size"));
        PanContourStyle cstyle = PanContourStyle.matching(prefs_.getString("plot:contour.style"));
        this.clabelVisCB_.setEnabled(cstyle != PanContourStyle.NONE);
        this.clabelSizeLabel_.setEnabled(cstyle != PanContourStyle.NONE);
        this.clabelSizeCombo_.setEnabled(cstyle != PanContourStyle.NONE);
        this.refreshing_ = false;
    }
}

