/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

public enum ClockType {
    MEAN_SOLAR("LMST", "Local Mean Solar Time (LMST)"),
    TRUE_SOLAR("LTST", "Local True Solar Time (LTST)"),
    MEAN_ZONAL("LMZT", "Local Mean Zonal Time"),
    PLANETARY("T", "Planetary Time");

    private String abbrev_;
    private String description_;

    private ClockType(String abbrev, String description) {
        this.abbrev_ = abbrev;
        this.description_ = description;
    }

    public String getAbbreviation() {
        return this.abbrev_;
    }

    public String getLongName() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    public boolean matches(String str) {
        return this.nameMatches(str) | this.abbrevMatches(str) | this.descriptionMatches(str);
    }

    public boolean nameMatches(String str) {
        return this.name().equalsIgnoreCase(str);
    }

    public boolean abbrevMatches(String str) {
        return this.abbrev_.equalsIgnoreCase(str);
    }

    public boolean descriptionMatches(String str) {
        return this.description_.equalsIgnoreCase(str);
    }

    public static ClockType matching(String str) {
        for (ClockType ctype : ClockType.values()) {
            if (!ctype.matches(str)) continue;
            return ctype;
        }
        return null;
    }
}

