/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui;

import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.SizeVariant;
import javax.swing.JComboBox;

public final class FloatComboBox
extends JComboBox<Object> {
    private FloatComboBox() {
    }

    private FloatComboBox(ComboFloat ... choices) {
        super(choices);
    }

    public static FloatComboBox create(float min, float max, float step) {
        if (max < min) {
            throw new IllegalArgumentException("Max is less than min?");
        }
        FloatComboBox cb = new FloatComboBox();
        for (float current = min; current < max; current += step) {
            cb.addItem(new ComboFloat(current));
        }
        cb.addItem(new ComboFloat(max));
        return cb;
    }

    public static FloatComboBox create(float min, float max) {
        FloatComboBox m = FloatComboBox.create(min, max, 0.5f);
        GuiUtils.applyComboBoxUI(m, SizeVariant.REGULAR);
        return m;
    }

    @Override
    public void setSelectedItem(Object item) {
        int isize = this.getItemCount();
        if (item instanceof ComboFloat) {
            super.setSelectedItem(item);
            return;
        }
        if (item instanceof Float) {
            float d = ((Float)item).floatValue();
            for (int i = 0; i < isize; ++i) {
                ComboFloat gs = (ComboFloat)this.getItemAt(i);
                if (!((double)Math.abs(gs.getValue() - d) < 1.0E-5)) continue;
                super.setSelectedItem(gs);
                return;
            }
        }
    }

    public void setSelectedItem(float size) {
        this.setValue(size);
    }

    public float getValue() {
        ComboFloat lsz = (ComboFloat)this.getItemAt(this.getSelectedIndex());
        return lsz.getValue();
    }

    public void setValue(float size) {
        if (size <= 0.0f) {
            super.setSelectedIndex(0);
            return;
        }
        int isize = this.getItemCount();
        for (int i = 0; i < isize; ++i) {
            ComboFloat gs = (ComboFloat)this.getItemAt(i);
            if (!((double)Math.abs(gs.getValue() - size) < 1.0E-5)) continue;
            super.setSelectedItem(gs);
            return;
        }
    }

    static class ComboFloat {
        private final float size_;

        public ComboFloat(float size) {
            this.size_ = size;
        }

        public float getValue() {
            return this.size_;
        }

        public String toString() {
            if (this.size_ == 0.0f) {
                return "None";
            }
            return new PrintfFormat("%.1f").sprintfx(Float.valueOf(this.size_));
        }
    }
}

