/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color.chooser;

import gov.nasa.giss.graphics.CmykColorSpace;
import gov.nasa.giss.ui.color.chooser.ColorChooserPanel;
import gov.nasa.giss.ui.color.chooser.ColorChooserSlider;
import gov.nasa.giss.ui.color.chooser.ColorComponentID;
import java.awt.Color;
import java.awt.color.ColorSpace;

class CmykSlider
extends ColorChooserSlider {
    private final ColorSpace cmykSpace_ = new CmykColorSpace();

    CmykSlider(ColorChooserPanel panel, ColorComponentID compID) {
        super(panel, compID);
    }

    @Override
    Color getColorAt(Color c, float pct) {
        float[] cmyk = c.getComponents(this.cmykSpace_, null);
        switch (this.compID_) {
            case CYAN: {
                cmyk[0] = pct;
                break;
            }
            case MAGENTA: {
                cmyk[1] = pct;
                break;
            }
            case YELLOW: {
                cmyk[2] = pct;
                break;
            }
            case BLACK: {
                cmyk[3] = pct;
                break;
            }
        }
        return new Color(this.cmykSpace_, cmyk, 1.0f);
    }

    @Override
    float getTickXPct(Color c) {
        float[] cmyk = c.getComponents(this.cmykSpace_, null);
        switch (this.compID_) {
            case CYAN: {
                return cmyk[0];
            }
            case MAGENTA: {
                return cmyk[1];
            }
            case YELLOW: {
                return cmyk[2];
            }
            case BLACK: {
                return cmyk[3];
            }
        }
        return 0.0f;
    }
}

