/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn.ability.impl;

import com.ghostchu.peerbanhelper.btn.BtnNetwork;
import com.ghostchu.peerbanhelper.btn.ability.AbstractBtnAbility;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BtnAbilityReconfigure
extends AbstractBtnAbility {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BtnAbilityReconfigure.class);
    private final BtnNetwork btnNetwork;
    private final long interval;
    private final long randomInitialDelay;
    private final String version;

    public BtnAbilityReconfigure(BtnNetwork btnNetwork, JsonObject ability) {
        this.btnNetwork = btnNetwork;
        this.interval = ability.get("interval").getAsLong();
        this.randomInitialDelay = ability.get("random_initial_delay").getAsLong();
        this.version = ability.get("version").getAsString();
    }

    @Override
    public String getName() {
        return "BtnAbilityReconfigure";
    }

    @Override
    public TranslationComponent getDisplayName() {
        return new TranslationComponent(Lang.BTN_ABILITY_RECONFIGURE);
    }

    @Override
    public TranslationComponent getDescription() {
        return new TranslationComponent(Lang.BTN_ABILITY_RECONFIGURE_DESCRIPTION);
    }

    @Override
    public void load() {
        this.setLastStatus(true, new TranslationComponent(Lang.BTN_STAND_BY));
        this.btnNetwork.getScheduler().scheduleWithFixedDelay(this::checkIfReconfigure, this.interval + ThreadLocalRandom.current().nextLong(this.randomInitialDelay), this.interval, TimeUnit.MILLISECONDS);
    }

    private void checkIfReconfigure() {
        Request request = new Request.Builder().url(this.btnNetwork.getConfigUrl()).get().build();
        try (Response response = this.btnNetwork.getHttpClient().newCall(request).execute();){
            if (!response.isSuccessful()) {
                String responseBody = response.body().string();
                this.setLastStatus(false, new TranslationComponent(Lang.BTN_HTTP_ERROR, response.code(), responseBody));
                log.error(TextManager.tlUI(Lang.BTN_RECONFIGURE_CHECK_FAILED, response.code() + " - " + responseBody));
                return;
            }
            String responseBody = response.body().string();
            JsonObject json = JsonParser.parseString((String)responseBody).getAsJsonObject();
            JsonObject ability = json.get("ability").getAsJsonObject();
            if (!ability.has("reconfigure")) {
                this.setLastStatus(true, new TranslationComponent(Lang.BTN_RECONFIGURE_DISABLED_BY_SERVER));
                return;
            }
            JsonObject reconfigure = ability.get("reconfigure").getAsJsonObject();
            if (!reconfigure.get("version").getAsString().equals(this.version)) {
                log.info(TextManager.tlUI(Lang.BTN_RECONFIGURING, new Object[0]));
                this.setLastStatus(true, new TranslationComponent(Lang.BTN_RECONFIGURE_PREPARE_RECONFIGURE));
                this.btnNetwork.configBtnNetwork();
                this.setLastStatus(true, new TranslationComponent(Lang.BTN_STAND_BY));
            }
        }
        catch (Exception e) {
            this.setLastStatus(false, new TranslationComponent(Lang.BTN_HTTP_ERROR, -1, e.getMessage()));
            log.error(TextManager.tlUI(Lang.BTN_RECONFIGURE_CHECK_FAILED, e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void unload() {
    }
}

