/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.database.dao.impl.HistoryDao;
import com.ghostchu.peerbanhelper.database.dao.impl.ModuleDao;
import com.ghostchu.peerbanhelper.database.dao.impl.PeerRecordDao;
import com.ghostchu.peerbanhelper.database.dao.impl.RuleDao;
import com.ghostchu.peerbanhelper.database.dao.impl.TorrentDao;
import com.ghostchu.peerbanhelper.database.table.HistoryEntity;
import com.ghostchu.peerbanhelper.database.table.PeerRecordEntity;
import com.ghostchu.peerbanhelper.downloader.DownloaderManagerImpl;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.monitor.ActiveMonitoringModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.BanLogDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.PeerInfoDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.PeerRecordEntityDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.TorrentEntityDTO;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.MsgUtil;
import com.ghostchu.peerbanhelper.util.dns.DNSLookup;
import com.ghostchu.peerbanhelper.util.ipdb.IPDB;
import com.ghostchu.peerbanhelper.util.ipdb.IPDBManager;
import com.ghostchu.peerbanhelper.util.ipdb.IPGeoData;
import com.ghostchu.peerbanhelper.util.lab.Laboratory;
import com.ghostchu.peerbanhelper.util.query.Orderable;
import com.ghostchu.peerbanhelper.util.query.Page;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.google.common.net.HostAndPort;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.Where;
import inet.ipaddr.IPAddress;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class PBHPeerController
extends AbstractFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHPeerController.class);
    private final JavalinWebContainer javalinWebContainer;
    private final HistoryDao historyDao;
    private final PeerRecordDao peerRecordDao;
    private final ActiveMonitoringModule activeMonitoringModule;
    private final Laboratory laboratory;
    private final DNSLookup dnsLookup;
    private final DownloaderManagerImpl downloaderManager;
    private final TorrentDao torrentDao;
    private final RuleDao ruleDao;
    private final ModuleDao moduleDao;
    private final IPDBManager iPDBManager;

    public PBHPeerController(JavalinWebContainer javalinWebContainer, HistoryDao historyDao, PeerRecordDao peerRecordDao, ActiveMonitoringModule activeMonitoringModule, Laboratory laboratory, DNSLookup dnsLookup, DownloaderManagerImpl downloaderManager, TorrentDao torrentDao, RuleDao ruleDao, ModuleDao moduleDao, IPDBManager iPDBManager) {
        this.javalinWebContainer = javalinWebContainer;
        this.historyDao = historyDao;
        this.peerRecordDao = peerRecordDao;
        this.activeMonitoringModule = activeMonitoringModule;
        this.laboratory = laboratory;
        this.dnsLookup = dnsLookup;
        this.downloaderManager = downloaderManager;
        this.torrentDao = torrentDao;
        this.ruleDao = ruleDao;
        this.moduleDao = moduleDao;
        this.iPDBManager = iPDBManager;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "Peer Controller";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "peer-controller";
    }

    @Override
    public void onEnable() {
        ((Javalin)((Javalin)this.javalinWebContainer.javalin().get("/api/peer/{ip}", this::handleInfo, new RouteRole[]{Role.USER_READ})).get("/api/peer/{ip}/accessHistory", this::handleAccessHistory, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS})).get("/api/peer/{ip}/banHistory", this::handleBanHistory, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS});
    }

    private void handleInfo(Context ctx) throws SQLException {
        long downloadedFromPeer;
        long uploadedToPeer;
        HostAndPort hostAndPort = HostAndPort.fromString((String)ctx.pathParam("ip"));
        IPAddress ipAddress = IPAddressUtil.getIPAddress(hostAndPort.getHost());
        String ip = ipAddress.toNormalizedString();
        long banCount = this.historyDao.queryBuilder().where().eq("ip", (Object)new SelectArg((Object)ip)).countOf();
        long torrentAccessCount = this.peerRecordDao.queryBuilder().where().eq("address", (Object)new SelectArg((Object)ip)).countOf();
        String[] upDownResult = this.peerRecordDao.queryBuilder().selectRaw(new String[]{"SUM(uploaded) as uploaded_total, SUM(downloaded) as downloaded_total"}).groupBy("address").where().eq("address", (Object)MsgUtil.escapeSql(ip)).queryRawFirst();
        if (upDownResult != null) {
            if (upDownResult.length == 2) {
                uploadedToPeer = Long.parseLong(upDownResult[0]);
                downloadedFromPeer = Long.parseLong(upDownResult[1]);
            } else {
                uploadedToPeer = -1L;
                downloadedFromPeer = -1L;
            }
        } else {
            uploadedToPeer = -1L;
            downloadedFromPeer = -1L;
        }
        long firstTimeSeenTS = -1L;
        long lastTimeSeenTS = -1L;
        PeerRecordEntity firstTimeSeen = (PeerRecordEntity)this.peerRecordDao.queryBuilder().orderBy("firstTimeSeen", true).where().eq("address", (Object)new SelectArg((Object)ip)).queryForFirst();
        PeerRecordEntity lastTimeSeen = (PeerRecordEntity)this.peerRecordDao.queryBuilder().orderBy("lastTimeSeen", false).where().eq("address", (Object)new SelectArg((Object)ip)).queryForFirst();
        if (firstTimeSeen != null) {
            firstTimeSeenTS = new Timestamp(firstTimeSeen.getFirstTimeSeen().getTime()).getTime();
        }
        if (lastTimeSeen != null) {
            lastTimeSeenTS = new Timestamp(lastTimeSeen.getLastTimeSeen().getTime()).getTime();
        }
        IPDB ipdb = this.iPDBManager.getIpdb();
        IPGeoData geoIP = null;
        try {
            if (ipdb != null) {
                geoIP = ipdb.query(ipAddress.toInetAddress());
            }
        }
        catch (Exception e) {
            log.warn("Unable to perform GeoIP query for ip {}", (Object)ip);
        }
        String ptrLookup = null;
        try {
            ptrLookup = this.dnsLookup.ptr(ip).get(3L, TimeUnit.SECONDS).orElse(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PeerInfoDTO info = new PeerInfoDTO(upDownResult != null || banCount > 0L || torrentAccessCount > 0L, ip, firstTimeSeenTS, lastTimeSeenTS, banCount, torrentAccessCount, uploadedToPeer, downloadedFromPeer, geoIP, ptrLookup);
        ctx.json((Object)new StdResp(true, null, info));
    }

    private void handleBanHistory(Context ctx) throws SQLException {
        String ip = IPAddressUtil.getIPAddress(ctx.pathParam("ip")).toNormalizedString();
        Pageable pageable = new Pageable(ctx);
        QueryBuilder builder = new Orderable(Map.of("banAt", false), ctx).addMapping("torrent.name", "torrentName").addMapping("torrent.infoHash", "torrentInfoHash").addMapping("torrent.size", "torrentSize").addMapping("module.name", "module").addMapping("rule.rule", "rule").addMapping("port", "peerPort").apply(this.historyDao.queryBuilder().join(this.torrentDao.queryBuilder().setAlias("torrent"), QueryBuilder.JoinType.LEFT, QueryBuilder.JoinWhereOperation.AND).join(this.ruleDao.queryBuilder().setAlias("rule").join(this.moduleDao.queryBuilder().setAlias("module"), QueryBuilder.JoinType.LEFT, QueryBuilder.JoinWhereOperation.AND), QueryBuilder.JoinType.LEFT, QueryBuilder.JoinWhereOperation.AND));
        Where where = builder.where().eq("ip", (Object)new SelectArg((Object)ip));
        builder.setWhere(where);
        Page queryResult = this.historyDao.queryByPaging(builder, pageable);
        List<BanLogDTO> result = queryResult.getResults().stream().map(r -> new BanLogDTO(this.locale(ctx), this.downloaderManager, (HistoryEntity)r)).toList();
        ctx.json((Object)new StdResp(true, null, new Page<BanLogDTO>(pageable, queryResult.getTotal(), result)));
    }

    private void handleAccessHistory(Context ctx) throws SQLException {
        String ip = IPAddressUtil.getIPAddress(ctx.pathParam("ip")).toNormalizedString();
        Pageable pageable = new Pageable(ctx);
        QueryBuilder builder = new Orderable(Map.of("lastTimeSeen", false, "address", false, "port", true), ctx).addMapping("torrent.name", "torrentName").addMapping("torrent.infoHash", "torrentInfoHash").addMapping("torrent.size", "torrentSize").apply(this.peerRecordDao.queryBuilder().join(this.torrentDao.queryBuilder().setAlias("torrent"), QueryBuilder.JoinType.LEFT, QueryBuilder.JoinWhereOperation.AND));
        Where where = builder.where().eq("address", (Object)new SelectArg((Object)ip));
        builder.setWhere(where);
        Page page = this.peerRecordDao.queryByPaging(builder, pageable);
        ctx.json((Object)new StdResp(true, null, Page.map(page, entity -> new PeerRecordEntityDTO(entity.getId(), entity.getAddress(), entity.getPort(), TorrentEntityDTO.from(entity.getTorrent()), this.downloaderManager.getDownloadInfo(entity.getDownloader()), entity.getPeerId(), entity.getClientName(), entity.getUploaded(), entity.getUploadedOffset(), entity.getUploadSpeed(), entity.getDownloaded(), entity.getDownloadedOffset(), entity.getDownloadSpeed(), entity.getLastFlags(), entity.getFirstTimeSeen(), entity.getLastTimeSeen()))));
    }

    @Override
    public void onDisable() {
    }
}

