/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.monitor;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.alert.AlertLevel;
import com.ghostchu.peerbanhelper.alert.AlertManager;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.database.dao.impl.TrafficJournalDao;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.downloader.DownloaderFeatureFlag;
import com.ghostchu.peerbanhelper.downloader.DownloaderManagerImpl;
import com.ghostchu.peerbanhelper.downloader.DownloaderSpeedLimiter;
import com.ghostchu.peerbanhelper.downloader.DownloaderStatistics;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.MonitorFeatureModule;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import com.ghostchu.peerbanhelper.util.MsgUtil;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class ActiveMonitoringModule
extends AbstractFeatureModule
implements Reloadable,
MonitorFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActiveMonitoringModule.class);
    @Autowired
    private TrafficJournalDao trafficJournalDao;
    @Autowired
    private AlertManager alertManager;
    @Autowired
    private DownloaderManagerImpl downloaderManager;
    private long dailyTrafficCapping;
    private boolean useTrafficSlidingCapping;
    private long maxTrafficAllowedInWindowPeriod;
    private long trafficSlidingCappingMaxSpeed;
    private long trafficSlidingCappingMinSpeed;

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        return "Active Monitoring";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "active-monitoring";
    }

    @Override
    public void onEnable() {
        this.reloadConfig();
        CommonUtil.getScheduler().scheduleWithFixedDelay(this::updateTrafficStatus, 0L, 1L, TimeUnit.MINUTES);
        Main.getReloadManager().register((Reloadable)this);
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    private void reloadConfig() {
        this.dailyTrafficCapping = this.getConfig().getLong("traffic-monitoring.daily", -1L);
        this.useTrafficSlidingCapping = this.getConfig().getBoolean("traffic-sliding-capping.enabled");
        this.maxTrafficAllowedInWindowPeriod = this.getConfig().getLong("traffic-sliding-capping.daily-max-allowed-upload-traffic");
        this.trafficSlidingCappingMaxSpeed = this.getConfig().getLong("traffic-sliding-capping.max-speed");
        this.trafficSlidingCappingMinSpeed = this.getConfig().getLong("traffic-sliding-capping.min-speed");
    }

    private void updateTrafficStatus() {
        for (Downloader downloader : this.downloaderManager) {
            try {
                if (!downloader.login().success()) continue;
                DownloaderStatistics stats = downloader.getStatistics();
                this.trafficJournalDao.updateData(downloader.getId(), stats.totalDownloaded(), stats.totalUploaded(), 0L, 0L);
            }
            catch (Throwable e) {
                log.error("Unable to write hourly traffic journal to database", e);
            }
        }
        this.updateTrafficMonitoringService();
        this.updateTrafficCappingService();
    }

    private void updateTrafficCappingService() {
        if (!this.useTrafficSlidingCapping) {
            return;
        }
        for (Downloader downloader : this.downloaderManager) {
            try {
                DownloaderSpeedLimiter speedLimiter;
                if (!downloader.login().success() || (speedLimiter = downloader.getSpeedLimiter()) == null || !downloader.getFeatureFlags().contains((Object)DownloaderFeatureFlag.TRAFFIC_STATS)) continue;
                TrafficJournalDao.SlidingWindowDynamicSpeedLimiter calculatedData = this.trafficJournalDao.tweakSpeedLimiterBySlidingWindow(null, speedLimiter, this.maxTrafficAllowedInWindowPeriod, this.trafficSlidingCappingMinSpeed, this.trafficSlidingCappingMaxSpeed);
                DownloaderSpeedLimiter newLimiter = new DownloaderSpeedLimiter(calculatedData.getNewSpeedLimit(), speedLimiter.download());
                downloader.setSpeedLimiter(newLimiter);
                if (!Main.getMeta().isSnapshotOrBeta()) continue;
                log.info(TextManager.tlUI(Lang.MODULE_ACTIVE_MONITORING_SPEED_LIMITER_SLIDING_WINDOW_NEW_APPLIED, downloader.getName(), MsgUtil.humanReadableByteCountBin(newLimiter.upload()) + "/s", MsgUtil.humanReadableByteCountSI(newLimiter.upload()) + "/s", calculatedData));
            }
            catch (Throwable e) {
                log.error("Unable to update traffic settings followed by sliding window", e);
            }
        }
    }

    private void updateTrafficMonitoringService() {
        if (this.dailyTrafficCapping <= 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        long startOfToday = MiscUtil.getStartOfToday(now);
        TrafficJournalDao.TrafficDataComputed data = this.trafficJournalDao.getTodayData(null);
        long totalBytes = data.getDataOverallUploaded();
        String dateTimeString = MiscUtil.formatDateTime(now);
        String dateString = MiscUtil.formatDateOnly(now);
        String identifier = "dataTrafficCapping-" + startOfToday;
        if (totalBytes < this.dailyTrafficCapping) {
            return;
        }
        if (!this.alertManager.identifierAlertExistsIncludeRead(identifier)) {
            this.alertManager.publishAlert(true, AlertLevel.WARN, identifier, new TranslationComponent(Lang.MODULE_AMM_TRAFFIC_MONITORING_TRAFFIC_ALERT_TITLE, dateString), new TranslationComponent(Lang.MODULE_AMM_TRAFFIC_MONITORING_TRAFFIC_ALERT_DESCRIPTION, dateTimeString, MsgUtil.humanReadableByteCountBin(totalBytes), MsgUtil.humanReadableByteCountBin(this.dailyTrafficCapping)));
        }
    }

    @Override
    public void onDisable() {
        Main.getEventBus().unregister((Object)this);
        this.updateTrafficStatus();
        Main.getReloadManager().unregister((Reloadable)this);
    }

    @Override
    public void onTorrentPeersRetrieved(@NotNull Downloader downloader, @NotNull Torrent torrent, @NotNull List<Peer> peers) {
    }
}

