from collections import defaultdict, namedtuple

__all__ = ["devices", "devices_by_idcode", "devices_by_name"]

XPLA3Device = namedtuple("XPLA3Device", (
    "name", "idcode", "fb_cols", "fb_rows", "imux_width", "bs_cols",
    "global_bits", "ues_bits", "read_prot_bit", "io_mcs",
))

FbColumn = namedtuple("FbColumn", (
    "mc_col", "imux_col", "pt_col",
))

devices = [
    XPLA3Device("xcr3032xl", idcode=0x4808, fb_cols=[
        FbColumn(0, 10, 18),
    ], fb_rows=1, imux_width=8, bs_cols=114, global_bits=[
        (24, 1, 0), # FB_GROUP[0].UCT0[0]
        (24, 1, 1), # FB_GROUP[0].UCT0[1]
        (24, 1, 2), # FB_GROUP[0].UCT0[2]
        (25, 1, 0), # FB_GROUP[0].UCT1[0]
        (25, 1, 1), # FB_GROUP[0].UCT1[1]
        (25, 1, 2), # FB_GROUP[0].UCT1[2]
        (26, 1, 0), # FB_GROUP[0].UCT2[0]
        (26, 1, 1), # FB_GROUP[0].UCT2[1]
        (26, 1, 2), # FB_GROUP[0].UCT2[2]
        (27, 1, 0), # FB_GROUP[0].UCT3[0]
        (27, 1, 1), # FB_GROUP[0].UCT3[1]
        (27, 1, 2), # FB_GROUP[0].UCT3[2]
        (0, 0, 14), # FB_COL[0].ZIA_GCLK0_ENABLE[0]
        (0, 0, 15), # FB_COL[0].ZIA_GCLK1_ENABLE[0]
        (0, 0, 16), # FB_COL[0].ZIA_GCLK2_ENABLE[0]
        (0, 0, 17), # FB_COL[0].ZIA_GCLK3_ENABLE[0]
        (52, 1, 1), # ISP_DISABLE[0]
    ], ues_bits=[
        (53, 0, 5), # UES[0]
        (53, 0, 6), # UES[1]
        (53, 0, 7), # UES[2]
        (53, 0, 8), # UES[3]
        (53, 0, 9), # UES[4]
        (53, 0, 66), # UES[5]
        (53, 0, 67), # UES[6]
        (53, 0, 68), # UES[7]
        (53, 0, 69), # UES[8]
        (53, 0, 70), # UES[9]
        (53, 0, 71), # UES[10]
        (53, 0, 72), # UES[11]
        (53, 0, 73), # UES[12]
        (53, 0, 74), # UES[13]
        (53, 0, 75), # UES[14]
        (53, 0, 76), # UES[15]
        (53, 0, 77), # UES[16]
        (53, 0, 78), # UES[17]
        (53, 0, 79), # UES[18]
        (53, 0, 80), # UES[19]
        (53, 0, 81), # UES[20]
        (53, 0, 82), # UES[21]
        (53, 0, 83), # UES[22]
        (53, 0, 84), # UES[23]
        (53, 0, 85), # UES[24]
        (53, 0, 86), # UES[25]
        (53, 0, 87), # UES[26]
        (53, 0, 88), # UES[27]
        (53, 0, 89), # UES[28]
        (53, 0, 90), # UES[29]
        (53, 0, 91), # UES[30]
        (53, 0, 92), # UES[31]
        (53, 0, 93), # UES[32]
        (53, 0, 94), # UES[33]
        (53, 0, 95), # UES[34]
        (53, 0, 96), # UES[35]
        (53, 0, 97), # UES[36]
        (53, 0, 98), # UES[37]
        (53, 0, 99), # UES[38]
        (53, 0, 100), # UES[39]
        (53, 0, 101), # UES[40]
        (53, 0, 102), # UES[41]
        (53, 0, 103), # UES[42]
        (53, 0, 104), # UES[43]
        (53, 0, 105), # UES[44]
        (53, 0, 106), # UES[45]
        (53, 0, 107), # UES[46]
        (53, 0, 108), # UES[47]
        (53, 0, 109), # UES[48]
        (53, 0, 110), # UES[49]
        (53, 0, 111), # UES[50]
        (53, 0, 112), # UES[51]
        (53, 0, 113), # UES[52]
        (53, 1, 5), # UES[53]
        (53, 1, 6), # UES[54]
        (53, 1, 7), # UES[55]
        (53, 1, 8), # UES[56]
        (53, 1, 9), # UES[57]
        (53, 1, 66), # UES[58]
        (53, 1, 67), # UES[59]
        (53, 1, 68), # UES[60]
        (53, 1, 69), # UES[61]
        (53, 1, 70), # UES[62]
        (53, 1, 71), # UES[63]
        (53, 1, 72), # UES[64]
        (53, 1, 73), # UES[65]
        (53, 1, 74), # UES[66]
        (53, 1, 75), # UES[67]
        (53, 1, 76), # UES[68]
        (53, 1, 77), # UES[69]
        (53, 1, 78), # UES[70]
        (53, 1, 79), # UES[71]
        (53, 1, 80), # UES[72]
        (53, 1, 81), # UES[73]
        (53, 1, 82), # UES[74]
        (53, 1, 83), # UES[75]
        (53, 1, 84), # UES[76]
        (53, 1, 85), # UES[77]
        (53, 1, 86), # UES[78]
        (53, 1, 87), # UES[79]
        (53, 1, 88), # UES[80]
        (53, 1, 89), # UES[81]
        (53, 1, 90), # UES[82]
        (53, 1, 91), # UES[83]
        (53, 1, 92), # UES[84]
        (53, 1, 93), # UES[85]
        (53, 1, 94), # UES[86]
        (53, 1, 95), # UES[87]
        (53, 1, 96), # UES[88]
        (53, 1, 97), # UES[89]
        (53, 1, 98), # UES[90]
        (53, 1, 99), # UES[91]
        (53, 1, 100), # UES[92]
        (53, 1, 101), # UES[93]
        (53, 1, 102), # UES[94]
        (53, 1, 103), # UES[95]
        (53, 1, 104), # UES[96]
        (53, 1, 105), # UES[97]
        (53, 1, 106), # UES[98]
        (53, 1, 107), # UES[99]
        (53, 1, 108), # UES[100]
        (53, 1, 109), # UES[101]
        (53, 1, 110), # UES[102]
        (53, 1, 111), # UES[103]
        (53, 1, 112), # UES[104]
        (53, 1, 113), # UES[105]
    ], read_prot_bit=(52, 1, 0), io_mcs=[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]),
    XPLA3Device("xcr3064xl", idcode=0x4848, fb_cols=[
        FbColumn(0, 10, 27),
    ], fb_rows=2, imux_width=17, bs_cols=123, global_bits=[
        (76, 1, 0), # FB_GROUP[0].UCT0[0]
        (76, 1, 1), # FB_GROUP[0].UCT0[1]
        (76, 1, 2), # FB_GROUP[0].UCT0[2]
        (77, 1, 0), # FB_GROUP[0].UCT1[0]
        (77, 1, 1), # FB_GROUP[0].UCT1[1]
        (77, 1, 2), # FB_GROUP[0].UCT1[2]
        (78, 1, 0), # FB_GROUP[0].UCT2[0]
        (78, 1, 1), # FB_GROUP[0].UCT2[1]
        (78, 1, 2), # FB_GROUP[0].UCT2[2]
        (79, 1, 0), # FB_GROUP[0].UCT3[0]
        (79, 1, 1), # FB_GROUP[0].UCT3[1]
        (79, 1, 2), # FB_GROUP[0].UCT3[2]
        (0, 0, 23), # FB_COL[0].ZIA_GCLK0_ENABLE[0]
        (0, 0, 24), # FB_COL[0].ZIA_GCLK1_ENABLE[0]
        (0, 0, 25), # FB_COL[0].ZIA_GCLK2_ENABLE[0]
        (0, 0, 26), # FB_COL[0].ZIA_GCLK3_ENABLE[0]
        (104, 1, 1), # ISP_DISABLE[0]
    ], ues_bits=[
        (105, 0, 5), # UES[0]
        (105, 0, 6), # UES[1]
        (105, 0, 7), # UES[2]
        (105, 0, 8), # UES[3]
        (105, 0, 9), # UES[4]
        (105, 0, 75), # UES[5]
        (105, 0, 76), # UES[6]
        (105, 0, 77), # UES[7]
        (105, 0, 78), # UES[8]
        (105, 0, 79), # UES[9]
        (105, 0, 80), # UES[10]
        (105, 0, 81), # UES[11]
        (105, 0, 82), # UES[12]
        (105, 0, 83), # UES[13]
        (105, 0, 84), # UES[14]
        (105, 0, 85), # UES[15]
        (105, 0, 86), # UES[16]
        (105, 0, 87), # UES[17]
        (105, 0, 88), # UES[18]
        (105, 0, 89), # UES[19]
        (105, 0, 90), # UES[20]
        (105, 0, 91), # UES[21]
        (105, 0, 92), # UES[22]
        (105, 0, 93), # UES[23]
        (105, 0, 94), # UES[24]
        (105, 0, 95), # UES[25]
        (105, 0, 96), # UES[26]
        (105, 0, 97), # UES[27]
        (105, 0, 98), # UES[28]
        (105, 0, 99), # UES[29]
        (105, 0, 100), # UES[30]
        (105, 0, 101), # UES[31]
        (105, 0, 102), # UES[32]
        (105, 0, 103), # UES[33]
        (105, 0, 104), # UES[34]
        (105, 0, 105), # UES[35]
        (105, 0, 106), # UES[36]
        (105, 0, 107), # UES[37]
        (105, 0, 108), # UES[38]
        (105, 0, 109), # UES[39]
        (105, 0, 110), # UES[40]
        (105, 0, 111), # UES[41]
        (105, 0, 112), # UES[42]
        (105, 0, 113), # UES[43]
        (105, 0, 114), # UES[44]
        (105, 0, 115), # UES[45]
        (105, 0, 116), # UES[46]
        (105, 0, 117), # UES[47]
        (105, 0, 118), # UES[48]
        (105, 0, 119), # UES[49]
        (105, 0, 120), # UES[50]
        (105, 0, 121), # UES[51]
        (105, 0, 122), # UES[52]
        (105, 1, 5), # UES[53]
        (105, 1, 6), # UES[54]
        (105, 1, 7), # UES[55]
        (105, 1, 8), # UES[56]
        (105, 1, 9), # UES[57]
        (105, 1, 75), # UES[58]
        (105, 1, 76), # UES[59]
        (105, 1, 77), # UES[60]
        (105, 1, 78), # UES[61]
        (105, 1, 79), # UES[62]
        (105, 1, 80), # UES[63]
        (105, 1, 81), # UES[64]
        (105, 1, 82), # UES[65]
        (105, 1, 83), # UES[66]
        (105, 1, 84), # UES[67]
        (105, 1, 85), # UES[68]
        (105, 1, 86), # UES[69]
        (105, 1, 87), # UES[70]
        (105, 1, 88), # UES[71]
        (105, 1, 89), # UES[72]
        (105, 1, 90), # UES[73]
        (105, 1, 91), # UES[74]
        (105, 1, 92), # UES[75]
        (105, 1, 93), # UES[76]
        (105, 1, 94), # UES[77]
        (105, 1, 95), # UES[78]
        (105, 1, 96), # UES[79]
        (105, 1, 97), # UES[80]
        (105, 1, 98), # UES[81]
        (105, 1, 99), # UES[82]
        (105, 1, 100), # UES[83]
        (105, 1, 101), # UES[84]
        (105, 1, 102), # UES[85]
        (105, 1, 103), # UES[86]
        (105, 1, 104), # UES[87]
        (105, 1, 105), # UES[88]
        (105, 1, 106), # UES[89]
        (105, 1, 107), # UES[90]
        (105, 1, 108), # UES[91]
        (105, 1, 109), # UES[92]
        (105, 1, 110), # UES[93]
        (105, 1, 111), # UES[94]
        (105, 1, 112), # UES[95]
        (105, 1, 113), # UES[96]
        (105, 1, 114), # UES[97]
        (105, 1, 115), # UES[98]
        (105, 1, 116), # UES[99]
        (105, 1, 117), # UES[100]
        (105, 1, 118), # UES[101]
        (105, 1, 119), # UES[102]
        (105, 1, 120), # UES[103]
        (105, 1, 121), # UES[104]
        (105, 1, 122), # UES[105]
    ], read_prot_bit=(104, 1, 0), io_mcs=[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]),
    XPLA3Device("xcr3128xl", idcode=0x4888, fb_cols=[
        FbColumn(0, 20, 74),
        FbColumn(10, 47, 170),
    ], fb_rows=2, imux_width=27, bs_cols=266, global_bits=[
        (76, 1, 10), # FB_GROUP[0].UCT0[0]
        (76, 1, 11), # FB_GROUP[0].UCT0[1]
        (76, 1, 12), # FB_GROUP[0].UCT0[2]
        (76, 1, 13), # FB_GROUP[0].UCT0[3]
        (77, 1, 10), # FB_GROUP[0].UCT1[0]
        (77, 1, 11), # FB_GROUP[0].UCT1[1]
        (77, 1, 12), # FB_GROUP[0].UCT1[2]
        (77, 1, 13), # FB_GROUP[0].UCT1[3]
        (78, 1, 10), # FB_GROUP[0].UCT2[0]
        (78, 1, 11), # FB_GROUP[0].UCT2[1]
        (78, 1, 12), # FB_GROUP[0].UCT2[2]
        (78, 1, 13), # FB_GROUP[0].UCT2[3]
        (79, 1, 10), # FB_GROUP[0].UCT3[0]
        (79, 1, 11), # FB_GROUP[0].UCT3[1]
        (79, 1, 12), # FB_GROUP[0].UCT3[2]
        (79, 1, 13), # FB_GROUP[0].UCT3[3]
        (0, 0, 43), # FB_COL[0].ZIA_GCLK0_ENABLE[0]
        (0, 0, 44), # FB_COL[0].ZIA_GCLK1_ENABLE[0]
        (0, 0, 45), # FB_COL[0].ZIA_GCLK2_ENABLE[0]
        (0, 0, 46), # FB_COL[0].ZIA_GCLK3_ENABLE[0]
        (0, 0, 70), # FB_COL[1].ZIA_GCLK0_ENABLE[0]
        (0, 0, 71), # FB_COL[1].ZIA_GCLK1_ENABLE[0]
        (0, 0, 72), # FB_COL[1].ZIA_GCLK2_ENABLE[0]
        (0, 0, 73), # FB_COL[1].ZIA_GCLK3_ENABLE[0]
        (104, 1, 1), # ISP_DISABLE[0]
    ], ues_bits=[
        (105, 0, 5), # UES[0]
        (105, 0, 6), # UES[1]
        (105, 0, 7), # UES[2]
        (105, 0, 8), # UES[3]
        (105, 0, 9), # UES[4]
        (105, 0, 10), # UES[5]
        (105, 0, 11), # UES[6]
        (105, 0, 12), # UES[7]
        (105, 0, 13), # UES[8]
        (105, 0, 14), # UES[9]
        (105, 0, 15), # UES[10]
        (105, 0, 16), # UES[11]
        (105, 0, 17), # UES[12]
        (105, 0, 18), # UES[13]
        (105, 0, 19), # UES[14]
        (105, 0, 47), # UES[15]
        (105, 0, 48), # UES[16]
        (105, 0, 49), # UES[17]
        (105, 0, 50), # UES[18]
        (105, 0, 51), # UES[19]
        (105, 0, 52), # UES[20]
        (105, 0, 53), # UES[21]
        (105, 0, 54), # UES[22]
        (105, 0, 55), # UES[23]
        (105, 0, 56), # UES[24]
        (105, 0, 57), # UES[25]
        (105, 0, 58), # UES[26]
        (105, 0, 59), # UES[27]
        (105, 0, 60), # UES[28]
        (105, 0, 61), # UES[29]
        (105, 0, 62), # UES[30]
        (105, 0, 63), # UES[31]
        (105, 0, 64), # UES[32]
        (105, 0, 65), # UES[33]
        (105, 0, 66), # UES[34]
        (105, 0, 67), # UES[35]
        (105, 0, 68), # UES[36]
        (105, 0, 69), # UES[37]
        (105, 0, 70), # UES[38]
        (105, 0, 71), # UES[39]
        (105, 0, 72), # UES[40]
        (105, 0, 73), # UES[41]
        (105, 0, 170), # UES[42]
        (105, 0, 171), # UES[43]
        (105, 0, 172), # UES[44]
        (105, 0, 173), # UES[45]
        (105, 0, 174), # UES[46]
        (105, 0, 175), # UES[47]
        (105, 0, 176), # UES[48]
        (105, 0, 177), # UES[49]
        (105, 0, 178), # UES[50]
        (105, 0, 179), # UES[51]
        (105, 0, 180), # UES[52]
        (105, 0, 181), # UES[53]
        (105, 0, 182), # UES[54]
        (105, 0, 183), # UES[55]
        (105, 0, 184), # UES[56]
        (105, 0, 185), # UES[57]
        (105, 0, 186), # UES[58]
        (105, 0, 187), # UES[59]
        (105, 0, 188), # UES[60]
        (105, 0, 189), # UES[61]
        (105, 0, 190), # UES[62]
        (105, 0, 191), # UES[63]
        (105, 0, 192), # UES[64]
        (105, 0, 193), # UES[65]
        (105, 0, 194), # UES[66]
        (105, 0, 195), # UES[67]
        (105, 0, 196), # UES[68]
        (105, 0, 197), # UES[69]
        (105, 0, 198), # UES[70]
        (105, 0, 199), # UES[71]
        (105, 0, 200), # UES[72]
        (105, 0, 201), # UES[73]
        (105, 0, 202), # UES[74]
        (105, 0, 203), # UES[75]
        (105, 0, 204), # UES[76]
        (105, 0, 205), # UES[77]
        (105, 0, 206), # UES[78]
        (105, 0, 207), # UES[79]
        (105, 0, 208), # UES[80]
        (105, 0, 209), # UES[81]
        (105, 0, 210), # UES[82]
        (105, 0, 211), # UES[83]
        (105, 0, 212), # UES[84]
        (105, 0, 213), # UES[85]
        (105, 0, 214), # UES[86]
        (105, 0, 215), # UES[87]
        (105, 0, 216), # UES[88]
        (105, 0, 217), # UES[89]
        (105, 0, 218), # UES[90]
        (105, 0, 219), # UES[91]
        (105, 0, 220), # UES[92]
        (105, 0, 221), # UES[93]
        (105, 0, 222), # UES[94]
        (105, 0, 223), # UES[95]
        (105, 0, 224), # UES[96]
        (105, 0, 225), # UES[97]
        (105, 0, 226), # UES[98]
        (105, 0, 227), # UES[99]
        (105, 0, 228), # UES[100]
        (105, 0, 229), # UES[101]
        (105, 0, 230), # UES[102]
        (105, 0, 231), # UES[103]
        (105, 0, 232), # UES[104]
        (105, 0, 233), # UES[105]
        (105, 0, 234), # UES[106]
        (105, 0, 235), # UES[107]
        (105, 0, 236), # UES[108]
        (105, 0, 237), # UES[109]
        (105, 0, 238), # UES[110]
        (105, 0, 239), # UES[111]
        (105, 0, 240), # UES[112]
        (105, 0, 241), # UES[113]
        (105, 0, 242), # UES[114]
        (105, 0, 243), # UES[115]
        (105, 0, 244), # UES[116]
        (105, 0, 245), # UES[117]
        (105, 0, 246), # UES[118]
        (105, 0, 247), # UES[119]
        (105, 0, 248), # UES[120]
        (105, 0, 249), # UES[121]
        (105, 0, 250), # UES[122]
        (105, 0, 251), # UES[123]
        (105, 0, 252), # UES[124]
        (105, 0, 253), # UES[125]
        (105, 0, 254), # UES[126]
        (105, 0, 255), # UES[127]
        (105, 0, 256), # UES[128]
        (105, 0, 257), # UES[129]
        (105, 0, 258), # UES[130]
        (105, 0, 259), # UES[131]
        (105, 0, 260), # UES[132]
        (105, 0, 261), # UES[133]
        (105, 0, 262), # UES[134]
        (105, 0, 263), # UES[135]
        (105, 0, 264), # UES[136]
        (105, 0, 265), # UES[137]
        (105, 1, 5), # UES[138]
        (105, 1, 6), # UES[139]
        (105, 1, 7), # UES[140]
        (105, 1, 8), # UES[141]
        (105, 1, 9), # UES[142]
        (105, 1, 10), # UES[143]
        (105, 1, 11), # UES[144]
        (105, 1, 12), # UES[145]
        (105, 1, 13), # UES[146]
        (105, 1, 14), # UES[147]
        (105, 1, 15), # UES[148]
        (105, 1, 16), # UES[149]
        (105, 1, 17), # UES[150]
        (105, 1, 18), # UES[151]
        (105, 1, 19), # UES[152]
        (105, 1, 47), # UES[153]
        (105, 1, 48), # UES[154]
        (105, 1, 49), # UES[155]
        (105, 1, 50), # UES[156]
        (105, 1, 51), # UES[157]
        (105, 1, 52), # UES[158]
        (105, 1, 53), # UES[159]
        (105, 1, 54), # UES[160]
        (105, 1, 55), # UES[161]
        (105, 1, 56), # UES[162]
        (105, 1, 57), # UES[163]
        (105, 1, 58), # UES[164]
        (105, 1, 59), # UES[165]
        (105, 1, 60), # UES[166]
        (105, 1, 61), # UES[167]
        (105, 1, 62), # UES[168]
        (105, 1, 63), # UES[169]
        (105, 1, 64), # UES[170]
        (105, 1, 65), # UES[171]
        (105, 1, 66), # UES[172]
        (105, 1, 67), # UES[173]
        (105, 1, 68), # UES[174]
        (105, 1, 69), # UES[175]
        (105, 1, 70), # UES[176]
        (105, 1, 71), # UES[177]
        (105, 1, 72), # UES[178]
        (105, 1, 73), # UES[179]
        (105, 1, 170), # UES[180]
        (105, 1, 171), # UES[181]
        (105, 1, 172), # UES[182]
        (105, 1, 173), # UES[183]
        (105, 1, 174), # UES[184]
        (105, 1, 175), # UES[185]
        (105, 1, 176), # UES[186]
        (105, 1, 177), # UES[187]
        (105, 1, 178), # UES[188]
        (105, 1, 179), # UES[189]
        (105, 1, 180), # UES[190]
        (105, 1, 181), # UES[191]
        (105, 1, 182), # UES[192]
        (105, 1, 183), # UES[193]
        (105, 1, 184), # UES[194]
        (105, 1, 185), # UES[195]
        (105, 1, 186), # UES[196]
        (105, 1, 187), # UES[197]
        (105, 1, 188), # UES[198]
        (105, 1, 189), # UES[199]
        (105, 1, 190), # UES[200]
        (105, 1, 191), # UES[201]
        (105, 1, 192), # UES[202]
        (105, 1, 193), # UES[203]
        (105, 1, 194), # UES[204]
        (105, 1, 195), # UES[205]
        (105, 1, 196), # UES[206]
        (105, 1, 197), # UES[207]
        (105, 1, 198), # UES[208]
        (105, 1, 199), # UES[209]
        (105, 1, 200), # UES[210]
        (105, 1, 201), # UES[211]
        (105, 1, 202), # UES[212]
        (105, 1, 203), # UES[213]
        (105, 1, 204), # UES[214]
        (105, 1, 205), # UES[215]
        (105, 1, 206), # UES[216]
        (105, 1, 207), # UES[217]
        (105, 1, 208), # UES[218]
        (105, 1, 209), # UES[219]
        (105, 1, 210), # UES[220]
        (105, 1, 211), # UES[221]
        (105, 1, 212), # UES[222]
        (105, 1, 213), # UES[223]
        (105, 1, 214), # UES[224]
        (105, 1, 215), # UES[225]
        (105, 1, 216), # UES[226]
        (105, 1, 217), # UES[227]
        (105, 1, 218), # UES[228]
        (105, 1, 219), # UES[229]
        (105, 1, 220), # UES[230]
        (105, 1, 221), # UES[231]
        (105, 1, 222), # UES[232]
        (105, 1, 223), # UES[233]
        (105, 1, 224), # UES[234]
        (105, 1, 225), # UES[235]
        (105, 1, 226), # UES[236]
        (105, 1, 227), # UES[237]
        (105, 1, 228), # UES[238]
        (105, 1, 229), # UES[239]
        (105, 1, 230), # UES[240]
        (105, 1, 231), # UES[241]
        (105, 1, 232), # UES[242]
        (105, 1, 233), # UES[243]
        (105, 1, 234), # UES[244]
        (105, 1, 235), # UES[245]
        (105, 1, 236), # UES[246]
        (105, 1, 237), # UES[247]
        (105, 1, 238), # UES[248]
        (105, 1, 239), # UES[249]
        (105, 1, 240), # UES[250]
        (105, 1, 241), # UES[251]
        (105, 1, 242), # UES[252]
        (105, 1, 243), # UES[253]
        (105, 1, 244), # UES[254]
        (105, 1, 245), # UES[255]
        (105, 1, 246), # UES[256]
        (105, 1, 247), # UES[257]
        (105, 1, 248), # UES[258]
        (105, 1, 249), # UES[259]
        (105, 1, 250), # UES[260]
        (105, 1, 251), # UES[261]
        (105, 1, 252), # UES[262]
        (105, 1, 253), # UES[263]
        (105, 1, 254), # UES[264]
        (105, 1, 255), # UES[265]
        (105, 1, 256), # UES[266]
        (105, 1, 257), # UES[267]
        (105, 1, 258), # UES[268]
        (105, 1, 259), # UES[269]
        (105, 1, 260), # UES[270]
        (105, 1, 261), # UES[271]
        (105, 1, 262), # UES[272]
        (105, 1, 263), # UES[273]
        (105, 1, 264), # UES[274]
        (105, 1, 265), # UES[275]
    ], read_prot_bit=(104, 1, 0), io_mcs=[0, 1, 2, 3, 4, 5, 6, 10, 11, 12, 13, 14, 15]),
    XPLA3Device("xcr3256xl", idcode=0x4948, fb_cols=[
        FbColumn(0, 20, 112),
        FbColumn(10, 66, 208),
    ], fb_rows=4, imux_width=46, bs_cols=304, global_bits=[
        (76, 1, 10), # FB_GROUP[0].UCT0[0]
        (76, 1, 11), # FB_GROUP[0].UCT0[1]
        (76, 1, 12), # FB_GROUP[0].UCT0[2]
        (76, 1, 13), # FB_GROUP[0].UCT0[3]
        (76, 1, 14), # FB_GROUP[0].UCT0[4]
        (77, 1, 10), # FB_GROUP[0].UCT1[0]
        (77, 1, 11), # FB_GROUP[0].UCT1[1]
        (77, 1, 12), # FB_GROUP[0].UCT1[2]
        (77, 1, 13), # FB_GROUP[0].UCT1[3]
        (77, 1, 14), # FB_GROUP[0].UCT1[4]
        (78, 1, 10), # FB_GROUP[0].UCT2[0]
        (78, 1, 11), # FB_GROUP[0].UCT2[1]
        (78, 1, 12), # FB_GROUP[0].UCT2[2]
        (78, 1, 13), # FB_GROUP[0].UCT2[3]
        (78, 1, 14), # FB_GROUP[0].UCT2[4]
        (79, 1, 10), # FB_GROUP[0].UCT3[0]
        (79, 1, 11), # FB_GROUP[0].UCT3[1]
        (79, 1, 12), # FB_GROUP[0].UCT3[2]
        (79, 1, 13), # FB_GROUP[0].UCT3[3]
        (79, 1, 14), # FB_GROUP[0].UCT3[4]
        (0, 0, 62), # FB_COL[0].ZIA_GCLK0_ENABLE[0]
        (0, 0, 63), # FB_COL[0].ZIA_GCLK1_ENABLE[0]
        (0, 0, 64), # FB_COL[0].ZIA_GCLK2_ENABLE[0]
        (0, 0, 65), # FB_COL[0].ZIA_GCLK3_ENABLE[0]
        (0, 0, 108), # FB_COL[1].ZIA_GCLK0_ENABLE[0]
        (0, 0, 109), # FB_COL[1].ZIA_GCLK1_ENABLE[0]
        (0, 0, 110), # FB_COL[1].ZIA_GCLK2_ENABLE[0]
        (0, 0, 111), # FB_COL[1].ZIA_GCLK3_ENABLE[0]
        (208, 1, 1), # ISP_DISABLE[0]
    ], ues_bits=[
        (209, 0, 5), # UES[0]
        (209, 0, 6), # UES[1]
        (209, 0, 7), # UES[2]
        (209, 0, 8), # UES[3]
        (209, 0, 9), # UES[4]
        (209, 0, 10), # UES[5]
        (209, 0, 11), # UES[6]
        (209, 0, 12), # UES[7]
        (209, 0, 13), # UES[8]
        (209, 0, 14), # UES[9]
        (209, 0, 15), # UES[10]
        (209, 0, 16), # UES[11]
        (209, 0, 17), # UES[12]
        (209, 0, 18), # UES[13]
        (209, 0, 19), # UES[14]
        (209, 0, 66), # UES[15]
        (209, 0, 67), # UES[16]
        (209, 0, 68), # UES[17]
        (209, 0, 69), # UES[18]
        (209, 0, 70), # UES[19]
        (209, 0, 71), # UES[20]
        (209, 0, 72), # UES[21]
        (209, 0, 73), # UES[22]
        (209, 0, 74), # UES[23]
        (209, 0, 75), # UES[24]
        (209, 0, 76), # UES[25]
        (209, 0, 77), # UES[26]
        (209, 0, 78), # UES[27]
        (209, 0, 79), # UES[28]
        (209, 0, 80), # UES[29]
        (209, 0, 81), # UES[30]
        (209, 0, 82), # UES[31]
        (209, 0, 83), # UES[32]
        (209, 0, 84), # UES[33]
        (209, 0, 85), # UES[34]
        (209, 0, 86), # UES[35]
        (209, 0, 87), # UES[36]
        (209, 0, 88), # UES[37]
        (209, 0, 89), # UES[38]
        (209, 0, 90), # UES[39]
        (209, 0, 91), # UES[40]
        (209, 0, 92), # UES[41]
        (209, 0, 93), # UES[42]
        (209, 0, 94), # UES[43]
        (209, 0, 95), # UES[44]
        (209, 0, 96), # UES[45]
        (209, 0, 97), # UES[46]
        (209, 0, 98), # UES[47]
        (209, 0, 99), # UES[48]
        (209, 0, 100), # UES[49]
        (209, 0, 101), # UES[50]
        (209, 0, 102), # UES[51]
        (209, 0, 103), # UES[52]
        (209, 0, 104), # UES[53]
        (209, 0, 105), # UES[54]
        (209, 0, 106), # UES[55]
        (209, 0, 107), # UES[56]
        (209, 0, 108), # UES[57]
        (209, 0, 109), # UES[58]
        (209, 0, 110), # UES[59]
        (209, 0, 111), # UES[60]
        (209, 0, 208), # UES[61]
        (209, 0, 209), # UES[62]
        (209, 0, 210), # UES[63]
        (209, 0, 211), # UES[64]
        (209, 0, 212), # UES[65]
        (209, 0, 213), # UES[66]
        (209, 0, 214), # UES[67]
        (209, 0, 215), # UES[68]
        (209, 0, 216), # UES[69]
        (209, 0, 217), # UES[70]
        (209, 0, 218), # UES[71]
        (209, 0, 219), # UES[72]
        (209, 0, 220), # UES[73]
        (209, 0, 221), # UES[74]
        (209, 0, 222), # UES[75]
        (209, 0, 223), # UES[76]
        (209, 0, 224), # UES[77]
        (209, 0, 225), # UES[78]
        (209, 0, 226), # UES[79]
        (209, 0, 227), # UES[80]
        (209, 0, 228), # UES[81]
        (209, 0, 229), # UES[82]
        (209, 0, 230), # UES[83]
        (209, 0, 231), # UES[84]
        (209, 0, 232), # UES[85]
        (209, 0, 233), # UES[86]
        (209, 0, 234), # UES[87]
        (209, 0, 235), # UES[88]
        (209, 0, 236), # UES[89]
        (209, 0, 237), # UES[90]
        (209, 0, 238), # UES[91]
        (209, 0, 239), # UES[92]
        (209, 0, 240), # UES[93]
        (209, 0, 241), # UES[94]
        (209, 0, 242), # UES[95]
        (209, 0, 243), # UES[96]
        (209, 0, 244), # UES[97]
        (209, 0, 245), # UES[98]
        (209, 0, 246), # UES[99]
        (209, 0, 247), # UES[100]
        (209, 0, 248), # UES[101]
        (209, 0, 249), # UES[102]
        (209, 0, 250), # UES[103]
        (209, 0, 251), # UES[104]
        (209, 0, 252), # UES[105]
        (209, 0, 253), # UES[106]
        (209, 0, 254), # UES[107]
        (209, 0, 255), # UES[108]
        (209, 0, 256), # UES[109]
        (209, 0, 257), # UES[110]
        (209, 0, 258), # UES[111]
        (209, 0, 259), # UES[112]
        (209, 0, 260), # UES[113]
        (209, 0, 261), # UES[114]
        (209, 0, 262), # UES[115]
        (209, 0, 263), # UES[116]
        (209, 0, 264), # UES[117]
        (209, 0, 265), # UES[118]
        (209, 0, 266), # UES[119]
        (209, 0, 267), # UES[120]
        (209, 0, 268), # UES[121]
        (209, 0, 269), # UES[122]
        (209, 0, 270), # UES[123]
        (209, 0, 271), # UES[124]
        (209, 0, 272), # UES[125]
        (209, 0, 273), # UES[126]
        (209, 0, 274), # UES[127]
        (209, 0, 275), # UES[128]
        (209, 0, 276), # UES[129]
        (209, 0, 277), # UES[130]
        (209, 0, 278), # UES[131]
        (209, 0, 279), # UES[132]
        (209, 0, 280), # UES[133]
        (209, 0, 281), # UES[134]
        (209, 0, 282), # UES[135]
        (209, 0, 283), # UES[136]
        (209, 0, 284), # UES[137]
        (209, 0, 285), # UES[138]
        (209, 0, 286), # UES[139]
        (209, 0, 287), # UES[140]
        (209, 0, 288), # UES[141]
        (209, 0, 289), # UES[142]
        (209, 0, 290), # UES[143]
        (209, 0, 291), # UES[144]
        (209, 0, 292), # UES[145]
        (209, 0, 293), # UES[146]
        (209, 0, 294), # UES[147]
        (209, 0, 295), # UES[148]
        (209, 0, 296), # UES[149]
        (209, 0, 297), # UES[150]
        (209, 0, 298), # UES[151]
        (209, 0, 299), # UES[152]
        (209, 0, 300), # UES[153]
        (209, 0, 301), # UES[154]
        (209, 0, 302), # UES[155]
        (209, 0, 303), # UES[156]
        (209, 1, 5), # UES[157]
        (209, 1, 6), # UES[158]
        (209, 1, 7), # UES[159]
        (209, 1, 8), # UES[160]
        (209, 1, 9), # UES[161]
        (209, 1, 10), # UES[162]
        (209, 1, 11), # UES[163]
        (209, 1, 12), # UES[164]
        (209, 1, 13), # UES[165]
        (209, 1, 14), # UES[166]
        (209, 1, 15), # UES[167]
        (209, 1, 16), # UES[168]
        (209, 1, 17), # UES[169]
        (209, 1, 18), # UES[170]
        (209, 1, 19), # UES[171]
        (209, 1, 66), # UES[172]
        (209, 1, 67), # UES[173]
        (209, 1, 68), # UES[174]
        (209, 1, 69), # UES[175]
        (209, 1, 70), # UES[176]
        (209, 1, 71), # UES[177]
        (209, 1, 72), # UES[178]
        (209, 1, 73), # UES[179]
        (209, 1, 74), # UES[180]
        (209, 1, 75), # UES[181]
        (209, 1, 76), # UES[182]
        (209, 1, 77), # UES[183]
        (209, 1, 78), # UES[184]
        (209, 1, 79), # UES[185]
        (209, 1, 80), # UES[186]
        (209, 1, 81), # UES[187]
        (209, 1, 82), # UES[188]
        (209, 1, 83), # UES[189]
        (209, 1, 84), # UES[190]
        (209, 1, 85), # UES[191]
        (209, 1, 86), # UES[192]
        (209, 1, 87), # UES[193]
        (209, 1, 88), # UES[194]
        (209, 1, 89), # UES[195]
        (209, 1, 90), # UES[196]
        (209, 1, 91), # UES[197]
        (209, 1, 92), # UES[198]
        (209, 1, 93), # UES[199]
        (209, 1, 94), # UES[200]
        (209, 1, 95), # UES[201]
        (209, 1, 96), # UES[202]
        (209, 1, 97), # UES[203]
        (209, 1, 98), # UES[204]
        (209, 1, 99), # UES[205]
        (209, 1, 100), # UES[206]
        (209, 1, 101), # UES[207]
        (209, 1, 102), # UES[208]
        (209, 1, 103), # UES[209]
        (209, 1, 104), # UES[210]
        (209, 1, 105), # UES[211]
        (209, 1, 106), # UES[212]
        (209, 1, 107), # UES[213]
        (209, 1, 108), # UES[214]
        (209, 1, 109), # UES[215]
        (209, 1, 110), # UES[216]
        (209, 1, 111), # UES[217]
        (209, 1, 208), # UES[218]
        (209, 1, 209), # UES[219]
        (209, 1, 210), # UES[220]
        (209, 1, 211), # UES[221]
        (209, 1, 212), # UES[222]
        (209, 1, 213), # UES[223]
        (209, 1, 214), # UES[224]
        (209, 1, 215), # UES[225]
        (209, 1, 216), # UES[226]
        (209, 1, 217), # UES[227]
        (209, 1, 218), # UES[228]
        (209, 1, 219), # UES[229]
        (209, 1, 220), # UES[230]
        (209, 1, 221), # UES[231]
        (209, 1, 222), # UES[232]
        (209, 1, 223), # UES[233]
        (209, 1, 224), # UES[234]
        (209, 1, 225), # UES[235]
        (209, 1, 226), # UES[236]
        (209, 1, 227), # UES[237]
        (209, 1, 228), # UES[238]
        (209, 1, 229), # UES[239]
        (209, 1, 230), # UES[240]
        (209, 1, 231), # UES[241]
        (209, 1, 232), # UES[242]
        (209, 1, 233), # UES[243]
        (209, 1, 234), # UES[244]
        (209, 1, 235), # UES[245]
        (209, 1, 236), # UES[246]
        (209, 1, 237), # UES[247]
        (209, 1, 238), # UES[248]
        (209, 1, 239), # UES[249]
        (209, 1, 240), # UES[250]
        (209, 1, 241), # UES[251]
        (209, 1, 242), # UES[252]
        (209, 1, 243), # UES[253]
        (209, 1, 244), # UES[254]
        (209, 1, 245), # UES[255]
        (209, 1, 246), # UES[256]
        (209, 1, 247), # UES[257]
        (209, 1, 248), # UES[258]
        (209, 1, 249), # UES[259]
        (209, 1, 250), # UES[260]
        (209, 1, 251), # UES[261]
        (209, 1, 252), # UES[262]
        (209, 1, 253), # UES[263]
        (209, 1, 254), # UES[264]
        (209, 1, 255), # UES[265]
        (209, 1, 256), # UES[266]
        (209, 1, 257), # UES[267]
        (209, 1, 258), # UES[268]
        (209, 1, 259), # UES[269]
        (209, 1, 260), # UES[270]
        (209, 1, 261), # UES[271]
        (209, 1, 262), # UES[272]
        (209, 1, 263), # UES[273]
        (209, 1, 264), # UES[274]
        (209, 1, 265), # UES[275]
        (209, 1, 266), # UES[276]
        (209, 1, 267), # UES[277]
        (209, 1, 268), # UES[278]
        (209, 1, 269), # UES[279]
        (209, 1, 270), # UES[280]
        (209, 1, 271), # UES[281]
        (209, 1, 272), # UES[282]
        (209, 1, 273), # UES[283]
        (209, 1, 274), # UES[284]
        (209, 1, 275), # UES[285]
        (209, 1, 276), # UES[286]
        (209, 1, 277), # UES[287]
        (209, 1, 278), # UES[288]
        (209, 1, 279), # UES[289]
        (209, 1, 280), # UES[290]
        (209, 1, 281), # UES[291]
        (209, 1, 282), # UES[292]
        (209, 1, 283), # UES[293]
        (209, 1, 284), # UES[294]
        (209, 1, 285), # UES[295]
        (209, 1, 286), # UES[296]
        (209, 1, 287), # UES[297]
        (209, 1, 288), # UES[298]
        (209, 1, 289), # UES[299]
        (209, 1, 290), # UES[300]
        (209, 1, 291), # UES[301]
        (209, 1, 292), # UES[302]
        (209, 1, 293), # UES[303]
        (209, 1, 294), # UES[304]
        (209, 1, 295), # UES[305]
        (209, 1, 296), # UES[306]
        (209, 1, 297), # UES[307]
        (209, 1, 298), # UES[308]
        (209, 1, 299), # UES[309]
        (209, 1, 300), # UES[310]
        (209, 1, 301), # UES[311]
        (209, 1, 302), # UES[312]
        (209, 1, 303), # UES[313]
    ], read_prot_bit=(208, 1, 0), io_mcs=[0, 1, 2, 3, 4, 11, 12, 13, 14, 15]),
    XPLA3Device("xcr3384xl", idcode=0x4958, fb_cols=[
        FbColumn(0, 30, 219),
        FbColumn(10, 93, 315),
        FbColumn(20, 156, 411),
    ], fb_rows=4, imux_width=63, bs_cols=507, global_bits=[
        (102, 1, 118), # FB_GROUP[0].UCT0[0]
        (102, 1, 119), # FB_GROUP[0].UCT0[1]
        (102, 1, 120), # FB_GROUP[0].UCT0[2]
        (102, 1, 121), # FB_GROUP[0].UCT0[3]
        (102, 1, 122), # FB_GROUP[0].UCT0[4]
        (103, 1, 118), # FB_GROUP[0].UCT1[0]
        (103, 1, 119), # FB_GROUP[0].UCT1[1]
        (103, 1, 120), # FB_GROUP[0].UCT1[2]
        (103, 1, 121), # FB_GROUP[0].UCT1[3]
        (103, 1, 122), # FB_GROUP[0].UCT1[4]
        (104, 1, 118), # FB_GROUP[0].UCT2[0]
        (104, 1, 119), # FB_GROUP[0].UCT2[1]
        (104, 1, 120), # FB_GROUP[0].UCT2[2]
        (104, 1, 121), # FB_GROUP[0].UCT2[3]
        (104, 1, 122), # FB_GROUP[0].UCT2[4]
        (105, 1, 118), # FB_GROUP[0].UCT3[0]
        (105, 1, 119), # FB_GROUP[0].UCT3[1]
        (105, 1, 120), # FB_GROUP[0].UCT3[2]
        (105, 1, 121), # FB_GROUP[0].UCT3[3]
        (105, 1, 122), # FB_GROUP[0].UCT3[4]
        (0, 1, 55), # FB_COL[0].ZIA_GCLK0_ENABLE[0]
        (0, 1, 56), # FB_COL[0].ZIA_GCLK1_ENABLE[0]
        (0, 1, 57), # FB_COL[0].ZIA_GCLK2_ENABLE[0]
        (0, 1, 58), # FB_COL[0].ZIA_GCLK3_ENABLE[0]
        (0, 1, 118), # FB_COL[1].ZIA_GCLK0_ENABLE[0]
        (0, 1, 119), # FB_COL[1].ZIA_GCLK1_ENABLE[0]
        (0, 1, 120), # FB_COL[1].ZIA_GCLK2_ENABLE[0]
        (0, 1, 121), # FB_COL[1].ZIA_GCLK3_ENABLE[0]
        (0, 1, 181), # FB_COL[2].ZIA_GCLK0_ENABLE[0]
        (0, 1, 182), # FB_COL[2].ZIA_GCLK1_ENABLE[0]
        (0, 1, 183), # FB_COL[2].ZIA_GCLK2_ENABLE[0]
        (0, 1, 184), # FB_COL[2].ZIA_GCLK3_ENABLE[0]
        (208, 1, 1), # ISP_DISABLE[0]
    ], ues_bits=[
        (209, 0, 15), # UES[0]
        (209, 0, 16), # UES[1]
        (209, 0, 17), # UES[2]
        (209, 0, 18), # UES[3]
        (209, 0, 19), # UES[4]
        (209, 0, 20), # UES[5]
        (209, 0, 21), # UES[6]
        (209, 0, 22), # UES[7]
        (209, 0, 23), # UES[8]
        (209, 0, 24), # UES[9]
        (209, 0, 25), # UES[10]
        (209, 0, 26), # UES[11]
        (209, 0, 27), # UES[12]
        (209, 0, 28), # UES[13]
        (209, 0, 29), # UES[14]
        (209, 0, 156), # UES[15]
        (209, 0, 157), # UES[16]
        (209, 0, 158), # UES[17]
        (209, 0, 159), # UES[18]
        (209, 0, 160), # UES[19]
        (209, 0, 161), # UES[20]
        (209, 0, 162), # UES[21]
        (209, 0, 163), # UES[22]
        (209, 0, 164), # UES[23]
        (209, 0, 165), # UES[24]
        (209, 0, 166), # UES[25]
        (209, 0, 167), # UES[26]
        (209, 0, 168), # UES[27]
        (209, 0, 169), # UES[28]
        (209, 0, 170), # UES[29]
        (209, 0, 171), # UES[30]
        (209, 0, 172), # UES[31]
        (209, 0, 173), # UES[32]
        (209, 0, 174), # UES[33]
        (209, 0, 175), # UES[34]
        (209, 0, 176), # UES[35]
        (209, 0, 177), # UES[36]
        (209, 0, 178), # UES[37]
        (209, 0, 179), # UES[38]
        (209, 0, 180), # UES[39]
        (209, 0, 181), # UES[40]
        (209, 0, 182), # UES[41]
        (209, 0, 183), # UES[42]
        (209, 0, 184), # UES[43]
        (209, 0, 185), # UES[44]
        (209, 0, 186), # UES[45]
        (209, 0, 187), # UES[46]
        (209, 0, 188), # UES[47]
        (209, 0, 189), # UES[48]
        (209, 0, 190), # UES[49]
        (209, 0, 191), # UES[50]
        (209, 0, 192), # UES[51]
        (209, 0, 193), # UES[52]
        (209, 0, 194), # UES[53]
        (209, 0, 195), # UES[54]
        (209, 0, 196), # UES[55]
        (209, 0, 197), # UES[56]
        (209, 0, 198), # UES[57]
        (209, 0, 199), # UES[58]
        (209, 0, 200), # UES[59]
        (209, 0, 201), # UES[60]
        (209, 0, 202), # UES[61]
        (209, 0, 203), # UES[62]
        (209, 0, 204), # UES[63]
        (209, 0, 205), # UES[64]
        (209, 0, 206), # UES[65]
        (209, 0, 207), # UES[66]
        (209, 0, 208), # UES[67]
        (209, 0, 209), # UES[68]
        (209, 0, 210), # UES[69]
        (209, 0, 211), # UES[70]
        (209, 0, 212), # UES[71]
        (209, 0, 213), # UES[72]
        (209, 0, 214), # UES[73]
        (209, 0, 215), # UES[74]
        (209, 0, 216), # UES[75]
        (209, 0, 217), # UES[76]
        (209, 0, 218), # UES[77]
        (209, 0, 363), # UES[78]
        (209, 0, 364), # UES[79]
        (209, 0, 365), # UES[80]
        (209, 0, 366), # UES[81]
        (209, 0, 367), # UES[82]
        (209, 0, 368), # UES[83]
        (209, 0, 369), # UES[84]
        (209, 0, 370), # UES[85]
        (209, 0, 371), # UES[86]
        (209, 0, 372), # UES[87]
        (209, 0, 373), # UES[88]
        (209, 0, 374), # UES[89]
        (209, 0, 375), # UES[90]
        (209, 0, 376), # UES[91]
        (209, 0, 377), # UES[92]
        (209, 0, 378), # UES[93]
        (209, 0, 379), # UES[94]
        (209, 0, 380), # UES[95]
        (209, 0, 381), # UES[96]
        (209, 0, 382), # UES[97]
        (209, 0, 383), # UES[98]
        (209, 0, 384), # UES[99]
        (209, 0, 385), # UES[100]
        (209, 0, 386), # UES[101]
        (209, 0, 387), # UES[102]
        (209, 0, 388), # UES[103]
        (209, 0, 389), # UES[104]
        (209, 0, 390), # UES[105]
        (209, 0, 391), # UES[106]
        (209, 0, 392), # UES[107]
        (209, 0, 393), # UES[108]
        (209, 0, 394), # UES[109]
        (209, 0, 395), # UES[110]
        (209, 0, 396), # UES[111]
        (209, 0, 397), # UES[112]
        (209, 0, 398), # UES[113]
        (209, 0, 399), # UES[114]
        (209, 0, 400), # UES[115]
        (209, 0, 401), # UES[116]
        (209, 0, 402), # UES[117]
        (209, 0, 403), # UES[118]
        (209, 0, 404), # UES[119]
        (209, 0, 405), # UES[120]
        (209, 0, 406), # UES[121]
        (209, 0, 407), # UES[122]
        (209, 0, 408), # UES[123]
        (209, 0, 409), # UES[124]
        (209, 0, 410), # UES[125]
        (209, 0, 411), # UES[126]
        (209, 0, 412), # UES[127]
        (209, 0, 413), # UES[128]
        (209, 0, 414), # UES[129]
        (209, 0, 415), # UES[130]
        (209, 0, 416), # UES[131]
        (209, 0, 417), # UES[132]
        (209, 0, 418), # UES[133]
        (209, 0, 419), # UES[134]
        (209, 0, 420), # UES[135]
        (209, 0, 421), # UES[136]
        (209, 0, 422), # UES[137]
        (209, 0, 423), # UES[138]
        (209, 0, 424), # UES[139]
        (209, 0, 425), # UES[140]
        (209, 0, 426), # UES[141]
        (209, 0, 427), # UES[142]
        (209, 0, 428), # UES[143]
        (209, 0, 429), # UES[144]
        (209, 0, 430), # UES[145]
        (209, 0, 431), # UES[146]
        (209, 0, 432), # UES[147]
        (209, 0, 433), # UES[148]
        (209, 0, 434), # UES[149]
        (209, 0, 435), # UES[150]
        (209, 0, 436), # UES[151]
        (209, 0, 437), # UES[152]
        (209, 0, 438), # UES[153]
        (209, 0, 439), # UES[154]
        (209, 0, 440), # UES[155]
        (209, 0, 441), # UES[156]
        (209, 0, 442), # UES[157]
        (209, 0, 443), # UES[158]
        (209, 0, 444), # UES[159]
        (209, 0, 445), # UES[160]
        (209, 0, 446), # UES[161]
        (209, 0, 447), # UES[162]
        (209, 0, 448), # UES[163]
        (209, 0, 449), # UES[164]
        (209, 0, 450), # UES[165]
        (209, 0, 451), # UES[166]
        (209, 0, 452), # UES[167]
        (209, 0, 453), # UES[168]
        (209, 0, 454), # UES[169]
        (209, 0, 455), # UES[170]
        (209, 0, 456), # UES[171]
        (209, 0, 457), # UES[172]
        (209, 0, 458), # UES[173]
        (209, 0, 459), # UES[174]
        (209, 0, 460), # UES[175]
        (209, 0, 461), # UES[176]
        (209, 0, 462), # UES[177]
        (209, 0, 463), # UES[178]
        (209, 0, 464), # UES[179]
        (209, 0, 465), # UES[180]
        (209, 0, 466), # UES[181]
        (209, 0, 467), # UES[182]
        (209, 0, 468), # UES[183]
        (209, 0, 469), # UES[184]
        (209, 0, 470), # UES[185]
        (209, 0, 471), # UES[186]
        (209, 0, 472), # UES[187]
        (209, 0, 473), # UES[188]
        (209, 0, 474), # UES[189]
        (209, 0, 475), # UES[190]
        (209, 0, 476), # UES[191]
        (209, 0, 477), # UES[192]
        (209, 0, 478), # UES[193]
        (209, 0, 479), # UES[194]
        (209, 0, 480), # UES[195]
        (209, 0, 481), # UES[196]
        (209, 0, 482), # UES[197]
        (209, 0, 483), # UES[198]
        (209, 0, 484), # UES[199]
        (209, 0, 485), # UES[200]
        (209, 0, 486), # UES[201]
        (209, 0, 487), # UES[202]
        (209, 0, 488), # UES[203]
        (209, 0, 489), # UES[204]
        (209, 0, 490), # UES[205]
        (209, 0, 491), # UES[206]
        (209, 0, 492), # UES[207]
        (209, 0, 493), # UES[208]
        (209, 0, 494), # UES[209]
        (209, 0, 495), # UES[210]
        (209, 0, 496), # UES[211]
        (209, 0, 497), # UES[212]
        (209, 0, 498), # UES[213]
        (209, 0, 499), # UES[214]
        (209, 0, 500), # UES[215]
        (209, 0, 501), # UES[216]
        (209, 0, 502), # UES[217]
        (209, 0, 503), # UES[218]
        (209, 0, 504), # UES[219]
        (209, 0, 505), # UES[220]
        (209, 0, 506), # UES[221]
        (209, 1, 15), # UES[222]
        (209, 1, 16), # UES[223]
        (209, 1, 17), # UES[224]
        (209, 1, 18), # UES[225]
        (209, 1, 19), # UES[226]
        (209, 1, 20), # UES[227]
        (209, 1, 21), # UES[228]
        (209, 1, 22), # UES[229]
        (209, 1, 23), # UES[230]
        (209, 1, 24), # UES[231]
        (209, 1, 25), # UES[232]
        (209, 1, 26), # UES[233]
        (209, 1, 27), # UES[234]
        (209, 1, 28), # UES[235]
        (209, 1, 29), # UES[236]
        (209, 1, 156), # UES[237]
        (209, 1, 157), # UES[238]
        (209, 1, 158), # UES[239]
        (209, 1, 159), # UES[240]
        (209, 1, 160), # UES[241]
        (209, 1, 161), # UES[242]
        (209, 1, 162), # UES[243]
        (209, 1, 163), # UES[244]
        (209, 1, 164), # UES[245]
        (209, 1, 165), # UES[246]
        (209, 1, 166), # UES[247]
        (209, 1, 167), # UES[248]
        (209, 1, 168), # UES[249]
        (209, 1, 169), # UES[250]
        (209, 1, 170), # UES[251]
        (209, 1, 171), # UES[252]
        (209, 1, 172), # UES[253]
        (209, 1, 173), # UES[254]
        (209, 1, 174), # UES[255]
        (209, 1, 175), # UES[256]
        (209, 1, 176), # UES[257]
        (209, 1, 177), # UES[258]
        (209, 1, 178), # UES[259]
        (209, 1, 179), # UES[260]
        (209, 1, 180), # UES[261]
        (209, 1, 181), # UES[262]
        (209, 1, 182), # UES[263]
        (209, 1, 183), # UES[264]
        (209, 1, 184), # UES[265]
        (209, 1, 185), # UES[266]
        (209, 1, 186), # UES[267]
        (209, 1, 187), # UES[268]
        (209, 1, 188), # UES[269]
        (209, 1, 189), # UES[270]
        (209, 1, 190), # UES[271]
        (209, 1, 191), # UES[272]
        (209, 1, 192), # UES[273]
        (209, 1, 193), # UES[274]
        (209, 1, 194), # UES[275]
        (209, 1, 195), # UES[276]
        (209, 1, 196), # UES[277]
        (209, 1, 197), # UES[278]
        (209, 1, 198), # UES[279]
        (209, 1, 199), # UES[280]
        (209, 1, 200), # UES[281]
        (209, 1, 201), # UES[282]
        (209, 1, 202), # UES[283]
        (209, 1, 203), # UES[284]
        (209, 1, 204), # UES[285]
        (209, 1, 205), # UES[286]
        (209, 1, 206), # UES[287]
        (209, 1, 207), # UES[288]
        (209, 1, 208), # UES[289]
        (209, 1, 209), # UES[290]
        (209, 1, 210), # UES[291]
        (209, 1, 211), # UES[292]
        (209, 1, 212), # UES[293]
        (209, 1, 213), # UES[294]
        (209, 1, 214), # UES[295]
        (209, 1, 215), # UES[296]
        (209, 1, 216), # UES[297]
        (209, 1, 217), # UES[298]
        (209, 1, 218), # UES[299]
        (209, 1, 363), # UES[300]
        (209, 1, 364), # UES[301]
        (209, 1, 365), # UES[302]
        (209, 1, 366), # UES[303]
        (209, 1, 367), # UES[304]
        (209, 1, 368), # UES[305]
        (209, 1, 369), # UES[306]
        (209, 1, 370), # UES[307]
        (209, 1, 371), # UES[308]
        (209, 1, 372), # UES[309]
        (209, 1, 373), # UES[310]
        (209, 1, 374), # UES[311]
        (209, 1, 375), # UES[312]
        (209, 1, 376), # UES[313]
        (209, 1, 377), # UES[314]
        (209, 1, 378), # UES[315]
        (209, 1, 379), # UES[316]
        (209, 1, 380), # UES[317]
        (209, 1, 381), # UES[318]
        (209, 1, 382), # UES[319]
        (209, 1, 383), # UES[320]
        (209, 1, 384), # UES[321]
        (209, 1, 385), # UES[322]
        (209, 1, 386), # UES[323]
        (209, 1, 387), # UES[324]
        (209, 1, 388), # UES[325]
        (209, 1, 389), # UES[326]
        (209, 1, 390), # UES[327]
        (209, 1, 391), # UES[328]
        (209, 1, 392), # UES[329]
        (209, 1, 393), # UES[330]
        (209, 1, 394), # UES[331]
        (209, 1, 395), # UES[332]
        (209, 1, 396), # UES[333]
        (209, 1, 397), # UES[334]
        (209, 1, 398), # UES[335]
        (209, 1, 399), # UES[336]
        (209, 1, 400), # UES[337]
        (209, 1, 401), # UES[338]
        (209, 1, 402), # UES[339]
        (209, 1, 403), # UES[340]
        (209, 1, 404), # UES[341]
        (209, 1, 405), # UES[342]
        (209, 1, 406), # UES[343]
        (209, 1, 407), # UES[344]
        (209, 1, 408), # UES[345]
        (209, 1, 409), # UES[346]
        (209, 1, 410), # UES[347]
        (209, 1, 411), # UES[348]
        (209, 1, 412), # UES[349]
        (209, 1, 413), # UES[350]
        (209, 1, 414), # UES[351]
        (209, 1, 415), # UES[352]
        (209, 1, 416), # UES[353]
        (209, 1, 417), # UES[354]
        (209, 1, 418), # UES[355]
        (209, 1, 419), # UES[356]
        (209, 1, 420), # UES[357]
        (209, 1, 421), # UES[358]
        (209, 1, 422), # UES[359]
        (209, 1, 423), # UES[360]
        (209, 1, 424), # UES[361]
        (209, 1, 425), # UES[362]
        (209, 1, 426), # UES[363]
        (209, 1, 427), # UES[364]
        (209, 1, 428), # UES[365]
        (209, 1, 429), # UES[366]
        (209, 1, 430), # UES[367]
        (209, 1, 431), # UES[368]
        (209, 1, 432), # UES[369]
        (209, 1, 433), # UES[370]
        (209, 1, 434), # UES[371]
        (209, 1, 435), # UES[372]
        (209, 1, 436), # UES[373]
        (209, 1, 437), # UES[374]
        (209, 1, 438), # UES[375]
        (209, 1, 439), # UES[376]
        (209, 1, 440), # UES[377]
        (209, 1, 441), # UES[378]
        (209, 1, 442), # UES[379]
        (209, 1, 443), # UES[380]
        (209, 1, 444), # UES[381]
        (209, 1, 445), # UES[382]
        (209, 1, 446), # UES[383]
        (209, 1, 447), # UES[384]
        (209, 1, 448), # UES[385]
        (209, 1, 449), # UES[386]
        (209, 1, 450), # UES[387]
        (209, 1, 451), # UES[388]
        (209, 1, 452), # UES[389]
        (209, 1, 453), # UES[390]
        (209, 1, 454), # UES[391]
        (209, 1, 455), # UES[392]
        (209, 1, 456), # UES[393]
        (209, 1, 457), # UES[394]
        (209, 1, 458), # UES[395]
        (209, 1, 459), # UES[396]
        (209, 1, 460), # UES[397]
        (209, 1, 461), # UES[398]
        (209, 1, 462), # UES[399]
        (209, 1, 463), # UES[400]
        (209, 1, 464), # UES[401]
        (209, 1, 465), # UES[402]
        (209, 1, 466), # UES[403]
        (209, 1, 467), # UES[404]
        (209, 1, 468), # UES[405]
        (209, 1, 469), # UES[406]
        (209, 1, 470), # UES[407]
        (209, 1, 471), # UES[408]
        (209, 1, 472), # UES[409]
        (209, 1, 473), # UES[410]
        (209, 1, 474), # UES[411]
        (209, 1, 475), # UES[412]
        (209, 1, 476), # UES[413]
        (209, 1, 477), # UES[414]
        (209, 1, 478), # UES[415]
        (209, 1, 479), # UES[416]
        (209, 1, 480), # UES[417]
        (209, 1, 481), # UES[418]
        (209, 1, 482), # UES[419]
        (209, 1, 483), # UES[420]
        (209, 1, 484), # UES[421]
        (209, 1, 485), # UES[422]
        (209, 1, 486), # UES[423]
        (209, 1, 487), # UES[424]
        (209, 1, 488), # UES[425]
        (209, 1, 489), # UES[426]
        (209, 1, 490), # UES[427]
        (209, 1, 491), # UES[428]
        (209, 1, 492), # UES[429]
        (209, 1, 493), # UES[430]
        (209, 1, 494), # UES[431]
        (209, 1, 495), # UES[432]
        (209, 1, 496), # UES[433]
        (209, 1, 497), # UES[434]
        (209, 1, 498), # UES[435]
        (209, 1, 499), # UES[436]
        (209, 1, 500), # UES[437]
        (209, 1, 501), # UES[438]
        (209, 1, 502), # UES[439]
        (209, 1, 503), # UES[440]
        (209, 1, 504), # UES[441]
        (209, 1, 505), # UES[442]
        (209, 1, 506), # UES[443]
    ], read_prot_bit=(208, 1, 0), io_mcs=[0, 1, 2, 3, 4, 12, 13, 14, 15]),
    XPLA3Device("xcr3512xl", idcode=0x4978, fb_cols=[
        FbColumn(0, 20, 186),
        FbColumn(10, 103, 282),
        FbColumn(378, 398, 564),
        FbColumn(388, 481, 660),
    ], fb_rows=4, imux_width=83, bs_cols=756, global_bits=[
        (76, 1, 9), # FB_GROUP[0].UCT0[0]
        (76, 1, 10), # FB_GROUP[0].UCT0[1]
        (76, 1, 11), # FB_GROUP[0].UCT0[2]
        (76, 1, 12), # FB_GROUP[0].UCT0[3]
        (76, 1, 13), # FB_GROUP[0].UCT0[4]
        (76, 1, 14), # FB_GROUP[0].UCT0[5]
        (77, 1, 9), # FB_GROUP[0].UCT1[0]
        (77, 1, 10), # FB_GROUP[0].UCT1[1]
        (77, 1, 11), # FB_GROUP[0].UCT1[2]
        (77, 1, 12), # FB_GROUP[0].UCT1[3]
        (77, 1, 13), # FB_GROUP[0].UCT1[4]
        (77, 1, 14), # FB_GROUP[0].UCT1[5]
        (78, 1, 9), # FB_GROUP[0].UCT2[0]
        (78, 1, 10), # FB_GROUP[0].UCT2[1]
        (78, 1, 11), # FB_GROUP[0].UCT2[2]
        (78, 1, 12), # FB_GROUP[0].UCT2[3]
        (78, 1, 13), # FB_GROUP[0].UCT2[4]
        (78, 1, 14), # FB_GROUP[0].UCT2[5]
        (79, 1, 9), # FB_GROUP[0].UCT3[0]
        (79, 1, 10), # FB_GROUP[0].UCT3[1]
        (79, 1, 11), # FB_GROUP[0].UCT3[2]
        (79, 1, 12), # FB_GROUP[0].UCT3[3]
        (79, 1, 13), # FB_GROUP[0].UCT3[4]
        (79, 1, 14), # FB_GROUP[0].UCT3[5]
        (76, 1, 387), # FB_GROUP[1].UCT0[0]
        (76, 1, 388), # FB_GROUP[1].UCT0[1]
        (76, 1, 389), # FB_GROUP[1].UCT0[2]
        (76, 1, 390), # FB_GROUP[1].UCT0[3]
        (76, 1, 391), # FB_GROUP[1].UCT0[4]
        (76, 1, 392), # FB_GROUP[1].UCT0[5]
        (77, 1, 387), # FB_GROUP[1].UCT1[0]
        (77, 1, 388), # FB_GROUP[1].UCT1[1]
        (77, 1, 389), # FB_GROUP[1].UCT1[2]
        (77, 1, 390), # FB_GROUP[1].UCT1[3]
        (77, 1, 391), # FB_GROUP[1].UCT1[4]
        (77, 1, 392), # FB_GROUP[1].UCT1[5]
        (78, 1, 387), # FB_GROUP[1].UCT2[0]
        (78, 1, 388), # FB_GROUP[1].UCT2[1]
        (78, 1, 389), # FB_GROUP[1].UCT2[2]
        (78, 1, 390), # FB_GROUP[1].UCT2[3]
        (78, 1, 391), # FB_GROUP[1].UCT2[4]
        (78, 1, 392), # FB_GROUP[1].UCT2[5]
        (79, 1, 387), # FB_GROUP[1].UCT3[0]
        (79, 1, 388), # FB_GROUP[1].UCT3[1]
        (79, 1, 389), # FB_GROUP[1].UCT3[2]
        (79, 1, 390), # FB_GROUP[1].UCT3[3]
        (79, 1, 391), # FB_GROUP[1].UCT3[4]
        (79, 1, 392), # FB_GROUP[1].UCT3[5]
        (0, 0, 62), # FB_COL[0].ZIA_GCLK0_ENABLE[0]
        (0, 0, 63), # FB_COL[0].ZIA_GCLK1_ENABLE[0]
        (0, 0, 64), # FB_COL[0].ZIA_GCLK2_ENABLE[0]
        (0, 0, 65), # FB_COL[0].ZIA_GCLK3_ENABLE[0]
        (0, 0, 145), # FB_COL[1].ZIA_GCLK0_ENABLE[0]
        (0, 0, 146), # FB_COL[1].ZIA_GCLK1_ENABLE[0]
        (0, 0, 147), # FB_COL[1].ZIA_GCLK2_ENABLE[0]
        (0, 0, 148), # FB_COL[1].ZIA_GCLK3_ENABLE[0]
        (0, 0, 440), # FB_COL[2].ZIA_GCLK0_ENABLE[0]
        (0, 0, 441), # FB_COL[2].ZIA_GCLK1_ENABLE[0]
        (0, 0, 442), # FB_COL[2].ZIA_GCLK2_ENABLE[0]
        (0, 0, 443), # FB_COL[2].ZIA_GCLK3_ENABLE[0]
        (0, 0, 523), # FB_COL[3].ZIA_GCLK0_ENABLE[0]
        (0, 0, 524), # FB_COL[3].ZIA_GCLK1_ENABLE[0]
        (0, 0, 525), # FB_COL[3].ZIA_GCLK2_ENABLE[0]
        (0, 0, 526), # FB_COL[3].ZIA_GCLK3_ENABLE[0]
        (208, 1, 1), # ISP_DISABLE[0]
    ], ues_bits=[
        (209, 0, 5), # UES[0]
        (209, 0, 6), # UES[1]
        (209, 0, 7), # UES[2]
        (209, 0, 8), # UES[3]
        (209, 0, 9), # UES[4]
        (209, 0, 10), # UES[5]
        (209, 0, 11), # UES[6]
        (209, 0, 12), # UES[7]
        (209, 0, 13), # UES[8]
        (209, 0, 14), # UES[9]
        (209, 0, 15), # UES[10]
        (209, 0, 16), # UES[11]
        (209, 0, 17), # UES[12]
        (209, 0, 18), # UES[13]
        (209, 0, 19), # UES[14]
        (209, 0, 108), # UES[15]
        (209, 0, 109), # UES[16]
        (209, 0, 110), # UES[17]
        (209, 0, 111), # UES[18]
        (209, 0, 112), # UES[19]
        (209, 0, 113), # UES[20]
        (209, 0, 114), # UES[21]
        (209, 0, 115), # UES[22]
        (209, 0, 116), # UES[23]
        (209, 0, 117), # UES[24]
        (209, 0, 118), # UES[25]
        (209, 0, 119), # UES[26]
        (209, 0, 120), # UES[27]
        (209, 0, 121), # UES[28]
        (209, 0, 122), # UES[29]
        (209, 0, 123), # UES[30]
        (209, 0, 124), # UES[31]
        (209, 0, 125), # UES[32]
        (209, 0, 126), # UES[33]
        (209, 0, 127), # UES[34]
        (209, 0, 128), # UES[35]
        (209, 0, 129), # UES[36]
        (209, 0, 130), # UES[37]
        (209, 0, 131), # UES[38]
        (209, 0, 132), # UES[39]
        (209, 0, 133), # UES[40]
        (209, 0, 134), # UES[41]
        (209, 0, 135), # UES[42]
        (209, 0, 136), # UES[43]
        (209, 0, 137), # UES[44]
        (209, 0, 138), # UES[45]
        (209, 0, 139), # UES[46]
        (209, 0, 140), # UES[47]
        (209, 0, 141), # UES[48]
        (209, 0, 142), # UES[49]
        (209, 0, 143), # UES[50]
        (209, 0, 144), # UES[51]
        (209, 0, 145), # UES[52]
        (209, 0, 146), # UES[53]
        (209, 0, 147), # UES[54]
        (209, 0, 148), # UES[55]
        (209, 0, 149), # UES[56]
        (209, 0, 150), # UES[57]
        (209, 0, 151), # UES[58]
        (209, 0, 152), # UES[59]
        (209, 0, 153), # UES[60]
        (209, 0, 154), # UES[61]
        (209, 0, 155), # UES[62]
        (209, 0, 156), # UES[63]
        (209, 0, 157), # UES[64]
        (209, 0, 158), # UES[65]
        (209, 0, 159), # UES[66]
        (209, 0, 160), # UES[67]
        (209, 0, 161), # UES[68]
        (209, 0, 162), # UES[69]
        (209, 0, 163), # UES[70]
        (209, 0, 164), # UES[71]
        (209, 0, 165), # UES[72]
        (209, 0, 166), # UES[73]
        (209, 0, 167), # UES[74]
        (209, 0, 168), # UES[75]
        (209, 0, 169), # UES[76]
        (209, 0, 170), # UES[77]
        (209, 0, 171), # UES[78]
        (209, 0, 172), # UES[79]
        (209, 0, 173), # UES[80]
        (209, 0, 174), # UES[81]
        (209, 0, 175), # UES[82]
        (209, 0, 176), # UES[83]
        (209, 0, 177), # UES[84]
        (209, 0, 178), # UES[85]
        (209, 0, 179), # UES[86]
        (209, 0, 180), # UES[87]
        (209, 0, 181), # UES[88]
        (209, 0, 182), # UES[89]
        (209, 0, 183), # UES[90]
        (209, 0, 184), # UES[91]
        (209, 0, 185), # UES[92]
        (209, 0, 282), # UES[93]
        (209, 0, 283), # UES[94]
        (209, 0, 284), # UES[95]
        (209, 0, 285), # UES[96]
        (209, 0, 286), # UES[97]
        (209, 0, 287), # UES[98]
        (209, 0, 288), # UES[99]
        (209, 0, 289), # UES[100]
        (209, 0, 290), # UES[101]
        (209, 0, 291), # UES[102]
        (209, 0, 292), # UES[103]
        (209, 0, 293), # UES[104]
        (209, 0, 294), # UES[105]
        (209, 0, 295), # UES[106]
        (209, 0, 296), # UES[107]
        (209, 0, 297), # UES[108]
        (209, 0, 298), # UES[109]
        (209, 0, 299), # UES[110]
        (209, 0, 300), # UES[111]
        (209, 0, 301), # UES[112]
        (209, 0, 302), # UES[113]
        (209, 0, 303), # UES[114]
        (209, 0, 304), # UES[115]
        (209, 0, 305), # UES[116]
        (209, 0, 306), # UES[117]
        (209, 0, 307), # UES[118]
        (209, 0, 308), # UES[119]
        (209, 0, 309), # UES[120]
        (209, 0, 310), # UES[121]
        (209, 0, 311), # UES[122]
        (209, 0, 312), # UES[123]
        (209, 0, 313), # UES[124]
        (209, 0, 314), # UES[125]
        (209, 0, 315), # UES[126]
        (209, 0, 316), # UES[127]
        (209, 0, 317), # UES[128]
        (209, 0, 318), # UES[129]
        (209, 0, 319), # UES[130]
        (209, 0, 320), # UES[131]
        (209, 0, 321), # UES[132]
        (209, 0, 322), # UES[133]
        (209, 0, 323), # UES[134]
        (209, 0, 324), # UES[135]
        (209, 0, 325), # UES[136]
        (209, 0, 326), # UES[137]
        (209, 0, 327), # UES[138]
        (209, 0, 328), # UES[139]
        (209, 0, 329), # UES[140]
        (209, 0, 330), # UES[141]
        (209, 0, 331), # UES[142]
        (209, 0, 332), # UES[143]
        (209, 0, 333), # UES[144]
        (209, 0, 334), # UES[145]
        (209, 0, 335), # UES[146]
        (209, 0, 336), # UES[147]
        (209, 0, 337), # UES[148]
        (209, 0, 338), # UES[149]
        (209, 0, 339), # UES[150]
        (209, 0, 340), # UES[151]
        (209, 0, 341), # UES[152]
        (209, 0, 342), # UES[153]
        (209, 0, 343), # UES[154]
        (209, 0, 344), # UES[155]
        (209, 0, 345), # UES[156]
        (209, 0, 346), # UES[157]
        (209, 0, 347), # UES[158]
        (209, 0, 348), # UES[159]
        (209, 0, 349), # UES[160]
        (209, 0, 350), # UES[161]
        (209, 0, 351), # UES[162]
        (209, 0, 352), # UES[163]
        (209, 0, 353), # UES[164]
        (209, 0, 354), # UES[165]
        (209, 0, 355), # UES[166]
        (209, 0, 356), # UES[167]
        (209, 0, 357), # UES[168]
        (209, 0, 358), # UES[169]
        (209, 0, 359), # UES[170]
        (209, 0, 360), # UES[171]
        (209, 0, 361), # UES[172]
        (209, 0, 362), # UES[173]
        (209, 0, 363), # UES[174]
        (209, 0, 364), # UES[175]
        (209, 0, 365), # UES[176]
        (209, 0, 366), # UES[177]
        (209, 0, 367), # UES[178]
        (209, 0, 368), # UES[179]
        (209, 0, 369), # UES[180]
        (209, 0, 370), # UES[181]
        (209, 0, 371), # UES[182]
        (209, 0, 372), # UES[183]
        (209, 0, 373), # UES[184]
        (209, 0, 374), # UES[185]
        (209, 0, 375), # UES[186]
        (209, 0, 376), # UES[187]
        (209, 0, 377), # UES[188]
        (209, 0, 383), # UES[189]
        (209, 0, 384), # UES[190]
        (209, 0, 385), # UES[191]
        (209, 0, 386), # UES[192]
        (209, 0, 387), # UES[193]
        (209, 0, 388), # UES[194]
        (209, 0, 389), # UES[195]
        (209, 0, 390), # UES[196]
        (209, 0, 391), # UES[197]
        (209, 0, 392), # UES[198]
        (209, 0, 393), # UES[199]
        (209, 0, 394), # UES[200]
        (209, 0, 395), # UES[201]
        (209, 0, 396), # UES[202]
        (209, 0, 397), # UES[203]
        (209, 0, 481), # UES[204]
        (209, 0, 482), # UES[205]
        (209, 0, 483), # UES[206]
        (209, 0, 484), # UES[207]
        (209, 0, 485), # UES[208]
        (209, 0, 486), # UES[209]
        (209, 0, 487), # UES[210]
        (209, 0, 488), # UES[211]
        (209, 0, 489), # UES[212]
        (209, 0, 490), # UES[213]
        (209, 0, 491), # UES[214]
        (209, 0, 492), # UES[215]
        (209, 0, 493), # UES[216]
        (209, 0, 494), # UES[217]
        (209, 0, 495), # UES[218]
        (209, 0, 496), # UES[219]
        (209, 0, 497), # UES[220]
        (209, 0, 498), # UES[221]
        (209, 0, 499), # UES[222]
        (209, 0, 500), # UES[223]
        (209, 0, 501), # UES[224]
        (209, 0, 502), # UES[225]
        (209, 0, 503), # UES[226]
        (209, 0, 504), # UES[227]
        (209, 0, 505), # UES[228]
        (209, 0, 506), # UES[229]
        (209, 0, 507), # UES[230]
        (209, 0, 508), # UES[231]
        (209, 0, 509), # UES[232]
        (209, 0, 510), # UES[233]
        (209, 0, 511), # UES[234]
        (209, 0, 512), # UES[235]
        (209, 0, 513), # UES[236]
        (209, 0, 514), # UES[237]
        (209, 0, 515), # UES[238]
        (209, 0, 516), # UES[239]
        (209, 0, 517), # UES[240]
        (209, 0, 518), # UES[241]
        (209, 0, 519), # UES[242]
        (209, 0, 520), # UES[243]
        (209, 0, 521), # UES[244]
        (209, 0, 522), # UES[245]
        (209, 0, 523), # UES[246]
        (209, 0, 524), # UES[247]
        (209, 0, 525), # UES[248]
        (209, 0, 526), # UES[249]
        (209, 0, 527), # UES[250]
        (209, 0, 528), # UES[251]
        (209, 0, 529), # UES[252]
        (209, 0, 530), # UES[253]
        (209, 0, 531), # UES[254]
        (209, 0, 532), # UES[255]
        (209, 0, 533), # UES[256]
        (209, 0, 534), # UES[257]
        (209, 0, 535), # UES[258]
        (209, 0, 536), # UES[259]
        (209, 0, 537), # UES[260]
        (209, 0, 538), # UES[261]
        (209, 0, 539), # UES[262]
        (209, 0, 540), # UES[263]
        (209, 0, 541), # UES[264]
        (209, 0, 542), # UES[265]
        (209, 0, 543), # UES[266]
        (209, 0, 544), # UES[267]
        (209, 0, 545), # UES[268]
        (209, 0, 546), # UES[269]
        (209, 0, 547), # UES[270]
        (209, 0, 548), # UES[271]
        (209, 0, 549), # UES[272]
        (209, 0, 550), # UES[273]
        (209, 0, 551), # UES[274]
        (209, 0, 552), # UES[275]
        (209, 0, 553), # UES[276]
        (209, 0, 554), # UES[277]
        (209, 0, 555), # UES[278]
        (209, 0, 556), # UES[279]
        (209, 0, 557), # UES[280]
        (209, 0, 558), # UES[281]
        (209, 0, 559), # UES[282]
        (209, 0, 560), # UES[283]
        (209, 0, 561), # UES[284]
        (209, 0, 562), # UES[285]
        (209, 0, 563), # UES[286]
        (209, 0, 660), # UES[287]
        (209, 0, 661), # UES[288]
        (209, 0, 662), # UES[289]
        (209, 0, 663), # UES[290]
        (209, 0, 664), # UES[291]
        (209, 0, 665), # UES[292]
        (209, 0, 666), # UES[293]
        (209, 0, 667), # UES[294]
        (209, 0, 668), # UES[295]
        (209, 0, 669), # UES[296]
        (209, 0, 670), # UES[297]
        (209, 0, 671), # UES[298]
        (209, 0, 672), # UES[299]
        (209, 0, 673), # UES[300]
        (209, 0, 674), # UES[301]
        (209, 0, 675), # UES[302]
        (209, 0, 676), # UES[303]
        (209, 0, 677), # UES[304]
        (209, 0, 678), # UES[305]
        (209, 0, 679), # UES[306]
        (209, 0, 680), # UES[307]
        (209, 0, 681), # UES[308]
        (209, 0, 682), # UES[309]
        (209, 0, 683), # UES[310]
        (209, 0, 684), # UES[311]
        (209, 0, 685), # UES[312]
        (209, 0, 686), # UES[313]
        (209, 0, 687), # UES[314]
        (209, 0, 688), # UES[315]
        (209, 0, 689), # UES[316]
        (209, 0, 690), # UES[317]
        (209, 0, 691), # UES[318]
        (209, 0, 692), # UES[319]
        (209, 0, 693), # UES[320]
        (209, 0, 694), # UES[321]
        (209, 0, 695), # UES[322]
        (209, 0, 696), # UES[323]
        (209, 0, 697), # UES[324]
        (209, 0, 698), # UES[325]
        (209, 0, 699), # UES[326]
        (209, 0, 700), # UES[327]
        (209, 0, 701), # UES[328]
        (209, 0, 702), # UES[329]
        (209, 0, 703), # UES[330]
        (209, 0, 704), # UES[331]
        (209, 0, 705), # UES[332]
        (209, 0, 706), # UES[333]
        (209, 0, 707), # UES[334]
        (209, 0, 708), # UES[335]
        (209, 0, 709), # UES[336]
        (209, 0, 710), # UES[337]
        (209, 0, 711), # UES[338]
        (209, 0, 712), # UES[339]
        (209, 0, 713), # UES[340]
        (209, 0, 714), # UES[341]
        (209, 0, 715), # UES[342]
        (209, 0, 716), # UES[343]
        (209, 0, 717), # UES[344]
        (209, 0, 718), # UES[345]
        (209, 0, 719), # UES[346]
        (209, 0, 720), # UES[347]
        (209, 0, 721), # UES[348]
        (209, 0, 722), # UES[349]
        (209, 0, 723), # UES[350]
        (209, 0, 724), # UES[351]
        (209, 0, 725), # UES[352]
        (209, 0, 726), # UES[353]
        (209, 0, 727), # UES[354]
        (209, 0, 728), # UES[355]
        (209, 0, 729), # UES[356]
        (209, 0, 730), # UES[357]
        (209, 0, 731), # UES[358]
        (209, 0, 732), # UES[359]
        (209, 0, 733), # UES[360]
        (209, 0, 734), # UES[361]
        (209, 0, 735), # UES[362]
        (209, 0, 736), # UES[363]
        (209, 0, 737), # UES[364]
        (209, 0, 738), # UES[365]
        (209, 0, 739), # UES[366]
        (209, 0, 740), # UES[367]
        (209, 0, 741), # UES[368]
        (209, 0, 742), # UES[369]
        (209, 0, 743), # UES[370]
        (209, 0, 744), # UES[371]
        (209, 0, 745), # UES[372]
        (209, 0, 746), # UES[373]
        (209, 0, 747), # UES[374]
        (209, 0, 748), # UES[375]
        (209, 0, 749), # UES[376]
        (209, 0, 750), # UES[377]
        (209, 0, 751), # UES[378]
        (209, 0, 752), # UES[379]
        (209, 0, 753), # UES[380]
        (209, 0, 754), # UES[381]
        (209, 0, 755), # UES[382]
        (209, 1, 5), # UES[383]
        (209, 1, 6), # UES[384]
        (209, 1, 7), # UES[385]
        (209, 1, 8), # UES[386]
        (209, 1, 9), # UES[387]
        (209, 1, 10), # UES[388]
        (209, 1, 11), # UES[389]
        (209, 1, 12), # UES[390]
        (209, 1, 13), # UES[391]
        (209, 1, 14), # UES[392]
        (209, 1, 15), # UES[393]
        (209, 1, 16), # UES[394]
        (209, 1, 17), # UES[395]
        (209, 1, 18), # UES[396]
        (209, 1, 19), # UES[397]
        (209, 1, 108), # UES[398]
        (209, 1, 109), # UES[399]
        (209, 1, 110), # UES[400]
        (209, 1, 111), # UES[401]
        (209, 1, 112), # UES[402]
        (209, 1, 113), # UES[403]
        (209, 1, 114), # UES[404]
        (209, 1, 115), # UES[405]
        (209, 1, 116), # UES[406]
        (209, 1, 117), # UES[407]
        (209, 1, 118), # UES[408]
        (209, 1, 119), # UES[409]
        (209, 1, 120), # UES[410]
        (209, 1, 121), # UES[411]
        (209, 1, 122), # UES[412]
        (209, 1, 123), # UES[413]
        (209, 1, 124), # UES[414]
        (209, 1, 125), # UES[415]
        (209, 1, 126), # UES[416]
        (209, 1, 127), # UES[417]
        (209, 1, 128), # UES[418]
        (209, 1, 129), # UES[419]
        (209, 1, 130), # UES[420]
        (209, 1, 131), # UES[421]
        (209, 1, 132), # UES[422]
        (209, 1, 133), # UES[423]
        (209, 1, 134), # UES[424]
        (209, 1, 135), # UES[425]
        (209, 1, 136), # UES[426]
        (209, 1, 137), # UES[427]
        (209, 1, 138), # UES[428]
        (209, 1, 139), # UES[429]
        (209, 1, 140), # UES[430]
        (209, 1, 141), # UES[431]
        (209, 1, 142), # UES[432]
        (209, 1, 143), # UES[433]
        (209, 1, 144), # UES[434]
        (209, 1, 145), # UES[435]
        (209, 1, 146), # UES[436]
        (209, 1, 147), # UES[437]
        (209, 1, 148), # UES[438]
        (209, 1, 149), # UES[439]
        (209, 1, 150), # UES[440]
        (209, 1, 151), # UES[441]
        (209, 1, 152), # UES[442]
        (209, 1, 153), # UES[443]
        (209, 1, 154), # UES[444]
        (209, 1, 155), # UES[445]
        (209, 1, 156), # UES[446]
        (209, 1, 157), # UES[447]
        (209, 1, 158), # UES[448]
        (209, 1, 159), # UES[449]
        (209, 1, 160), # UES[450]
        (209, 1, 161), # UES[451]
        (209, 1, 162), # UES[452]
        (209, 1, 163), # UES[453]
        (209, 1, 164), # UES[454]
        (209, 1, 165), # UES[455]
        (209, 1, 166), # UES[456]
        (209, 1, 167), # UES[457]
        (209, 1, 168), # UES[458]
        (209, 1, 169), # UES[459]
        (209, 1, 170), # UES[460]
        (209, 1, 171), # UES[461]
        (209, 1, 172), # UES[462]
        (209, 1, 173), # UES[463]
        (209, 1, 174), # UES[464]
        (209, 1, 175), # UES[465]
        (209, 1, 176), # UES[466]
        (209, 1, 177), # UES[467]
        (209, 1, 178), # UES[468]
        (209, 1, 179), # UES[469]
        (209, 1, 180), # UES[470]
        (209, 1, 181), # UES[471]
        (209, 1, 182), # UES[472]
        (209, 1, 183), # UES[473]
        (209, 1, 184), # UES[474]
        (209, 1, 185), # UES[475]
        (209, 1, 282), # UES[476]
        (209, 1, 283), # UES[477]
        (209, 1, 284), # UES[478]
        (209, 1, 285), # UES[479]
        (209, 1, 286), # UES[480]
        (209, 1, 287), # UES[481]
        (209, 1, 288), # UES[482]
        (209, 1, 289), # UES[483]
        (209, 1, 290), # UES[484]
        (209, 1, 291), # UES[485]
        (209, 1, 292), # UES[486]
        (209, 1, 293), # UES[487]
        (209, 1, 294), # UES[488]
        (209, 1, 295), # UES[489]
        (209, 1, 296), # UES[490]
        (209, 1, 297), # UES[491]
        (209, 1, 298), # UES[492]
        (209, 1, 299), # UES[493]
        (209, 1, 300), # UES[494]
        (209, 1, 301), # UES[495]
        (209, 1, 302), # UES[496]
        (209, 1, 303), # UES[497]
        (209, 1, 304), # UES[498]
        (209, 1, 305), # UES[499]
        (209, 1, 306), # UES[500]
        (209, 1, 307), # UES[501]
        (209, 1, 308), # UES[502]
        (209, 1, 309), # UES[503]
        (209, 1, 310), # UES[504]
        (209, 1, 311), # UES[505]
        (209, 1, 312), # UES[506]
        (209, 1, 313), # UES[507]
        (209, 1, 314), # UES[508]
        (209, 1, 315), # UES[509]
        (209, 1, 316), # UES[510]
        (209, 1, 317), # UES[511]
        (209, 1, 318), # UES[512]
        (209, 1, 319), # UES[513]
        (209, 1, 320), # UES[514]
        (209, 1, 321), # UES[515]
        (209, 1, 322), # UES[516]
        (209, 1, 323), # UES[517]
        (209, 1, 324), # UES[518]
        (209, 1, 325), # UES[519]
        (209, 1, 326), # UES[520]
        (209, 1, 327), # UES[521]
        (209, 1, 328), # UES[522]
        (209, 1, 329), # UES[523]
        (209, 1, 330), # UES[524]
        (209, 1, 331), # UES[525]
        (209, 1, 332), # UES[526]
        (209, 1, 333), # UES[527]
        (209, 1, 334), # UES[528]
        (209, 1, 335), # UES[529]
        (209, 1, 336), # UES[530]
        (209, 1, 337), # UES[531]
        (209, 1, 338), # UES[532]
        (209, 1, 339), # UES[533]
        (209, 1, 340), # UES[534]
        (209, 1, 341), # UES[535]
        (209, 1, 342), # UES[536]
        (209, 1, 343), # UES[537]
        (209, 1, 344), # UES[538]
        (209, 1, 345), # UES[539]
        (209, 1, 346), # UES[540]
        (209, 1, 347), # UES[541]
        (209, 1, 348), # UES[542]
        (209, 1, 349), # UES[543]
        (209, 1, 350), # UES[544]
        (209, 1, 351), # UES[545]
        (209, 1, 352), # UES[546]
        (209, 1, 353), # UES[547]
        (209, 1, 354), # UES[548]
        (209, 1, 355), # UES[549]
        (209, 1, 356), # UES[550]
        (209, 1, 357), # UES[551]
        (209, 1, 358), # UES[552]
        (209, 1, 359), # UES[553]
        (209, 1, 360), # UES[554]
        (209, 1, 361), # UES[555]
        (209, 1, 362), # UES[556]
        (209, 1, 363), # UES[557]
        (209, 1, 364), # UES[558]
        (209, 1, 365), # UES[559]
        (209, 1, 366), # UES[560]
        (209, 1, 367), # UES[561]
        (209, 1, 368), # UES[562]
        (209, 1, 369), # UES[563]
        (209, 1, 370), # UES[564]
        (209, 1, 371), # UES[565]
        (209, 1, 372), # UES[566]
        (209, 1, 373), # UES[567]
        (209, 1, 374), # UES[568]
        (209, 1, 375), # UES[569]
        (209, 1, 376), # UES[570]
        (209, 1, 377), # UES[571]
        (209, 1, 383), # UES[572]
        (209, 1, 384), # UES[573]
        (209, 1, 385), # UES[574]
        (209, 1, 386), # UES[575]
        (209, 1, 387), # UES[576]
        (209, 1, 388), # UES[577]
        (209, 1, 389), # UES[578]
        (209, 1, 390), # UES[579]
        (209, 1, 391), # UES[580]
        (209, 1, 392), # UES[581]
        (209, 1, 393), # UES[582]
        (209, 1, 394), # UES[583]
        (209, 1, 395), # UES[584]
        (209, 1, 396), # UES[585]
        (209, 1, 397), # UES[586]
        (209, 1, 481), # UES[587]
        (209, 1, 482), # UES[588]
        (209, 1, 483), # UES[589]
        (209, 1, 484), # UES[590]
        (209, 1, 485), # UES[591]
        (209, 1, 486), # UES[592]
        (209, 1, 487), # UES[593]
        (209, 1, 488), # UES[594]
        (209, 1, 489), # UES[595]
        (209, 1, 490), # UES[596]
        (209, 1, 491), # UES[597]
        (209, 1, 492), # UES[598]
        (209, 1, 493), # UES[599]
        (209, 1, 494), # UES[600]
        (209, 1, 495), # UES[601]
        (209, 1, 496), # UES[602]
        (209, 1, 497), # UES[603]
        (209, 1, 498), # UES[604]
        (209, 1, 499), # UES[605]
        (209, 1, 500), # UES[606]
        (209, 1, 501), # UES[607]
        (209, 1, 502), # UES[608]
        (209, 1, 503), # UES[609]
        (209, 1, 504), # UES[610]
        (209, 1, 505), # UES[611]
        (209, 1, 506), # UES[612]
        (209, 1, 507), # UES[613]
        (209, 1, 508), # UES[614]
        (209, 1, 509), # UES[615]
        (209, 1, 510), # UES[616]
        (209, 1, 511), # UES[617]
        (209, 1, 512), # UES[618]
        (209, 1, 513), # UES[619]
        (209, 1, 514), # UES[620]
        (209, 1, 515), # UES[621]
        (209, 1, 516), # UES[622]
        (209, 1, 517), # UES[623]
        (209, 1, 518), # UES[624]
        (209, 1, 519), # UES[625]
        (209, 1, 520), # UES[626]
        (209, 1, 521), # UES[627]
        (209, 1, 522), # UES[628]
        (209, 1, 523), # UES[629]
        (209, 1, 524), # UES[630]
        (209, 1, 525), # UES[631]
        (209, 1, 526), # UES[632]
        (209, 1, 527), # UES[633]
        (209, 1, 528), # UES[634]
        (209, 1, 529), # UES[635]
        (209, 1, 530), # UES[636]
        (209, 1, 531), # UES[637]
        (209, 1, 532), # UES[638]
        (209, 1, 533), # UES[639]
        (209, 1, 534), # UES[640]
        (209, 1, 535), # UES[641]
        (209, 1, 536), # UES[642]
        (209, 1, 537), # UES[643]
        (209, 1, 538), # UES[644]
        (209, 1, 539), # UES[645]
        (209, 1, 540), # UES[646]
        (209, 1, 541), # UES[647]
        (209, 1, 542), # UES[648]
        (209, 1, 543), # UES[649]
        (209, 1, 544), # UES[650]
        (209, 1, 545), # UES[651]
        (209, 1, 546), # UES[652]
        (209, 1, 547), # UES[653]
        (209, 1, 548), # UES[654]
        (209, 1, 549), # UES[655]
        (209, 1, 550), # UES[656]
        (209, 1, 551), # UES[657]
        (209, 1, 552), # UES[658]
        (209, 1, 553), # UES[659]
        (209, 1, 554), # UES[660]
        (209, 1, 555), # UES[661]
        (209, 1, 556), # UES[662]
        (209, 1, 557), # UES[663]
        (209, 1, 558), # UES[664]
        (209, 1, 559), # UES[665]
        (209, 1, 560), # UES[666]
        (209, 1, 561), # UES[667]
        (209, 1, 562), # UES[668]
        (209, 1, 563), # UES[669]
        (209, 1, 660), # UES[670]
        (209, 1, 661), # UES[671]
        (209, 1, 662), # UES[672]
        (209, 1, 663), # UES[673]
        (209, 1, 664), # UES[674]
        (209, 1, 665), # UES[675]
        (209, 1, 666), # UES[676]
        (209, 1, 667), # UES[677]
        (209, 1, 668), # UES[678]
        (209, 1, 669), # UES[679]
        (209, 1, 670), # UES[680]
        (209, 1, 671), # UES[681]
        (209, 1, 672), # UES[682]
        (209, 1, 673), # UES[683]
        (209, 1, 674), # UES[684]
        (209, 1, 675), # UES[685]
        (209, 1, 676), # UES[686]
        (209, 1, 677), # UES[687]
        (209, 1, 678), # UES[688]
        (209, 1, 679), # UES[689]
        (209, 1, 680), # UES[690]
        (209, 1, 681), # UES[691]
        (209, 1, 682), # UES[692]
        (209, 1, 683), # UES[693]
        (209, 1, 684), # UES[694]
        (209, 1, 685), # UES[695]
        (209, 1, 686), # UES[696]
        (209, 1, 687), # UES[697]
        (209, 1, 688), # UES[698]
        (209, 1, 689), # UES[699]
        (209, 1, 690), # UES[700]
        (209, 1, 691), # UES[701]
        (209, 1, 692), # UES[702]
        (209, 1, 693), # UES[703]
        (209, 1, 694), # UES[704]
        (209, 1, 695), # UES[705]
        (209, 1, 696), # UES[706]
        (209, 1, 697), # UES[707]
        (209, 1, 698), # UES[708]
        (209, 1, 699), # UES[709]
        (209, 1, 700), # UES[710]
        (209, 1, 701), # UES[711]
        (209, 1, 702), # UES[712]
        (209, 1, 703), # UES[713]
        (209, 1, 704), # UES[714]
        (209, 1, 705), # UES[715]
        (209, 1, 706), # UES[716]
        (209, 1, 707), # UES[717]
        (209, 1, 708), # UES[718]
        (209, 1, 709), # UES[719]
        (209, 1, 710), # UES[720]
        (209, 1, 711), # UES[721]
        (209, 1, 712), # UES[722]
        (209, 1, 713), # UES[723]
        (209, 1, 714), # UES[724]
        (209, 1, 715), # UES[725]
        (209, 1, 716), # UES[726]
        (209, 1, 717), # UES[727]
        (209, 1, 718), # UES[728]
        (209, 1, 719), # UES[729]
        (209, 1, 720), # UES[730]
        (209, 1, 721), # UES[731]
        (209, 1, 722), # UES[732]
        (209, 1, 723), # UES[733]
        (209, 1, 724), # UES[734]
        (209, 1, 725), # UES[735]
        (209, 1, 726), # UES[736]
        (209, 1, 727), # UES[737]
        (209, 1, 728), # UES[738]
        (209, 1, 729), # UES[739]
        (209, 1, 730), # UES[740]
        (209, 1, 731), # UES[741]
        (209, 1, 732), # UES[742]
        (209, 1, 733), # UES[743]
        (209, 1, 734), # UES[744]
        (209, 1, 735), # UES[745]
        (209, 1, 736), # UES[746]
        (209, 1, 737), # UES[747]
        (209, 1, 738), # UES[748]
        (209, 1, 739), # UES[749]
        (209, 1, 740), # UES[750]
        (209, 1, 741), # UES[751]
        (209, 1, 742), # UES[752]
        (209, 1, 743), # UES[753]
        (209, 1, 744), # UES[754]
        (209, 1, 745), # UES[755]
        (209, 1, 746), # UES[756]
        (209, 1, 747), # UES[757]
        (209, 1, 748), # UES[758]
        (209, 1, 749), # UES[759]
        (209, 1, 750), # UES[760]
        (209, 1, 751), # UES[761]
        (209, 1, 752), # UES[762]
        (209, 1, 753), # UES[763]
        (209, 1, 754), # UES[764]
        (209, 1, 755), # UES[765]
    ], read_prot_bit=(208, 1, 0), io_mcs=[0, 1, 2, 3, 12, 13, 14, 15]),
]

devices_by_idcode = defaultdict(lambda: None,
    ((device.idcode, device) for device in devices))

devices_by_name = defaultdict(lambda: None,
    ((device.name, device) for device in devices))
