/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.civilization;

import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.trade.Trade;
import com.unciv.logic.trade.TradeEvaluation;
import com.unciv.logic.trade.TradeLogic;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.logic.trade.TradeOffersList;
import com.unciv.logic.trade.TradeRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J(\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/unciv/logic/automation/civilization/TradeAutomation;", "", "<init>", "()V", "respondToTradeRequests", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "tradeAndChangeState", "", "getCounteroffer", "Lcom/unciv/logic/trade/TradeRequest;", "tradeRequest", "exchangeLuxuries", "potentialLuxuryTrades", "Ljava/util/ArrayList;", "Lcom/unciv/logic/trade/Trade;", "Lkotlin/collections/ArrayList;", "otherCivInfo", "core"})
@SourceDebugExtension(value={"SMAP\nTradeAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TradeAutomation.kt\ncom/unciv/logic/automation/civilization/TradeAutomation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,226:1\n1761#2,3:227\n1761#2,3:230\n774#2:241\n865#2,2:242\n774#2:244\n865#2,2:245\n1068#2:247\n774#2:248\n865#2,2:249\n1068#2:251\n2746#2,3:252\n2746#2,3:255\n1761#2,3:258\n774#2:261\n865#2,2:262\n774#2:264\n865#2,2:265\n774#2:267\n865#2:268\n2746#2,3:269\n866#2:272\n774#2:273\n865#2:274\n2746#2,3:275\n866#2:278\n1056#2:279\n1#3:233\n536#4:234\n521#4,6:235\n*S KotlinDebug\n*F\n+ 1 TradeAutomation.kt\ncom/unciv/logic/automation/civilization/TradeAutomation\n*L\n73#1:227,3\n81#1:230,3\n111#1:241\n111#1:242,2\n125#1:244\n125#1:245,2\n126#1:247\n143#1:248\n143#1:249,2\n144#1:251\n145#1:252,3\n146#1:255,3\n188#1:258,3\n202#1:261\n202#1:262,2\n204#1:264\n204#1:265,2\n206#1:267\n206#1:268\n208#1:269,3\n206#1:272\n211#1:273\n211#1:274\n213#1:275,3\n211#1:278\n214#1:279\n104#1:234\n104#1:235,6\n*E\n"})
public final class TradeAutomation {
    @NotNull
    public static final TradeAutomation INSTANCE = new TradeAutomation();

    private TradeAutomation() {
    }

    public final void respondToTradeRequests(@NotNull Civilization civInfo, boolean tradeAndChangeState) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        for (TradeRequest tradeRequest : CollectionsKt.toList((Iterable)civInfo.getTradeRequests())) {
            String[] stringArray;
            Civilization otherCiv = civInfo.getGameInfo().getCivilization(tradeRequest.getRequestingCiv());
            if (!tradeAndChangeState || !new TradeEvaluation().isTradeValid(tradeRequest.getTrade(), civInfo, otherCiv)) continue;
            TradeLogic tradeLogic = new TradeLogic(civInfo, otherCiv);
            tradeLogic.getCurrentTrade().set(tradeRequest.getTrade());
            civInfo.getTradeRequests().remove(tradeRequest);
            if (new TradeEvaluation().isTradeAcceptable(tradeLogic.getCurrentTrade(), civInfo, otherCiv)) {
                TradeLogic.acceptTrade$default(tradeLogic, false, 1, null);
                String[] stringArray2 = new String[]{"StatIcons/Acquire", civInfo.getCivName()};
                otherCiv.addNotification('[' + civInfo.getCivName() + "] has accepted your trade request", Notification.NotificationCategory.Trade, stringArray2);
                continue;
            }
            TradeRequest counteroffer = this.getCounteroffer(civInfo, tradeRequest);
            if (counteroffer != null) {
                stringArray = new String[]{"StatIcons/Acquire", civInfo.getCivName()};
                otherCiv.addNotification('[' + civInfo.getCivName() + "] has made a counteroffer to your trade request", Notification.NotificationCategory.Trade, stringArray);
                otherCiv.getTradeRequests().add(counteroffer);
                continue;
            }
            stringArray = new String[]{civInfo.getCivName(), "StatIcons/Acquire"};
            otherCiv.addNotification('[' + civInfo.getCivName() + "] has denied your trade request", Notification.NotificationCategory.Trade, stringArray);
            tradeRequest.decline(civInfo);
        }
        civInfo.getTradeRequests().clear();
    }

    /*
     * WARNING - void declaration
     */
    private final TradeRequest getCounteroffer(Civilization civInfo, TradeRequest tradeRequest) {
        Object goldAsk;
        void $this$sortedByDescending$iv;
        Iterable $this$filter$iv;
        void $this$filterTo$iv$iv3;
        Iterator $this$filterTo$iv$iv2;
        Iterator iterator2;
        Civilization otherCiv = civInfo.getGameInfo().getCivilization(tradeRequest.getRequestingCiv());
        TradeEvaluation evaluation = new TradeEvaluation();
        int deltaInOurFavor = 0;
        deltaInOurFavor = evaluation.getTradeAcceptability(tradeRequest.getTrade(), civInfo, otherCiv, true);
        if (deltaInOurFavor > 0) {
            deltaInOurFavor = (int)((float)deltaInOurFavor / 1.1f);
        }
        TradeLogic tradeLogic = new TradeLogic(civInfo, otherCiv);
        tradeLogic.getCurrentTrade().set(tradeRequest.getTrade());
        HashMap potentialAsks = new HashMap();
        HashMap counterofferAsks = new HashMap();
        ArrayList<TradeOffer> counterofferGifts = new ArrayList<TradeOffer>();
        Iterator iterator3 = tradeLogic.getTheirAvailableOffers().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
        Iterator iterator4 = iterator3;
        while (iterator4.hasNext()) {
            int value;
            boolean bl;
            TradeOffer offer;
            block39: {
                TradeOffer it;
                boolean $i$f$any;
                Iterable $this$any$iv;
                Object e = iterator4.next();
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                offer = (TradeOffer)e;
                if (offer.getType() == TradeOfferType.Gold || offer.getType() == TradeOfferType.Gold_Per_Turn) {
                    boolean bl2;
                    block38: {
                        $this$any$iv = tradeRequest.getTrade().getOurOffers();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (TradeOffer)element$iv;
                                boolean bl3 = false;
                                if (!(it.getType() == offer.getType())) continue;
                                bl2 = true;
                                break block38;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) continue;
                }
                if (!offer.isTradable() || offer.getType() == TradeOfferType.City || offer.getType() == TradeOfferType.Luxury_Resource) continue;
                $this$any$iv = tradeLogic.getCurrentTrade().getTheirOffers();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (TradeOffer)element$iv;
                        boolean bl4 = false;
                        if (!(it.getType() == offer.getType() && Intrinsics.areEqual(it.getName(), offer.getName()))) continue;
                        bl = true;
                        break block39;
                    }
                    bl = false;
                }
            }
            if (bl || offer.getType() == TradeOfferType.Treaty || (value = evaluation.evaluateBuyCostWithInflation(offer, civInfo, otherCiv, tradeRequest.getTrade())) <= 0) continue;
            ((Map)potentialAsks).put(offer, value);
        }
        while (!((Map)potentialAsks).isEmpty() && deltaInOurFavor < 0) {
            Map.Entry offerToAdd;
            Iterator iterator5;
            Iterable value = ((Map)potentialAsks).entrySet();
            Iterator $i$f$any = value.iterator();
            if (!$i$f$any.hasNext()) {
                iterator5 = null;
            } else {
                iterator2 = $i$f$any.next();
                if (!$i$f$any.hasNext()) {
                    iterator5 = iterator2;
                } else {
                    Map.Entry it22 = (Map.Entry)((Object)iterator2);
                    boolean bl5 = false;
                    int it22 = ((Number)it22.getValue()).intValue();
                    do {
                        Object bl5 = $i$f$any.next();
                        Map.Entry it32 = (Map.Entry)bl5;
                        boolean $i$a$-minByOrNull-TradeAutomation$getCounteroffer$offerToAdd$2 = false;
                        int it32 = ((Number)it32.getValue()).intValue();
                        if (it22 <= it32) continue;
                        iterator2 = bl5;
                        it22 = it32;
                    } while ($i$f$any.hasNext());
                    iterator5 = iterator2;
                }
            }
            Intrinsics.checkNotNull((Map.Entry)((Object)iterator5));
            deltaInOurFavor += ((Number)offerToAdd.getValue()).intValue();
            ((Map)counterofferAsks).put(offerToAdd.getKey(), offerToAdd.getValue());
            potentialAsks.remove(offerToAdd.getKey());
        }
        if (deltaInOurFavor < 0) {
            return null;
        }
        while (deltaInOurFavor > 0) {
            Object offerToRemove;
            Map map2;
            Map $this$filter$iv2 = counterofferAsks;
            boolean $i$f$filter22 = false;
            iterator2 = $this$filter$iv2;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator it32 = $this$filterTo$iv$iv2.entrySet().iterator();
            while (it32.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = it32.next();
                boolean bl = false;
                if (!(((Number)it.getValue()).intValue() <= deltaInOurFavor)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Iterable $i$f$filter22 = destination$iv$iv.entrySet();
            $this$filterTo$iv$iv2 = $i$f$filter22.iterator();
            if (!$this$filterTo$iv$iv2.hasNext()) {
                map2 = null;
            } else {
                destination$iv$iv = $this$filterTo$iv$iv2.next();
                if (!$this$filterTo$iv$iv2.hasNext()) {
                    map2 = destination$iv$iv;
                } else {
                    Map.Entry it42 = (Map.Entry)((Object)destination$iv$iv);
                    boolean bl6 = false;
                    int it42 = ((Number)it42.getValue()).intValue();
                    do {
                        Object bl6 = $this$filterTo$iv$iv2.next();
                        Map.Entry it52 = (Map.Entry)bl6;
                        boolean $i$a$-maxByOrNull-TradeAutomation$getCounteroffer$offerToRemove$3 = false;
                        int it52 = ((Number)it52.getValue()).intValue();
                        if (it42 >= it52) continue;
                        destination$iv$iv = bl6;
                        it42 = it52;
                    } while ($this$filterTo$iv$iv2.hasNext());
                    map2 = destination$iv$iv;
                }
            }
            if ((Map.Entry)((Object)map2) == null) break;
            deltaInOurFavor -= ((Number)offerToRemove.getValue()).intValue();
            counterofferAsks.remove(offerToRemove.getKey());
        }
        Set set = counterofferAsks.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Iterable $this$filter$iv3 = set;
        boolean $i$f$filter = false;
        Iterable $i$f$filter22 = $this$filter$iv3;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            TradeOffer it = (TradeOffer)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == TradeOfferType.Luxury_Resource || it.getType() == TradeOfferType.Strategic_Resource)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Object e : (List)destination$iv$iv) {
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            TradeOffer ask = (TradeOffer)e;
            Object v = counterofferAsks.get(ask);
            Intrinsics.checkNotNull(v);
            int originalValue = ((Number)v).intValue();
            while (ask.getAmount() > 1 && originalValue == evaluation.evaluateBuyCostWithInflation(new TradeOffer(ask.getName(), ask.getType(), ask.getAmount() - 1, ask.getDuration()), civInfo, otherCiv, tradeRequest.getTrade())) {
                int $this$filterTo$iv$iv3 = ask.getAmount();
                ask.setAmount($this$filterTo$iv$iv3 + -1);
            }
        }
        ArrayList<Object> toRemove = new ArrayList<Object>();
        Set set2 = counterofferAsks.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        Iterable originalValue = set2;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        Iterator element$iv$iv = $this$filterTo$iv$iv2.iterator();
        while (element$iv$iv.hasNext()) {
            Object element$iv$iv2 = element$iv$iv.next();
            TradeOffer it = (TradeOffer)element$iv$iv2;
            boolean bl = false;
            if (!(it.getType() == TradeOfferType.Gold_Per_Turn || it.getType() == TradeOfferType.Gold)) continue;
            destination$iv$iv2.add(element$iv$iv2);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$sortedByDescending = false;
        for (Object t : CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                TradeOffer it = (TradeOffer)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getType().ordinal());
                it = (TradeOffer)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getType().ordinal());
            }
        })) {
            Intrinsics.checkNotNullExpressionValue(t, "next(...)");
            goldAsk = (TradeOffer)t;
            int valueOfOne = evaluation.evaluateBuyCostWithInflation(new TradeOffer(((TradeOffer)goldAsk).getName(), ((TradeOffer)goldAsk).getType(), 1, ((TradeOffer)goldAsk).getDuration()), civInfo, otherCiv, tradeRequest.getTrade());
            int amountCanBeRemoved = deltaInOurFavor / valueOfOne;
            if (amountCanBeRemoved >= ((TradeOffer)goldAsk).getAmount()) {
                Object v = counterofferAsks.get(goldAsk);
                Intrinsics.checkNotNull(v);
                deltaInOurFavor -= ((Number)v).intValue();
                toRemove.add(goldAsk);
                continue;
            }
            deltaInOurFavor -= valueOfOne * amountCanBeRemoved;
            ((TradeOffer)goldAsk).setAmount(((TradeOffer)goldAsk).getAmount() - amountCanBeRemoved);
        }
        if (deltaInOurFavor >= 100) {
            deltaInOurFavor = deltaInOurFavor * 2 / 3;
            goldAsk = tradeLogic.getOurAvailableOffers();
            $i$f$filter2 = false;
            Iterable amountCanBeRemoved = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$filterTo2 = false;
            for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                TradeOffer it = (TradeOffer)element$iv$iv3;
                boolean bl = false;
                if (!(it.isTradable() && (it.getType() == TradeOfferType.Gold || it.getType() == TradeOfferType.Gold_Per_Turn))) continue;
                destination$iv$iv2.add(element$iv$iv3);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            $i$f$sortedByDescending = false;
            for (Object t : CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                public final int compare(T a, T b) {
                    TradeOffer it = (TradeOffer)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getType().ordinal());
                    it = (TradeOffer)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getType().ordinal());
                }
            })) {
                boolean bl;
                TradeOffer ourGold;
                block41: {
                    TradeOffer it;
                    boolean bl7;
                    boolean $i$f$none;
                    Iterable $this$none$iv;
                    block40: {
                        Intrinsics.checkNotNullExpressionValue(t, "next(...)");
                        ourGold = (TradeOffer)t;
                        $this$none$iv = tradeLogic.getCurrentTrade().getTheirOffers();
                        $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl7 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                it = (TradeOffer)element$iv;
                                boolean bl8 = false;
                                if (!(it.getType() == ourGold.getType())) continue;
                                bl7 = false;
                                break block40;
                            }
                            bl7 = true;
                        }
                    }
                    if (!bl7) continue;
                    Set set3 = counterofferAsks.keySet();
                    Intrinsics.checkNotNullExpressionValue(set3, "<get-keys>(...)");
                    $this$none$iv = set3;
                    $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            it = (TradeOffer)element$iv;
                            boolean bl9 = false;
                            if (!(it.getType() == ourGold.getType())) continue;
                            bl = false;
                            break block41;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                int valueOfOne = evaluation.evaluateSellCostWithInflation(new TradeOffer(ourGold.getName(), ourGold.getType(), 1, ourGold.getDuration()), civInfo, otherCiv, tradeRequest.getTrade());
                int amountToGive = Math.min(deltaInOurFavor / valueOfOne, ourGold.getAmount());
                deltaInOurFavor -= amountToGive * valueOfOne;
                if (amountToGive <= 0) continue;
                counterofferGifts.add(new TradeOffer(ourGold.getName(), ourGold.getType(), amountToGive, ourGold.getDuration()));
            }
        }
        tradeLogic.getCurrentTrade().getTheirOffers().addAll(counterofferAsks.keySet());
        tradeLogic.getCurrentTrade().getOurOffers().addAll((Collection)counterofferGifts);
        return new TradeRequest(civInfo.getCivName(), tradeLogic.getCurrentTrade().reverse());
    }

    public final void exchangeLuxuries(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Sequence<Civilization> knownCivs = civInfo.getKnownCivs();
        Iterator<Civilization> iterator2 = SequencesKt.filter(knownCivs, arg_0 -> TradeAutomation.exchangeLuxuries$lambda$0(civInfo, arg_0)).iterator();
        while (iterator2.hasNext()) {
            Iterator<Trade> iterator3;
            boolean bl;
            Civilization otherCiv;
            block5: {
                otherCiv = iterator2.next();
                DiplomacyManager diplomacyManager = civInfo.getDiplomacyManager(otherCiv);
                Intrinsics.checkNotNull(diplomacyManager);
                boolean isEnemy = diplomacyManager.isRelationshipLevelLE(RelationshipLevel.Enemy);
                if (isEnemy) continue;
                Iterable $this$any$iv = otherCiv.getTradeRequests();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TradeRequest it = (TradeRequest)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getRequestingCiv(), civInfo.getCivName())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            ArrayList<Trade> trades = this.potentialLuxuryTrades(civInfo, otherCiv);
            Intrinsics.checkNotNullExpressionValue(trades.iterator(), "iterator(...)");
            while (iterator3.hasNext()) {
                Trade trade;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                TradeRequest tradeRequest = new TradeRequest(civInfo.getCivName(), trade.reverse());
                otherCiv.getTradeRequests().add(tradeRequest);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayList<Trade> potentialLuxuryTrades(Civilization civInfo, Civilization otherCivInfo) {
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv2;
        void $this$filterTo$iv$iv3;
        void $this$filter$iv3;
        void $this$filterTo$iv$iv4;
        void $this$filter$iv4;
        TradeLogic tradeLogic = new TradeLogic(civInfo, otherCivInfo);
        Iterable iterable = tradeLogic.getOurAvailableOffers();
        boolean $i$f$filter22 = false;
        void var7_7 = $this$filter$iv4;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv4) {
            TradeOffer it = (TradeOffer)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == TradeOfferType.Luxury_Resource && it.getAmount() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ourTradableLuxuryResources = (List)destination$iv$iv;
        Iterable $i$f$filter22 = tradeLogic.getTheirAvailableOffers();
        boolean $i$f$filter32 = false;
        destination$iv$iv = $this$filter$iv3;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            TradeOffer it = (TradeOffer)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == TradeOfferType.Luxury_Resource && it.getAmount() > 1)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List theirTradableLuxuryResources = (List)destination$iv$iv2;
        Iterable $i$f$filter32 = ourTradableLuxuryResources;
        boolean $i$f$filter42 = false;
        destination$iv$iv2 = $this$filter$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            boolean bl;
            block12: {
                void $this$none$iv;
                TradeOffer resource = (TradeOffer)element$iv$iv;
                boolean bl2 = false;
                Iterable iterable2 = tradeLogic.getTheirAvailableOffers();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        TradeOffer it = (TradeOffer)element$iv;
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual(it.getName(), resource.getName()) && it.getType() == TradeOfferType.Luxury_Resource)) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List weHaveTheyDont = (List)destination$iv$iv3;
        Iterable $i$f$filter42 = theirTradableLuxuryResources;
        boolean $i$f$filter = false;
        destination$iv$iv3 = $this$filter$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo4 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block13: {
                void $this$none$iv;
                TradeOffer resource = (TradeOffer)element$iv$iv;
                boolean bl4 = false;
                Iterable $i$f$none = tradeLogic.getOurAvailableOffers();
                boolean $i$f$none2 = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        TradeOffer it = (TradeOffer)element$iv;
                        boolean bl5 = false;
                        if (!(Intrinsics.areEqual(it.getName(), resource.getName()) && it.getType() == TradeOfferType.Luxury_Resource)) continue;
                        bl = false;
                        break block13;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv4;
        boolean $i$f$sortedBy = false;
        List theyHaveWeDont = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(civInfo){
            final /* synthetic */ Civilization $civInfo$inlined;
            {
                this.$civInfo$inlined = civilization;
            }

            public final int compare(T a, T b) {
                int n;
                boolean bl;
                City city;
                int count$iv;
                int n2;
                TradeOffer it = (TradeOffer)a;
                boolean bl2 = false;
                Iterable $this$count$iv = this.$civInfo$inlined.getCities();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        city = (City)element$iv;
                        bl = false;
                        if (!Intrinsics.areEqual(city.getDemandedResource(), it.getName()) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = count$iv;
                }
                it = (TradeOffer)b;
                Comparable comparable = Integer.valueOf(n2);
                bl2 = false;
                $this$count$iv = this.$civInfo$inlined.getCities();
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        city = (City)element$iv;
                        bl = false;
                        if (!Intrinsics.areEqual(city.getDemandedResource(), it.getName()) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                return ComparisonsKt.compareValues(comparable, n);
            }
        });
        ArrayList<Trade> trades = new ArrayList<Trade>();
        int i = 0;
        int n = Math.min(CollectionsKt.getLastIndex(weHaveTheyDont), CollectionsKt.getLastIndex(theyHaveWeDont));
        if (i <= n) {
            while (true) {
                Trade trade = new Trade();
                TradeOffersList tradeOffersList = trade.getOurOffers();
                Object e = weHaveTheyDont.get(i);
                Intrinsics.checkNotNullExpressionValue(e, "get(...)");
                tradeOffersList.add(TradeOffer.copy$default((TradeOffer)e, null, null, 1, 0, 11, null));
                TradeOffersList tradeOffersList2 = trade.getTheirOffers();
                Object t = theyHaveWeDont.get(i);
                Intrinsics.checkNotNullExpressionValue(t, "get(...)");
                tradeOffersList2.add(TradeOffer.copy$default((TradeOffer)t, null, null, 1, 0, 11, null));
                trades.add(trade);
                if (i == n) break;
                ++i;
            }
        }
        return trades;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean exchangeLuxuries$lambda$0(Civilization $civInfo, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!it.isMajorCiv()) return false;
        if (it.isAtWarWith($civInfo)) return false;
        DiplomacyManager diplomacyManager = $civInfo.getDiplomacyManager(it);
        Intrinsics.checkNotNull(diplomacyManager);
        if (diplomacyManager.hasFlag(DiplomacyFlags.DeclinedLuxExchange)) return false;
        return true;
    }
}

