/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.civilopediascreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.SplitPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.SnapshotArray;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.models.ruleset.ModOptions;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.stats.INamed;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.images.IconTextButton;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.RecreateOnResize;
import com.unciv.ui.screens.civilopediascreen.CivilopediaCategories;
import com.unciv.ui.screens.civilopediascreen.CivilopediaSearchPopup;
import com.unciv.ui.screens.civilopediascreen.ICivilopediaText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 62\u00020\u00012\u00020\u0002:\u0003456B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\bH\u0002J\u0010\u0010(\u001a\u00020'2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010*\u001a\u00020'2\u0006\u0010)\u001a\u00020\b2\b\b\u0002\u0010+\u001a\u00020,H\u0002J\u0010\u0010*\u001a\u00020'2\u0006\u0010-\u001a\u00020\u0010H\u0002J\b\u0010.\u001a\u00020'H\u0002J\u0010\u0010/\u001a\u00020'2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020'2\u0006\u00100\u001a\u000201H\u0002J\b\u00103\u001a\u00020\u0001H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR6\u0010\r\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000ej\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u000ej\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0013`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u001ej\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010 \u001a\u00020!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b\"\u0010#\u00a8\u00067"}, d2={"Lcom/unciv/ui/screens/civilopediascreen/CivilopediaScreen;", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "Lcom/unciv/ui/screens/basescreen/RecreateOnResize;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "category", "Lcom/unciv/ui/screens/civilopediascreen/CivilopediaCategories;", "link", "", "<init>", "(Lcom/unciv/models/ruleset/Ruleset;Lcom/unciv/ui/screens/civilopediascreen/CivilopediaCategories;Ljava/lang/String;)V", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "categoryToEntries", "Ljava/util/LinkedHashMap;", "", "Lcom/unciv/ui/screens/civilopediascreen/CivilopediaScreen$CivilopediaEntry;", "Lkotlin/collections/LinkedHashMap;", "categoryToButtons", "Lcom/unciv/ui/screens/civilopediascreen/CivilopediaScreen$CategoryButtonInfo;", "entryIndex", "buttonTableScroll", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "entrySelectTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "entrySelectScroll", "flavourTable", "currentCategory", "currentEntry", "currentEntryPerCategory", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "searchPopup", "Lcom/unciv/ui/screens/civilopediascreen/CivilopediaSearchPopup;", "getSearchPopup", "()Lcom/unciv/ui/screens/civilopediascreen/CivilopediaSearchPopup;", "searchPopup$delegate", "Lkotlin/Lazy;", "selectLink", "", "selectCategory", "name", "selectEntry", "noScrollAnimation", "", "entry", "selectDefaultEntry", "navigateCategories", "direction", "", "navigateEntries", "recreate", "CivilopediaEntry", "CategoryButtonInfo", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCivilopediaScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CivilopediaScreen.kt\ncom/unciv/ui/screens/civilopediascreen/CivilopediaScreen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,325:1\n1#2:326\n774#3:327\n865#3,2:328\n1563#3:330\n1634#3,3:331\n1869#3,2:334\n183#4,2:336\n*S KotlinDebug\n*F\n+ 1 CivilopediaScreen.kt\ncom/unciv/ui/screens/civilopediascreen/CivilopediaScreen\n*L\n210#1:327\n210#1:328,2\n211#1:330\n211#1:331,3\n184#1:334,2\n192#1:336,2\n*E\n"})
public final class CivilopediaScreen
extends BaseScreen
implements RecreateOnResize {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private final LinkedHashMap<CivilopediaCategories, Collection<CivilopediaEntry>> categoryToEntries;
    @NotNull
    private final LinkedHashMap<CivilopediaCategories, CategoryButtonInfo> categoryToButtons;
    @NotNull
    private final LinkedHashMap<String, CivilopediaEntry> entryIndex;
    @NotNull
    private final AutoScrollPane buttonTableScroll;
    @NotNull
    private final Table entrySelectTable;
    @NotNull
    private final AutoScrollPane entrySelectScroll;
    @NotNull
    private final Table flavourTable;
    @NotNull
    private CivilopediaCategories currentCategory;
    @NotNull
    private String currentEntry;
    @NotNull
    private final HashMap<CivilopediaCategories, String> currentEntryPerCategory;
    @NotNull
    private final Lazy searchPopup$delegate;

    /*
     * WARNING - void declaration
     */
    public CivilopediaScreen(@NotNull Ruleset ruleset, @NotNull CivilopediaCategories category, @NotNull String link) {
        void $this$entrySelectTable_u24lambda_u240;
        Table table2;
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        Intrinsics.checkNotNullParameter((Object)category, "category");
        Intrinsics.checkNotNullParameter(link, "link");
        this.ruleset = ruleset;
        this.categoryToEntries = new LinkedHashMap();
        this.categoryToButtons = new LinkedHashMap();
        this.entryIndex = new LinkedHashMap();
        Table table3 = table2 = new Table();
        Object object = this;
        boolean bl = false;
        $this$entrySelectTable_u24lambda_u240.defaults().pad(6.0f).left();
        ((CivilopediaScreen)object).entrySelectTable = table2;
        this.flavourTable = new Table();
        this.currentCategory = CivilopediaCategories.Tutorial;
        this.currentEntry = "";
        this.currentEntryPerCategory = new HashMap();
        this.searchPopup$delegate = LazyKt.lazy(() -> CivilopediaScreen.searchPopup_delegate$lambda$0(this));
        float imageSize = 50.0f;
        boolean religionEnabled = CivilopediaScreen.Companion.showReligionInCivilopedia(this.ruleset);
        for (CivilopediaCategories loopCategory : CivilopediaCategories.getEntries()) {
            void $this$mapTo$iv$iv;
            ICivilopediaText p0;
            Iterable $this$filterTo$iv$iv;
            if (!religionEnabled && loopCategory == CivilopediaCategories.Belief) continue;
            Map map2 = this.categoryToEntries;
            Iterable iterable = loopCategory.getGetCategoryIterator().invoke(this.ruleset, this.getTutorialController());
            boolean $i$f$filter = false;
            Iterable iterable2 = iterable;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                p0 = (ICivilopediaText)element$iv$iv;
                boolean bl2 = false;
                if (!CivilopediaScreen._init_$shouldBeDisplayed(this, p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable3 = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = iterable3;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable3, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                p0 = (ICivilopediaText)item$iv$iv;
                object = destination$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type com.unciv.models.stats.INamed");
                Function2<String, Float, Actor> function2 = loopCategory.getGetImage();
                object.add(new CivilopediaEntry(((INamed)it).getName(), function2 != null ? function2.invoke(it.getIconName(), Float.valueOf(imageSize)) : null, (ICivilopediaText)it, 0.0f, 0.0f, it.getSortGroup(this.ruleset), 24, null));
            }
            List iterable4 = (List)destination$iv$iv;
            map2.put(loopCategory, iterable4);
        }
        Table buttonTable = new Table();
        buttonTable.pad(15.0f);
        buttonTable.defaults().pad(10.0f);
        float currentX = 10.0f;
        for (Map.Entry entry : ((Map)this.categoryToEntries).entrySet()) {
            CivilopediaCategories categoryKey = (CivilopediaCategories)((Object)entry.getKey());
            Collection entries2 = (Collection)entry.getValue();
            if (entries2.isEmpty()) continue;
            Image icon = ((CharSequence)categoryKey.getHeaderIcon()).length() > 0 ? ImageGetter.getImage$default(ImageGetter.INSTANCE, categoryKey.getHeaderIcon(), null, 2, null) : null;
            IconTextButton button = new IconTextButton(categoryKey.getLabel(), (Actor)icon, 0, null, 12, null);
            ActivationExtensionsKt.onActivation$default(button, null, categoryKey.getBinding(), () -> CivilopediaScreen._init_$lambda$1(this, categoryKey), 1, null);
            Cell<Actor> cell = buttonTable.add((Actor)button);
            ((Map)this.categoryToButtons).put(categoryKey, new CategoryButtonInfo(button, currentX, cell.getPrefWidth()));
            currentX += cell.getPrefWidth() + 20.0f;
        }
        buttonTable.pack();
        this.buttonTableScroll = new AutoScrollPane((Actor)buttonTable, null, 2, null);
        this.buttonTableScroll.setScrollingDisabled(false, true);
        Color color = BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor();
        Color color2 = Color.GOLD;
        Intrinsics.checkNotNullExpressionValue(color2, "GOLD");
        Group searchButton = Scene2dExtensionsKt.toImageButton("OtherIcons/Search", imageSize - 16.0f, imageSize, color, color2);
        ActivationExtensionsKt.onActivation$default(searchButton, null, KeyboardBinding.PediaSearch, () -> CivilopediaScreen._init_$lambda$2(this), 1, null);
        Group group = Scene2dExtensionsKt.getCloseButton$default(imageSize, 0.0f, null, null, () -> CivilopediaScreen._init_$lambda$3(this), 14, null);
        Table topTable = new Table();
        topTable.add((Actor)this.buttonTableScroll).growX();
        topTable.add((Actor)searchButton).padLeft(10.0f);
        topTable.add((Actor)group).padLeft(10.0f).padRight(10.0f);
        topTable.setWidth(this.getStage().getWidth());
        topTable.layout();
        Table entryTable = new Table();
        SplitPane splitPane = new SplitPane((Actor)topTable, (Actor)entryTable, true, BaseScreen.Companion.getSkin());
        splitPane.setSplitAmount(topTable.getPrefHeight() / this.getStage().getHeight());
        entryTable.setHeight(this.getStage().getHeight() - topTable.getPrefHeight());
        splitPane.setFillParent(true);
        this.getStage().addActor(splitPane);
        this.entrySelectScroll = new AutoScrollPane((Actor)this.entrySelectTable, null, 2, null);
        this.entrySelectTable.top();
        this.entrySelectScroll.setOverscroll(false, false);
        Table descriptionTable = new Table();
        descriptionTable.add((Actor)this.flavourTable).padTop(7.0f).padBottom(5.0f).row();
        SplitPane entrySplitPane = new SplitPane((Actor)this.entrySelectScroll, (Actor)new AutoScrollPane((Actor)descriptionTable, null, 2, null), false, BaseScreen.Companion.getSkin());
        entrySplitPane.setSplitAmount(0.3f);
        entryTable.addActor(entrySplitPane);
        entrySplitPane.setFillParent(true);
        entrySplitPane.pack();
        if (((CharSequence)link).length() == 0 || !StringsKt.contains$default((CharSequence)link, '/', false, 2, null)) {
            this.selectCategory(category);
        }
        if (((CharSequence)link).length() == 0 && category == CivilopediaCategories.Tutorial) {
            this.selectDefaultEntry();
        }
        if (((CharSequence)link).length() > 0) {
            if (StringsKt.contains$default((CharSequence)link, '/', false, 2, null)) {
                this.selectLink(link);
            } else {
                this.selectEntry(link, true);
            }
        }
        this.getGlobalShortcuts().add(21, () -> CivilopediaScreen._init_$lambda$4(this));
        this.getGlobalShortcuts().add(22, () -> CivilopediaScreen._init_$lambda$5(this));
        this.getGlobalShortcuts().add(19, () -> CivilopediaScreen._init_$lambda$6(this));
        this.getGlobalShortcuts().add(20, () -> CivilopediaScreen._init_$lambda$7(this));
        this.getGlobalShortcuts().add(92, () -> CivilopediaScreen._init_$lambda$8(this));
        this.getGlobalShortcuts().add(93, () -> CivilopediaScreen._init_$lambda$9(this));
        this.getGlobalShortcuts().add(3, () -> CivilopediaScreen._init_$lambda$10(this));
        this.getGlobalShortcuts().add(123, () -> CivilopediaScreen._init_$lambda$11(this));
    }

    public /* synthetic */ CivilopediaScreen(Ruleset ruleset, CivilopediaCategories civilopediaCategories, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            civilopediaCategories = CivilopediaCategories.Tutorial;
        }
        if ((n & 4) != 0) {
            string = "";
        }
        this(ruleset, civilopediaCategories, string);
    }

    @NotNull
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    private final CivilopediaSearchPopup getSearchPopup() {
        Lazy lazy = this.searchPopup$delegate;
        return (CivilopediaSearchPopup)lazy.getValue();
    }

    private final void selectLink(String link) {
        char[] cArray = new char[]{'/'};
        List parts = StringsKt.split$default((CharSequence)link, cArray, false, 2, 2, null);
        if (parts.isEmpty()) {
            return;
        }
        this.selectCategory((String)parts.get(0));
        if (parts.size() >= 2) {
            this.selectEntry((String)parts.get(1), true);
        }
    }

    private final void selectCategory(String name) {
        CivilopediaCategories civilopediaCategories = CivilopediaCategories.Companion.fromLink(name);
        if (civilopediaCategories == null) {
            return;
        }
        CivilopediaCategories category = civilopediaCategories;
        this.selectCategory(category);
    }

    private final void selectCategory(CivilopediaCategories category) {
        this.currentCategory = category;
        this.entrySelectTable.clear();
        this.entryIndex.clear();
        this.flavourTable.clear();
        Iterator<CategoryButtonInfo> iterator2 = this.categoryToButtons.values().iterator();
        while (iterator2.hasNext()) {
            CategoryButtonInfo button;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            button.getButton().setColor(Color.WHITE);
        }
        CategoryButtonInfo categoryButtonInfo = this.categoryToButtons.get((Object)category);
        if (categoryButtonInfo == null) {
            return;
        }
        CategoryButtonInfo buttonInfo = categoryButtonInfo;
        buttonInfo.getButton().setColor(Color.BLUE);
        this.buttonTableScroll.setScrollX(buttonInfo.getX() + (buttonInfo.getWidth() - this.buttonTableScroll.getWidth()) / (float)2);
        if (!((Map)this.categoryToEntries).containsKey((Object)category)) {
            return;
        }
        Collection collection = this.categoryToEntries.get((Object)category);
        Intrinsics.checkNotNull(collection);
        Collection entries2 = collection;
        if (category != CivilopediaCategories.Difficulty) {
            Comparator comparator = new Comparator(){

                public final int compare(T a, T b) {
                    CivilopediaEntry it = (CivilopediaEntry)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getSortBy());
                    it = (CivilopediaEntry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getSortBy());
                }
            };
            Comparator comparator2 = UncivGame.Companion.getCurrent().getSettings().getCollatorFromLocale();
            entries2 = CollectionsKt.sortedWith(entries2, new Comparator(comparator, comparator2){
                final /* synthetic */ Comparator $this_thenBy;
                final /* synthetic */ Comparator $comparator;
                {
                    this.$this_thenBy = $receiver;
                    this.$comparator = $comparator;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        CivilopediaEntry civilopediaEntry = (CivilopediaEntry)a;
                        Comparator comparator = this.$comparator;
                        boolean bl = false;
                        CivilopediaEntry it = (CivilopediaEntry)b;
                        String string = TranslationsKt.tr(it.getName(), true, true);
                        bl = false;
                        String string2 = TranslationsKt.tr(it.getName(), true, true);
                        n = comparator.compare(string, string2);
                    }
                    return n;
                }
            });
        }
        float currentY = -1.0f;
        for (CivilopediaEntry entry : entries2) {
            Table table2;
            Table $this$selectCategory_u24lambda_u242 = table2 = new Table();
            boolean bl = false;
            $this$selectCategory_u24lambda_u242.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CivilopediaScreen/EntryButton", null, Scene2dExtensionsKt.colorFromRGB(50, 75, 125), 2, null));
            $this$selectCategory_u24lambda_u242.setTouchable(Touchable.enabled);
            Table entryButton = table2;
            if (entry.getImage() != null) {
                Cell<Actor> cell = category == CivilopediaCategories.Terrain ? entryButton.add(entry.getImage()).padLeft(20.0f).padRight(10.0f) : entryButton.add(entry.getImage()).padLeft(10.0f);
            }
            Table table3 = entryButton.left();
            String string = entry.getName();
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            table3.add((Actor)Scene2dExtensionsKt.toLabel$default(string, color, 25, 0, true, 4, null)).pad(10.0f);
            ActivationExtensionsKt.onClick(entryButton, () -> CivilopediaScreen.selectCategory$lambda$3(this, entry));
            entryButton.setName(entry.getName());
            Cell<Actor> cell = this.entrySelectTable.add((Actor)entryButton).height(75.0f).expandX().fillX();
            this.entrySelectTable.row();
            if (currentY < 0.0f) {
                currentY = cell.getPadTop();
            }
            ((Map)this.entryIndex).put(entry.getName(), entry.withCoordinates(currentY, cell.getPrefHeight()));
            currentY += cell.getPadBottom() + cell.getPrefHeight() + cell.getPadTop();
        }
        this.entrySelectScroll.layout();
        String entry = this.currentEntryPerCategory.get((Object)category);
        if (entry != null) {
            CivilopediaScreen.selectEntry$default(this, entry, false, 2, null);
        }
    }

    private final void selectEntry(String name, boolean noScrollAnimation) {
        CivilopediaEntry civilopediaEntry = this.entryIndex.get(name);
        if (civilopediaEntry == null) {
            return;
        }
        CivilopediaEntry entry = civilopediaEntry;
        this.entrySelectScroll.setScrollY(entry.getY() + (entry.getHeight() - this.entrySelectScroll.getHeight()) / (float)2);
        if (noScrollAnimation) {
            this.entrySelectScroll.updateVisualScroll();
        }
        this.selectEntry(entry);
    }

    static /* synthetic */ void selectEntry$default(CivilopediaScreen civilopediaScreen, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        civilopediaScreen.selectEntry(string, bl);
    }

    private final void selectEntry(CivilopediaEntry entry) {
        this.currentEntry = entry.getName();
        ((Map)this.currentEntryPerCategory).put(this.currentCategory, entry.getName());
        this.flavourTable.clear();
        if (entry.getFlavour() != null) {
            this.flavourTable.setVisible(true);
            this.flavourTable.add((Actor)entry.getFlavour().assembleCivilopediaText(this.ruleset).renderCivilopediaText(this.getStage().getWidth() * 0.5f, arg_0 -> CivilopediaScreen.selectEntry$lambda$0(this, arg_0)));
        } else {
            this.flavourTable.setVisible(false);
        }
        SnapshotArray<Actor> snapshotArray = this.entrySelectTable.getChildren();
        Intrinsics.checkNotNullExpressionValue(snapshotArray, "getChildren(...)");
        Iterable $this$forEach$iv = snapshotArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Actor it = (Actor)element$iv;
            boolean bl = false;
            it.setColor(Intrinsics.areEqual(it.getName(), entry.getName()) ? Color.BLUE : Color.WHITE);
        }
    }

    private final void selectDefaultEntry() {
        String string;
        block2: {
            Sequence<String> $this$firstOrNull$iv = SequencesKt.plus(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.ruleset.getMods()), CivilopediaScreen::selectDefaultEntry$lambda$0), "Civilopedia");
            boolean $i$f$firstOrNull = false;
            Iterator<String> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                String element$iv;
                String it = element$iv = iterator2.next();
                boolean bl = false;
                if (!this.entryIndex.keySet().contains(it)) continue;
                string = element$iv;
                break block2;
            }
            string = null;
        }
        String string2 = string;
        if (string2 == null) {
            return;
        }
        String name = string2;
        this.selectEntry(name, true);
    }

    private final void navigateCategories(int direction) {
        Set<CivilopediaCategories> set = this.categoryToEntries.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Set<CivilopediaCategories> categoryKeys = set;
        int currentIndex = CollectionsKt.indexOf((Iterable)categoryKeys, this.currentCategory);
        int newIndex = (currentIndex + categoryKeys.size() + direction) % categoryKeys.size();
        Object t = CollectionsKt.elementAt((Iterable)categoryKeys, newIndex);
        Intrinsics.checkNotNullExpressionValue(t, "elementAt(...)");
        this.selectCategory((CivilopediaCategories)((Object)t));
    }

    private final void navigateEntries(int direction) {
        int n;
        Set<String> set = this.entryIndex.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        int index = CollectionsKt.indexOf((Iterable)set, this.currentEntry);
        if (index < 0) {
            Set<String> set2 = this.entryIndex.keySet();
            Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
            Object t = CollectionsKt.first((Iterable)set2);
            Intrinsics.checkNotNullExpressionValue(t, "first(...)");
            this.selectEntry((String)t, true);
            return;
        }
        switch (direction) {
            case -2147483648: {
                n = 0;
                break;
            }
            case 0x7FFFFFFF: {
                n = this.entryIndex.size() - 1;
                break;
            }
            default: {
                n = (index + this.entryIndex.size() + direction) % this.entryIndex.size();
            }
        }
        int newIndex = n;
        Set<String> set3 = this.entryIndex.keySet();
        Intrinsics.checkNotNullExpressionValue(set3, "<get-keys>(...)");
        Object t = CollectionsKt.first(CollectionsKt.drop((Iterable)set3, newIndex));
        Intrinsics.checkNotNullExpressionValue(t, "first(...)");
        CivilopediaScreen.selectEntry$default(this, (String)t, false, 2, null);
    }

    @Override
    @NotNull
    public BaseScreen recreate() {
        return new CivilopediaScreen(this.ruleset, this.currentCategory, this.currentEntry);
    }

    private static final CivilopediaSearchPopup searchPopup_delegate$lambda$0(CivilopediaScreen this$0) {
        return new CivilopediaSearchPopup(this$0, this$0.getTutorialController(), arg_0 -> CivilopediaScreen.searchPopup_delegate$lambda$0$0(this$0, arg_0));
    }

    private static final Unit searchPopup_delegate$lambda$0$0(CivilopediaScreen this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.selectLink(it);
        return Unit.INSTANCE;
    }

    private static final Unit selectCategory$lambda$3(CivilopediaScreen this$0, CivilopediaEntry $entry) {
        this$0.selectEntry($entry);
        return Unit.INSTANCE;
    }

    private static final Unit selectEntry$lambda$0(CivilopediaScreen this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.selectLink(it);
        return Unit.INSTANCE;
    }

    private static final boolean selectDefaultEntry$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Object object = (Ruleset)RulesetCache.INSTANCE.get((Object)it);
        return object != null && (object = ((Ruleset)object).getModOptions()) != null ? ((ModOptions)object).isBaseRuleset() : false;
    }

    private static final boolean _init_$shouldBeDisplayed(CivilopediaScreen this$0, ICivilopediaText obj) {
        return !(obj instanceof IHasUniques) || !((IHasUniques)((Object)obj)).isHiddenFromCivilopedia(this$0.getGame().getGameInfo(), this$0.ruleset);
    }

    private static final Unit _init_$lambda$1(CivilopediaScreen this$0, CivilopediaCategories $categoryKey) {
        this$0.selectCategory($categoryKey);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(CivilopediaScreen this$0) {
        this$0.getSearchPopup().open(true);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(CivilopediaScreen this$0) {
        this$0.getGame().popScreen();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(CivilopediaScreen this$0) {
        this$0.navigateCategories(-1);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(CivilopediaScreen this$0) {
        this$0.navigateCategories(1);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(CivilopediaScreen this$0) {
        this$0.navigateEntries(-1);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(CivilopediaScreen this$0) {
        this$0.navigateEntries(1);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$8(CivilopediaScreen this$0) {
        this$0.navigateEntries(-10);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$9(CivilopediaScreen this$0) {
        this$0.navigateEntries(10);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$10(CivilopediaScreen this$0) {
        this$0.navigateEntries(Integer.MIN_VALUE);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$11(CivilopediaScreen this$0) {
        this$0.navigateEntries(Integer.MAX_VALUE);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/screens/civilopediascreen/CivilopediaScreen$CategoryButtonInfo;", "", "button", "Lcom/badlogic/gdx/scenes/scene2d/ui/Button;", "x", "", "width", "<init>", "(Lcom/badlogic/gdx/scenes/scene2d/ui/Button;FF)V", "getButton", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Button;", "getX", "()F", "getWidth", "core"})
    private static final class CategoryButtonInfo {
        @NotNull
        private final Button button;
        private final float x;
        private final float width;

        public CategoryButtonInfo(@NotNull Button button, float x, float width) {
            Intrinsics.checkNotNullParameter(button, "button");
            this.button = button;
            this.x = x;
            this.width = width;
        }

        @NotNull
        public final Button getButton() {
            return this.button;
        }

        public final float getX() {
            return this.x;
        }

        public final float getWidth() {
            return this.width;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\b\u0002\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lcom/unciv/ui/screens/civilopediascreen/CivilopediaScreen$CivilopediaEntry;", "", "name", "", "image", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "flavour", "Lcom/unciv/ui/screens/civilopediascreen/ICivilopediaText;", "y", "", "height", "sortBy", "", "<init>", "(Ljava/lang/String;Lcom/badlogic/gdx/scenes/scene2d/Actor;Lcom/unciv/ui/screens/civilopediascreen/ICivilopediaText;FFI)V", "getName", "()Ljava/lang/String;", "getImage", "()Lcom/badlogic/gdx/scenes/scene2d/Actor;", "getFlavour", "()Lcom/unciv/ui/screens/civilopediascreen/ICivilopediaText;", "getY", "()F", "getHeight", "getSortBy", "()I", "withCoordinates", "core"})
    private static final class CivilopediaEntry {
        @NotNull
        private final String name;
        @Nullable
        private final Actor image;
        @Nullable
        private final ICivilopediaText flavour;
        private final float y;
        private final float height;
        private final int sortBy;

        public CivilopediaEntry(@NotNull String name, @Nullable Actor image, @Nullable ICivilopediaText flavour, float y, float height, int sortBy2) {
            Intrinsics.checkNotNullParameter(name, "name");
            this.name = name;
            this.image = image;
            this.flavour = flavour;
            this.y = y;
            this.height = height;
            this.sortBy = sortBy2;
        }

        public /* synthetic */ CivilopediaEntry(String string, Actor actor, ICivilopediaText iCivilopediaText, float f, float f2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                actor = null;
            }
            if ((n2 & 4) != 0) {
                iCivilopediaText = null;
            }
            if ((n2 & 8) != 0) {
                f = 0.0f;
            }
            if ((n2 & 0x10) != 0) {
                f2 = 0.0f;
            }
            if ((n2 & 0x20) != 0) {
                n = 0;
            }
            this(string, actor, iCivilopediaText, f, f2, n);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final Actor getImage() {
            return this.image;
        }

        @Nullable
        public final ICivilopediaText getFlavour() {
            return this.flavour;
        }

        public final float getY() {
            return this.y;
        }

        public final float getHeight() {
            return this.height;
        }

        public final int getSortBy() {
            return this.sortBy;
        }

        @NotNull
        public final CivilopediaEntry withCoordinates(float y, float height) {
            return new CivilopediaEntry(this.name, this.image, this.flavour, y, height, this.sortBy);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/civilopediascreen/CivilopediaScreen$Companion;", "", "<init>", "()V", "showReligionInCivilopedia", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean showReligionInCivilopedia(Ruleset ruleset) {
            boolean bl;
            GameInfo gameInfo = UncivGame.Companion.getGameInfoOrNull();
            GameInfo gameInfo2 = gameInfo;
            if (gameInfo2 != null) {
                bl = gameInfo2.isReligionEnabled();
            } else {
                Ruleset ruleset2 = ruleset;
                bl = ruleset2 != null ? !((Map)ruleset2.getBeliefs()).isEmpty() : true;
            }
            return bl;
        }

        static /* synthetic */ boolean showReligionInCivilopedia$default(Companion companion, Ruleset ruleset, int n, Object object) {
            if ((n & 1) != 0) {
                ruleset = null;
            }
            return companion.showReligionInCivilopedia(ruleset);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

