/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.city.City;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.ISortableGridContentProvider;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.SortableGrid;
import com.unciv.ui.components.widgets.UnitIconGroup;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.IconTextButton;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewCategories;
import com.unciv.ui.screens.overviewscreen.UnitOverviewTab;
import com.unciv.ui.screens.overviewscreen.UnitOverviewTabHelpers;
import com.unciv.ui.screens.pickerscreens.UnitRenamePopup;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u0000 72\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\b\u0012\u0004\u0012\u00020\u00000\u0004:\u00017B)\b\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010(\u001a\u0004\u0018\u00010\u00062\u0006\u0010)\u001a\u00020\u0002H\u0017J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u0002H\u0017J\"\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010)\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-2\u0006\u00101\u001a\u00020\u0003H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\u000203H\u0016J\u0018\u00104\u001a\u0004\u0018\u0001002\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000206H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001fR\u0014\u0010\"\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001fR\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'j\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018\u00a8\u00068"}, d2={"Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn;", "Lcom/unciv/ui/components/ISortableGridContentProvider;", "Lcom/unciv/logic/map/mapunit/MapUnit;", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTab;", "", "headerLabel", "", "headerTip", "isNumeric", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Z)V", "getHeaderTip", "()Ljava/lang/String;", "Name", "EditName", "Action", "Strength", "RangedStrength", "Movement", "ClosestCity", "Promotions", "Upgrade", "Health", "XP", "align", "", "getAlign", "()I", "fillX", "getFillX", "()Z", "expandX", "getExpandX", "equalizeHeight", "getEqualizeHeight", "defaultSort", "Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "getDefaultSort", "()Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "getEntryString", "item", "getHeaderActor", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "iconSize", "", "getEntryValue", "getEntryActor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "actionContext", "getComparator", "Ljava/util/Comparator;", "getTotalsActor", "items", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nUnitOverviewTabColumn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitOverviewTabColumn.kt\ncom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public class UnitOverviewTabColumn
extends Enum<UnitOverviewTabColumn>
implements ISortableGridContentProvider<MapUnit, UnitOverviewTab> {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private final String headerLabel;
    @NotNull
    private final String headerTip;
    private final boolean isNumeric;
    private final int align;
    private final boolean fillX;
    private final boolean expandX;
    private final boolean equalizeHeight;
    public static final /* enum */ UnitOverviewTabColumn Name;
    public static final /* enum */ UnitOverviewTabColumn EditName;
    public static final /* enum */ UnitOverviewTabColumn Action;
    public static final /* enum */ UnitOverviewTabColumn Strength;
    public static final /* enum */ UnitOverviewTabColumn RangedStrength;
    public static final /* enum */ UnitOverviewTabColumn Movement;
    public static final /* enum */ UnitOverviewTabColumn ClosestCity;
    public static final /* enum */ UnitOverviewTabColumn Promotions;
    public static final /* enum */ UnitOverviewTabColumn Upgrade;
    public static final /* enum */ UnitOverviewTabColumn Health;
    public static final /* enum */ UnitOverviewTabColumn XP;
    private static final /* synthetic */ UnitOverviewTabColumn[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private UnitOverviewTabColumn(String headerLabel, String headerTip, boolean isNumeric) {
        this.headerLabel = headerLabel;
        this.headerTip = headerTip;
        this.isNumeric = isNumeric;
        this.align = 1;
    }

    /* synthetic */ UnitOverviewTabColumn(String string, int n, String string2, String string3, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string2 = null;
        }
        if ((n2 & 2) != 0) {
            string3 = "";
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(string2, string3, bl);
    }

    @Override
    @NotNull
    public String getHeaderTip() {
        return this.headerTip;
    }

    @Override
    public int getAlign() {
        return this.align;
    }

    @Override
    public boolean getFillX() {
        return this.fillX;
    }

    @Override
    public boolean getExpandX() {
        return this.expandX;
    }

    @Override
    public boolean getEqualizeHeight() {
        return this.equalizeHeight;
    }

    @Override
    @NotNull
    public SortableGrid.SortDirection getDefaultSort() {
        return SortableGrid.SortDirection.Ascending;
    }

    @Readonly
    @Nullable
    public String getEntryString(@NotNull MapUnit item) {
        Intrinsics.checkNotNullParameter(item, "item");
        Integer n = this.getEntryValue(item);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it > 0 ? n : null;
        return n2 != null ? TranslationsKt.tr(n2) : null;
    }

    @Override
    @NotNull
    public Label getHeaderActor(float iconSize) {
        String string = this.headerLabel;
        if (string == null) {
            string = this.name();
        }
        return Scene2dExtensionsKt.toLabel(string);
    }

    @Override
    @Readonly
    public int getEntryValue(@NotNull MapUnit item) {
        Intrinsics.checkNotNullParameter(item, "item");
        return 0;
    }

    @Override
    @Nullable
    public Actor getEntryActor(@NotNull MapUnit item, float iconSize, @NotNull UnitOverviewTab actionContext) {
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(actionContext, "actionContext");
        String string = this.getEntryString(item);
        return string != null ? Scene2dExtensionsKt.toLabel$default(string, null, 0, 1, true, 3, null) : null;
    }

    @Override
    @NotNull
    public Comparator<MapUnit> getComparator() {
        Comparator comparator;
        if (this.isNumeric) {
            comparator = ISortableGridContentProvider.super.getComparator();
        } else {
            Comparator comparator2 = ISortableGridContentProvider.Companion.getCollator();
            comparator = new Comparator(comparator2, this){
                final /* synthetic */ Comparator $comparator;
                final /* synthetic */ UnitOverviewTabColumn this$0;
                {
                    this.$comparator = $comparator;
                    this.this$0 = unitOverviewTabColumn;
                }

                public final int compare(T a, T b) {
                    MapUnit it;
                    MapUnit mapUnit = (MapUnit)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    String string = this.this$0.getEntryString(it);
                    if (string == null || (string = TranslationsKt.tr$default(string, true, false, 2, null)) == null) {
                        string = "\ud83d\ude00zzz";
                    }
                    it = (MapUnit)b;
                    String string2 = string;
                    bl = false;
                    String string3 = this.this$0.getEntryString(it);
                    if (string3 == null || (string3 = TranslationsKt.tr$default(string3, true, false, 2, null)) == null) {
                        string3 = "\ud83d\ude00zzz";
                    }
                    String string4 = string3;
                    return comparator.compare(string2, string4);
                }
            };
        }
        return comparator;
    }

    @Override
    @Nullable
    public Actor getTotalsActor(@NotNull Iterable<MapUnit> items) {
        Intrinsics.checkNotNullParameter(items, "items");
        return null;
    }

    public static UnitOverviewTabColumn[] values() {
        return (UnitOverviewTabColumn[])$VALUES.clone();
    }

    public static UnitOverviewTabColumn valueOf(String value) {
        return Enum.valueOf(UnitOverviewTabColumn.class, value);
    }

    @NotNull
    public static EnumEntries<UnitOverviewTabColumn> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ UnitOverviewTabColumn(String $enum$name, int $enum$ordinal, String headerLabel, String headerTip, boolean isNumeric, DefaultConstructorMarker $constructor_marker) {
        this(headerLabel, headerTip, isNumeric);
    }

    static {
        Name = new Name("Name", 0);
        EditName = new EditName("EditName", 1);
        Action = new Action("Action", 2);
        Strength = new Strength("Strength", 3);
        RangedStrength = new RangedStrength("RangedStrength", 4);
        Movement = new Movement("Movement", 5);
        ClosestCity = new ClosestCity("ClosestCity", 6);
        Promotions = new Promotions("Promotions", 7);
        Upgrade = new Upgrade("Upgrade", 8);
        Health = new Health("Health", 9);
        XP = new XP("XP", 10);
        $VALUES = unitOverviewTabColumnArray = new UnitOverviewTabColumn[]{UnitOverviewTabColumn.Name, UnitOverviewTabColumn.EditName, UnitOverviewTabColumn.Action, UnitOverviewTabColumn.Strength, UnitOverviewTabColumn.RangedStrength, UnitOverviewTabColumn.Movement, UnitOverviewTabColumn.ClosestCity, UnitOverviewTabColumn.Promotions, UnitOverviewTabColumn.Upgrade, UnitOverviewTabColumn.Health, UnitOverviewTabColumn.XP};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn.Action", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn;", "getEntryString", "", "item", "Lcom/unciv/logic/map/mapunit/MapUnit;", "core"})
    static final class Action
    extends UnitOverviewTabColumn {
        /*
         * WARNING - void declaration
         */
        Action() {
            void var1_1;
        }

        @Override
        @Nullable
        public String getEntryString(@NotNull MapUnit item) {
            Intrinsics.checkNotNullParameter(item, "item");
            String string = Companion.getActionText(item);
            return string != null ? TranslationsKt.tr$default(string, false, false, 3, null) : null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000/\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0003\u00a8\u0006\u000e"}, d2={"com/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn.ClosestCity", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn;", "getEntryString", "", "item", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getEntryActor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "iconSize", "", "actionContext", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTab;", "getClosestCityTile", "Lcom/unciv/logic/map/tile/Tile;", "core"})
    @SourceDebugExtension(value={"SMAP\nUnitOverviewTabColumn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitOverviewTabColumn.kt\ncom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn$ClosestCity\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,155:1\n183#2,2:156\n*S KotlinDebug\n*F\n+ 1 UnitOverviewTabColumn.kt\ncom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn$ClosestCity\n*L\n98#1:156,2\n*E\n"})
    static final class ClosestCity
    extends UnitOverviewTabColumn {
        /*
         * WARNING - void declaration
         */
        ClosestCity() {
            void var1_1;
        }

        @Override
        @Nullable
        public String getEntryString(@NotNull MapUnit item) {
            Intrinsics.checkNotNullParameter(item, "item");
            Object object = this.getClosestCityTile(item);
            return object != null && (object = ((Tile)object).getCity()) != null && (object = ((City)object).getName()) != null ? TranslationsKt.tr$default((String)object, true, false, 2, null) : null;
        }

        @Override
        @Nullable
        public Actor getEntryActor(@NotNull MapUnit item, float iconSize, @NotNull UnitOverviewTab actionContext) {
            Color color;
            Intrinsics.checkNotNullParameter(item, "item");
            Intrinsics.checkNotNullParameter(actionContext, "actionContext");
            Tile tile = this.getClosestCityTile(item);
            if (tile == null) {
                return null;
            }
            Tile closestCityTile = tile;
            if (Intrinsics.areEqual(item.getTile(), closestCityTile)) {
                Color color2 = Color.FOREST;
                Intrinsics.checkNotNullExpressionValue(color2, "FOREST");
                color = Scene2dExtensionsKt.brighten(color2, 0.5f);
            } else {
                color = Color.WHITE;
            }
            Color cityColor = color;
            City city = closestCityTile.getCity();
            Intrinsics.checkNotNull(city);
            String string = city.getName();
            Intrinsics.checkNotNull(cityColor);
            Label label = Scene2dExtensionsKt.toLabel$default(string, cityColor, 0, 1, false, 10, null);
            ActivationExtensionsKt.onClick(label, () -> ClosestCity.getEntryActor$lambda$0(closestCityTile));
            return label;
        }

        @Readonly
        private final Tile getClosestCityTile(MapUnit item) {
            Tile tile;
            block1: {
                Sequence<Tile> $this$firstOrNull$iv = item.getTile().getTilesInDistance(3);
                boolean $i$f$firstOrNull = false;
                Iterator<Tile> iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator2.next();
                    boolean bl = false;
                    if (!it.isCityCenter()) continue;
                    tile = element$iv;
                    break block1;
                }
                tile = null;
            }
            return tile;
        }

        private static final Unit getEntryActor$lambda$0(Tile $closestCityTile) {
            Companion.showWorldScreenAt($closestCityTile);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn$Companion;", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTabHelpers;", "<init>", "()V", "core"})
    public static final class Companion
    extends UnitOverviewTabHelpers {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000+\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"com/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn.EditName", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn;", "defaultSort", "Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "getDefaultSort", "()Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "getEntryActor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "item", "Lcom/unciv/logic/map/mapunit/MapUnit;", "iconSize", "", "actionContext", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTab;", "core"})
    @SourceDebugExtension(value={"SMAP\nUnitOverviewTabColumn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitOverviewTabColumn.kt\ncom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn$EditName\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
    static final class EditName
    extends UnitOverviewTabColumn {
        /*
         * WARNING - void declaration
         */
        EditName() {
            void var1_1;
        }

        @Override
        @NotNull
        public SortableGrid.SortDirection getDefaultSort() {
            return SortableGrid.SortDirection.None;
        }

        @Override
        @NotNull
        public Actor getEntryActor(@NotNull MapUnit item, float iconSize, @NotNull UnitOverviewTab actionContext) {
            Image image;
            Intrinsics.checkNotNullParameter(item, "item");
            Intrinsics.checkNotNullParameter(actionContext, "actionContext");
            String selectKey = String.valueOf(item.getId());
            Image $this$getEntryActor_u24lambda_u240 = image = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Pencil", null, 2, null);
            boolean bl = false;
            $this$getEntryActor_u24lambda_u240.setColor(Color.WHITE);
            IconCircleGroup editIcon = Scene2dExtensionsKt.surroundWithCircle$default(image, 30.0f, true, new Color(3121), null, 8, null);
            ActivationExtensionsKt.onClick(editIcon, () -> EditName.getEntryActor$lambda$1(actionContext, item, selectKey));
            return editIcon;
        }

        private static final Unit getEntryActor$lambda$1(UnitOverviewTab $actionContext, MapUnit $item, String $selectKey) {
            new UnitRenamePopup($actionContext.getOverviewScreen(), $item, () -> EditName.getEntryActor$lambda$1$0($actionContext, $selectKey));
            return Unit.INSTANCE;
        }

        private static final Unit getEntryActor$lambda$1$0(UnitOverviewTab $actionContext, String $selectKey) {
            UnitOverviewTab.update$core$default($actionContext, false, 1, null);
            $actionContext.getOverviewScreen().select(EmpireOverviewCategories.Units, $selectKey);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000)\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0016\u00a8\u0006\f"}, d2={"com/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn.Health", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn;", "getEntryValue", "", "item", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getEntryString", "", "getTotalsActor", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "items", "", "core"})
    @SourceDebugExtension(value={"SMAP\nUnitOverviewTabColumn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitOverviewTabColumn.kt\ncom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn$Health\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1788#2,4:156\n*S KotlinDebug\n*F\n+ 1 UnitOverviewTabColumn.kt\ncom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn$Health\n*L\n119#1:156,4\n*E\n"})
    static final class Health
    extends UnitOverviewTabColumn {
        /*
         * WARNING - void declaration
         */
        Health() {
            void var1_1;
        }

        @Override
        public int getEntryValue(@NotNull MapUnit item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return item.getHealth();
        }

        @Override
        @Nullable
        public String getEntryString(@NotNull MapUnit item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return item.getHealth() == 100 ? null : TranslationsKt.tr(item.getHealth());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Label getTotalsActor(@NotNull Iterable<MapUnit> items) {
            int n;
            void $this$count$iv;
            Intrinsics.checkNotNullParameter(items, "items");
            Iterable<MapUnit> iterable = items;
            ISortableGridContentProvider.Companion companion = ISortableGridContentProvider.Companion;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    MapUnit it = (MapUnit)element$iv;
                    boolean bl = false;
                    if (!(it.getHealth() < 100) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int n2 = n;
            return companion.toCenteredLabel(n2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000)\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\t0\u000bj\b\u0012\u0004\u0012\u00020\t`\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\r"}, d2={"com/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn.Movement", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn;", "defaultSort", "Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "getDefaultSort", "()Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "getEntryString", "", "item", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "core"})
    static final class Movement
    extends UnitOverviewTabColumn {
        /*
         * WARNING - void declaration
         */
        Movement() {
            void var1_1;
        }

        @Override
        @NotNull
        public SortableGrid.SortDirection getDefaultSort() {
            return SortableGrid.SortDirection.Descending;
        }

        @Override
        @NotNull
        public String getEntryString(@NotNull MapUnit item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return item.getMovementString();
        }

        @Override
        @NotNull
        public Comparator<MapUnit> getComparator() {
            Comparator comparator = new Comparator(){

                public final int compare(T a, T b) {
                    MapUnit it = (MapUnit)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(MapUnit.getMaxMovement$default(it, false, 1, null));
                    it = (MapUnit)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, MapUnit.getMaxMovement$default(it, false, 1, null));
                }
            };
            return new Comparator(comparator){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = $receiver;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        MapUnit it = (MapUnit)a;
                        boolean bl = false;
                        Comparable comparable = Float.valueOf(it.getCurrentMovement());
                        it = (MapUnit)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        n = ComparisonsKt.compareValues(comparable2, (Comparable)Float.valueOf(it.getCurrentMovement()));
                    }
                    return n;
                }
            };
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000=\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0014"}, d2={"com/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn.Name", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn;", "fillX", "", "getFillX", "()Z", "getEntryString", "", "item", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getEntryActor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "iconSize", "", "actionContext", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTab;", "getTotalsActor", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "items", "", "core"})
    @SourceDebugExtension(value={"SMAP\nUnitOverviewTabColumn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitOverviewTabColumn.kt\ncom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn$Name\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
    static final class Name
    extends UnitOverviewTabColumn {
        private final boolean fillX;

        /*
         * WARNING - void declaration
         */
        Name() {
            void var1_1;
            this.fillX = true;
        }

        @Override
        public boolean getFillX() {
            return this.fillX;
        }

        @Override
        @NotNull
        public String getEntryString(@NotNull MapUnit item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return TranslationsKt.tr$default(item.displayName(), true, false, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Actor getEntryActor(@NotNull MapUnit item, float iconSize, @NotNull UnitOverviewTab actionContext) {
            void $this$getEntryActor_u24lambda_u240;
            Intrinsics.checkNotNullParameter(item, "item");
            Intrinsics.checkNotNullParameter(actionContext, "actionContext");
            Object object = new UnitIconGroup(item, 20.0f);
            UnitIconGroup unitIconGroup = object;
            String string = item.displayName();
            boolean bl = false;
            if (!MapUnit.isIdle$default($this$getEntryActor_u24lambda_u240.getUnit(), false, 1, null)) {
                $this$getEntryActor_u24lambda_u240.getColor().a = 0.5f;
            }
            Actor actor = (Actor)object;
            object = MapUnit.isIdle$default(item, false, 1, null) ? Color.WHITE : Color.LIGHT_GRAY;
            Intrinsics.checkNotNull(object);
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 4;
            Object object2 = object;
            int n2 = 0;
            Actor actor2 = actor;
            String string2 = string;
            IconTextButton button = new IconTextButton(string2, actor2, n2, (Color)object2, n, defaultConstructorMarker);
            button.setName("unit-" + item.getId());
            ActivationExtensionsKt.onClick(button, () -> Name.getEntryActor$lambda$1(item));
            return button;
        }

        @Override
        @NotNull
        public Label getTotalsActor(@NotNull Iterable<MapUnit> items) {
            Intrinsics.checkNotNullParameter(items, "items");
            return ISortableGridContentProvider.Companion.toCenteredLabel(CollectionsKt.count(items));
        }

        private static final Unit getEntryActor$lambda$1(MapUnit $item) {
            Companion.showWorldScreenAt($item);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0010"}, d2={"com/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn.Promotions", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn;", "defaultSort", "Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "getDefaultSort", "()Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "getEntryValue", "", "item", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getEntryActor", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "iconSize", "", "actionContext", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTab;", "core"})
    static final class Promotions
    extends UnitOverviewTabColumn {
        /*
         * WARNING - void declaration
         */
        Promotions() {
            void var1_1;
        }

        @Override
        @NotNull
        public SortableGrid.SortDirection getDefaultSort() {
            return SortableGrid.SortDirection.Descending;
        }

        @Override
        public int getEntryValue(@NotNull MapUnit item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return (item.getPromotions().canBePromoted() ? 10000 : 0) + item.getPromotions().getPromotions().size();
        }

        @Override
        @NotNull
        public Table getEntryActor(@NotNull MapUnit item, float iconSize, @NotNull UnitOverviewTab actionContext) {
            Intrinsics.checkNotNullParameter(item, "item");
            Intrinsics.checkNotNullParameter(actionContext, "actionContext");
            return Companion.getPromotionsTable(item, actionContext);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"com/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn.RangedStrength", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn;", "defaultSort", "Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "getDefaultSort", "()Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "getEntryValue", "", "item", "Lcom/unciv/logic/map/mapunit/MapUnit;", "core"})
    static final class RangedStrength
    extends UnitOverviewTabColumn {
        /*
         * WARNING - void declaration
         */
        RangedStrength() {
            void var1_1;
        }

        @Override
        @NotNull
        public SortableGrid.SortDirection getDefaultSort() {
            return SortableGrid.SortDirection.Descending;
        }

        @Override
        public int getEntryValue(@NotNull MapUnit item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return item.getBaseUnit().getRangedStrength();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"com/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn.Strength", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn;", "defaultSort", "Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "getDefaultSort", "()Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "getEntryValue", "", "item", "Lcom/unciv/logic/map/mapunit/MapUnit;", "core"})
    static final class Strength
    extends UnitOverviewTabColumn {
        /*
         * WARNING - void declaration
         */
        Strength() {
            void var1_1;
        }

        @Override
        @NotNull
        public SortableGrid.SortDirection getDefaultSort() {
            return SortableGrid.SortDirection.Descending;
        }

        @Override
        public int getEntryValue(@NotNull MapUnit item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return item.getBaseUnit().getStrength();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016\u00a8\u0006\u0010"}, d2={"com/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn.Upgrade", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn;", "getEntryString", "", "item", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getEntryActor", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "iconSize", "", "actionContext", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTab;", "getTotalsActor", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "items", "", "core"})
    @SourceDebugExtension(value={"SMAP\nUnitOverviewTabColumn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitOverviewTabColumn.kt\ncom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn$Upgrade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1788#2,4:156\n*S KotlinDebug\n*F\n+ 1 UnitOverviewTabColumn.kt\ncom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn$Upgrade\n*L\n113#1:156,4\n*E\n"})
    static final class Upgrade
    extends UnitOverviewTabColumn {
        /*
         * WARNING - void declaration
         */
        Upgrade() {
            void var1_1;
        }

        @Override
        @Nullable
        public String getEntryString(@NotNull MapUnit item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return Companion.getUpgradeSortString(item);
        }

        @Override
        @Nullable
        public Table getEntryActor(@NotNull MapUnit item, float iconSize, @NotNull UnitOverviewTab actionContext) {
            Intrinsics.checkNotNullParameter(item, "item");
            Intrinsics.checkNotNullParameter(actionContext, "actionContext");
            return Companion.getUpgradeTable(item, actionContext);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Label getTotalsActor(@NotNull Iterable<MapUnit> items) {
            int n;
            void $this$count$iv;
            Intrinsics.checkNotNullParameter(items, "items");
            Iterable<MapUnit> iterable = items;
            ISortableGridContentProvider.Companion companion = ISortableGridContentProvider.Companion;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    MapUnit it = (MapUnit)element$iv;
                    boolean bl = false;
                    if (!(Companion.getUpgradeSortString(it) != null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int n2 = n;
            return companion.toCenteredLabel(n2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00050\tj\b\u0012\u0004\u0012\u00020\u0005`\nH\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0016\u00a8\u0006\u000f"}, d2={"com/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn.XP", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn;", "getEntryValue", "", "item", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getEntryString", "", "getComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getTotalsActor", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "items", "", "core"})
    @SourceDebugExtension(value={"SMAP\nUnitOverviewTabColumn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitOverviewTabColumn.kt\ncom/unciv/ui/screens/overviewscreen/UnitOverviewTabColumn$XP\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
    static final class XP
    extends UnitOverviewTabColumn {
        /*
         * WARNING - void declaration
         */
        XP() {
            void var1_1;
        }

        @Override
        public int getEntryValue(@NotNull MapUnit item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return item.getPromotions().getXP();
        }

        @Override
        @NotNull
        public String getEntryString(@NotNull MapUnit item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return item.isCivilian() ? "" : "" + '{' + item.getPromotions().getXP() + "}/{" + item.getPromotions().xpForNextPromotion() + '}';
        }

        @Override
        @NotNull
        public Comparator<MapUnit> getComparator() {
            Comparator comparator = new Comparator(){

                public final int compare(T a, T b) {
                    MapUnit it = (MapUnit)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPromotions().xpForNextPromotion());
                    it = (MapUnit)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getPromotions().xpForNextPromotion());
                }
            };
            return new Comparator(comparator){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = $receiver;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        MapUnit it = (MapUnit)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getPromotions().getXP());
                        it = (MapUnit)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        n = ComparisonsKt.compareValues(comparable2, it.getPromotions().getXP());
                    }
                    return n;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Label getTotalsActor(@NotNull Iterable<MapUnit> items) {
            Intrinsics.checkNotNullParameter(items, "items");
            Iterable<MapUnit> iterable = items;
            int n = 0;
            Iterator<MapUnit> iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                void it;
                MapUnit mapUnit;
                MapUnit mapUnit2 = mapUnit = iterator2.next();
                int n2 = n;
                boolean bl = false;
                int n3 = it.getPromotions().getXP();
                n = n2 + n3;
            }
            return Scene2dExtensionsKt.toLabel(n);
        }
    }
}

