/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.input;

import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.input.KeyboardBindings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0003\u001d\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0018\u00010\rj\u0004\u0018\u0001`\u000eJ.\u0010\t\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0018\u00010\rj\u0004\u0018\u0001`\u000eJ&\u0010\t\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0018\u00010\rj\u0004\u0018\u0001`\u000eJ+\u0010\t\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0018\u00010\rj\u0004\u0018\u0001`\u000e\u00a2\u0006\u0002\u0010\u0017J+\u0010\t\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0018\u00010\rj\u0004\u0018\u0001`\u000e\u00a2\u0006\u0002\u0010\u0019J\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/unciv/ui/components/input/KeyShortcutDispatcher;", "", "<init>", "()V", "shortcuts", "", "Lcom/unciv/ui/components/input/KeyShortcutDispatcher$ShortcutAction;", "clear", "", "add", "shortcut", "Lcom/unciv/ui/components/input/KeyShortcutDispatcher$KeyShortcut;", "action", "Lkotlin/Function0;", "Lcom/unciv/ui/components/input/ActivationAction;", "binding", "Lcom/unciv/ui/components/input/KeyboardBinding;", "priority", "", "key", "Lcom/unciv/ui/components/input/KeyCharAndCode;", "char", "", "(Ljava/lang/Character;Lkotlin/jvm/functions/Function0;)V", "keyCode", "(Ljava/lang/Integer;Lkotlin/jvm/functions/Function0;)V", "contains", "", "isActive", "KeyShortcut", "ShortcutAction", "Resolver", "core"})
@SourceDebugExtension(value={"SMAP\nKeyShortcutDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyShortcutDispatcher.kt\ncom/unciv/ui/components/input/KeyShortcutDispatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1761#2,3:81\n*S KotlinDebug\n*F\n+ 1 KeyShortcutDispatcher.kt\ncom/unciv/ui/components/input/KeyShortcutDispatcher\n*L\n52#1:81,3\n*E\n"})
public class KeyShortcutDispatcher {
    @NotNull
    private final List<ShortcutAction> shortcuts = new ArrayList();

    public final void clear() {
        this.shortcuts.clear();
    }

    public final void add(@Nullable KeyShortcut shortcut, @Nullable Function0<Unit> action2) {
        if (action2 == null || shortcut == null) {
            return;
        }
        CollectionsKt.removeAll(this.shortcuts, arg_0 -> KeyShortcutDispatcher.add$lambda$0(shortcut, arg_0));
        this.shortcuts.add(new ShortcutAction(shortcut, action2));
    }

    public final void add(@NotNull KeyboardBinding binding, int priority, @Nullable Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)binding, "binding");
        this.add(new KeyShortcut(binding, KeyCharAndCode.Companion.getUNKNOWN(), priority), action2);
    }

    public static /* synthetic */ void add$default(KeyShortcutDispatcher keyShortcutDispatcher, KeyboardBinding keyboardBinding, int n, Function0 function0, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
        }
        if ((n2 & 2) != 0) {
            n = 1;
        }
        keyShortcutDispatcher.add(keyboardBinding, n, function0);
    }

    public final void add(@Nullable KeyCharAndCode key, @Nullable Function0<Unit> action2) {
        if (key != null) {
            this.add(new KeyShortcut(KeyboardBinding.None, key, 0, 4, null), action2);
        }
    }

    public final void add(@Nullable Character c, @Nullable Function0<Unit> action2) {
        if (c != null) {
            this.add(new KeyCharAndCode(c.charValue()), action2);
        }
    }

    public final void add(@Nullable Integer keyCode, @Nullable Function0<Unit> action2) {
        if (keyCode != null) {
            this.add(new KeyCharAndCode(keyCode), action2);
        }
    }

    public final boolean contains(@NotNull KeyCharAndCode key) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(key, "key");
            Iterable $this$any$iv = this.shortcuts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ShortcutAction it = (ShortcutAction)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(key, it.getShortcut().getRealKey())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean isActive() {
        return true;
    }

    private static final boolean add$lambda$0(KeyShortcut $shortcut, ShortcutAction it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getShortcut(), $shortcut);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\u0005J\u0006\u0010\u000f\u001a\u00020\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/unciv/ui/components/input/KeyShortcutDispatcher$KeyShortcut;", "", "binding", "Lcom/unciv/ui/components/input/KeyboardBinding;", "key", "Lcom/unciv/ui/components/input/KeyCharAndCode;", "priority", "", "<init>", "(Lcom/unciv/ui/components/input/KeyboardBinding;Lcom/unciv/ui/components/input/KeyCharAndCode;I)V", "getPriority", "()I", "toString", "", "getRealKey", "getRealPriority", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "core"})
    public static final class KeyShortcut {
        @NotNull
        private final KeyboardBinding binding;
        @NotNull
        private final KeyCharAndCode key;
        private final int priority;

        public KeyShortcut(@NotNull KeyboardBinding binding, @NotNull KeyCharAndCode key, int priority) {
            Intrinsics.checkNotNullParameter((Object)binding, "binding");
            Intrinsics.checkNotNullParameter(key, "key");
            this.binding = binding;
            this.key = key;
            this.priority = priority;
        }

        public /* synthetic */ KeyShortcut(KeyboardBinding keyboardBinding, KeyCharAndCode keyCharAndCode, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            this(keyboardBinding, keyCharAndCode, n);
        }

        public final int getPriority() {
            return this.priority;
        }

        @NotNull
        public String toString() {
            return this.binding.getHidden() ? "" + this.key + '@' + this.priority : "" + (Object)((Object)this.binding) + '@' + this.priority;
        }

        @NotNull
        public final KeyCharAndCode getRealKey() {
            return this.binding == KeyboardBinding.None ? this.key : KeyboardBindings.Companion.get(this.binding);
        }

        public final int getRealPriority() {
            if (this.binding != KeyboardBinding.None && Intrinsics.areEqual(KeyboardBindings.Companion.get(this.binding), this.binding.getDefaultKey())) {
                return this.priority - 1;
            }
            return this.priority;
        }

        private final KeyboardBinding component1() {
            return this.binding;
        }

        private final KeyCharAndCode component2() {
            return this.key;
        }

        public final int component3() {
            return this.priority;
        }

        @NotNull
        public final KeyShortcut copy(@NotNull KeyboardBinding binding, @NotNull KeyCharAndCode key, int priority) {
            Intrinsics.checkNotNullParameter((Object)binding, "binding");
            Intrinsics.checkNotNullParameter(key, "key");
            return new KeyShortcut(binding, key, priority);
        }

        public static /* synthetic */ KeyShortcut copy$default(KeyShortcut keyShortcut, KeyboardBinding keyboardBinding, KeyCharAndCode keyCharAndCode, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                keyboardBinding = keyShortcut.binding;
            }
            if ((n2 & 2) != 0) {
                keyCharAndCode = keyShortcut.key;
            }
            if ((n2 & 4) != 0) {
                n = keyShortcut.priority;
            }
            return keyShortcut.copy(keyboardBinding, keyCharAndCode, n);
        }

        public int hashCode() {
            int result2 = this.binding.hashCode();
            result2 = result2 * 31 + this.key.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.priority);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KeyShortcut)) {
                return false;
            }
            KeyShortcut keyShortcut = (KeyShortcut)other;
            if (this.binding != keyShortcut.binding) {
                return false;
            }
            if (!Intrinsics.areEqual(this.key, keyShortcut.key)) {
                return false;
            }
            return this.priority == keyShortcut.priority;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/unciv/ui/components/input/KeyShortcutDispatcher$Resolver;", "", "key", "Lcom/unciv/ui/components/input/KeyCharAndCode;", "<init>", "(Lcom/unciv/ui/components/input/KeyCharAndCode;)V", "getKey", "()Lcom/unciv/ui/components/input/KeyCharAndCode;", "priority", "", "triggeredActions", "", "Lkotlin/Function0;", "", "Lcom/unciv/ui/components/input/ActivationAction;", "getTriggeredActions", "()Ljava/util/List;", "updateFor", "dispatcher", "Lcom/unciv/ui/components/input/KeyShortcutDispatcher;", "core"})
    public static final class Resolver {
        @NotNull
        private final KeyCharAndCode key;
        private int priority;
        @NotNull
        private final List<Function0<Unit>> triggeredActions;

        public Resolver(@NotNull KeyCharAndCode key) {
            Intrinsics.checkNotNullParameter(key, "key");
            this.key = key;
            this.priority = Integer.MIN_VALUE;
            this.triggeredActions = new ArrayList();
        }

        @NotNull
        public final KeyCharAndCode getKey() {
            return this.key;
        }

        @NotNull
        public final List<Function0<Unit>> getTriggeredActions() {
            return this.triggeredActions;
        }

        public final void updateFor(@NotNull KeyShortcutDispatcher dispatcher) {
            Intrinsics.checkNotNullParameter(dispatcher, "dispatcher");
            if (!dispatcher.isActive()) {
                return;
            }
            for (ShortcutAction shortcutAction : dispatcher.shortcuts) {
                int shortcutPriority;
                KeyShortcut shortcut = shortcutAction.component1();
                Function0<Unit> action2 = shortcutAction.component2();
                if (!Intrinsics.areEqual(shortcut.getRealKey(), this.key) || (shortcutPriority = shortcut.getRealPriority()) < this.priority) continue;
                if (shortcutPriority > this.priority) {
                    this.priority = shortcutPriority;
                    this.triggeredActions.clear();
                }
                this.triggeredActions.add(action2);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0012\b\u0002\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/unciv/ui/components/input/KeyShortcutDispatcher$ShortcutAction;", "", "shortcut", "Lcom/unciv/ui/components/input/KeyShortcutDispatcher$KeyShortcut;", "action", "Lkotlin/Function0;", "", "Lcom/unciv/ui/components/input/ActivationAction;", "<init>", "(Lcom/unciv/ui/components/input/KeyShortcutDispatcher$KeyShortcut;Lkotlin/jvm/functions/Function0;)V", "getShortcut", "()Lcom/unciv/ui/components/input/KeyShortcutDispatcher$KeyShortcut;", "getAction", "()Lkotlin/jvm/functions/Function0;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
    private static final class ShortcutAction {
        @NotNull
        private final KeyShortcut shortcut;
        @NotNull
        private final Function0<Unit> action;

        public ShortcutAction(@NotNull KeyShortcut shortcut, @NotNull Function0<Unit> action2) {
            Intrinsics.checkNotNullParameter(shortcut, "shortcut");
            Intrinsics.checkNotNullParameter(action2, "action");
            this.shortcut = shortcut;
            this.action = action2;
        }

        @NotNull
        public final KeyShortcut getShortcut() {
            return this.shortcut;
        }

        @NotNull
        public final Function0<Unit> getAction() {
            return this.action;
        }

        @NotNull
        public final KeyShortcut component1() {
            return this.shortcut;
        }

        @NotNull
        public final Function0<Unit> component2() {
            return this.action;
        }

        @NotNull
        public final ShortcutAction copy(@NotNull KeyShortcut shortcut, @NotNull Function0<Unit> action2) {
            Intrinsics.checkNotNullParameter(shortcut, "shortcut");
            Intrinsics.checkNotNullParameter(action2, "action");
            return new ShortcutAction(shortcut, action2);
        }

        public static /* synthetic */ ShortcutAction copy$default(ShortcutAction shortcutAction, KeyShortcut keyShortcut, Function0 function0, int n, Object object) {
            if ((n & 1) != 0) {
                keyShortcut = shortcutAction.shortcut;
            }
            if ((n & 2) != 0) {
                function0 = shortcutAction.action;
            }
            return shortcutAction.copy(keyShortcut, function0);
        }

        @NotNull
        public String toString() {
            return "ShortcutAction(shortcut=" + this.shortcut + ", action=" + this.action + ')';
        }

        public int hashCode() {
            int result2 = this.shortcut.hashCode();
            result2 = result2 * 31 + this.action.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShortcutAction)) {
                return false;
            }
            ShortcutAction shortcutAction = (ShortcutAction)other;
            if (!Intrinsics.areEqual(this.shortcut, shortcutAction.shortcut)) {
                return false;
            }
            return Intrinsics.areEqual(this.action, shortcutAction.action);
        }
    }
}

