/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.victoryscreen;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.utils.Array;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.ui.screens.worldscreen.minimap.MinimapTile;
import com.unciv.ui.screens.worldscreen.minimap.MinimapTileUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0014J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H$J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001a\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/unciv/ui/screens/victoryscreen/IndependentMiniMap;", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "tileMap", "Lcom/unciv/logic/map/TileMap;", "<init>", "(Lcom/unciv/logic/map/TileMap;)V", "getTileMap", "()Lcom/unciv/logic/map/TileMap;", "minimapTiles", "", "Lcom/unciv/ui/screens/worldscreen/minimap/MinimapTile;", "getMinimapTiles", "()Ljava/util/List;", "setMinimapTiles", "(Ljava/util/List;)V", "deferredInit", "", "maxWidth", "", "maxHeight", "calcTileSize", "includeTileFilter", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "createReplayMap", "tileSize", "core"})
@SourceDebugExtension(value={"SMAP\nReplayMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplayMap.kt\ncom/unciv/ui/screens/victoryscreen/IndependentMiniMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n774#2:140\n865#2,2:141\n*S KotlinDebug\n*F\n+ 1 ReplayMap.kt\ncom/unciv/ui/screens/victoryscreen/IndependentMiniMap\n*L\n53#1:140\n53#1:141,2\n*E\n"})
public abstract class IndependentMiniMap
extends Group {
    @NotNull
    private final TileMap tileMap;
    protected List<MinimapTile> minimapTiles;

    public IndependentMiniMap(@NotNull TileMap tileMap) {
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        this.tileMap = tileMap;
    }

    @NotNull
    public final TileMap getTileMap() {
        return this.tileMap;
    }

    @NotNull
    protected final List<MinimapTile> getMinimapTiles() {
        List<MinimapTile> list2 = this.minimapTiles;
        if (list2 != null) {
            return list2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("minimapTiles");
        return null;
    }

    protected final void setMinimapTiles(@NotNull List<MinimapTile> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.minimapTiles = list2;
    }

    protected void deferredInit(float maxWidth, float maxHeight) {
        float tileSize = this.calcTileSize(maxWidth, maxHeight);
        this.setMinimapTiles(this.createReplayMap(tileSize));
        Rectangle tileExtension = MinimapTileUtil.INSTANCE.spreadOutMinimapTiles(this, this.getMinimapTiles(), tileSize);
        Iterator iterator2 = this.getChildren().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (((Array.ArrayIterator)iterator3).hasNext()) {
            Actor group = (Actor)((Array.ArrayIterator)iterator3).next();
            group.moveBy(-tileExtension.x, -tileExtension.y);
        }
        this.setSize(tileExtension.width, tileExtension.height);
    }

    protected abstract float calcTileSize(float var1, float var2);

    protected boolean includeTileFilter(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MinimapTile> createReplayMap(float tileSize) {
        void $this$filterTo$iv$iv;
        Function0<Unit> doNothing = IndependentMiniMap::createReplayMap$lambda$0;
        ArrayList<MinimapTile> tiles = new ArrayList<MinimapTile>(this.tileMap.getValues().size());
        Iterable $this$filter$iv = this.tileMap.getValues();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tile p0 = (Tile)element$iv$iv;
            boolean bl = false;
            if (!this.includeTileFilter(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Tile tile : (List)destination$iv$iv) {
            MinimapTile minimapTile = new MinimapTile(tile, tileSize, doNothing);
            minimapTile.updateColor(false, null);
            tiles.add(minimapTile);
        }
        tiles.trimToSize();
        return tiles;
    }

    private static final Unit createReplayMap$lambda$0() {
        return Unit.INSTANCE;
    }
}

