/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.header;

import io.ktor.http.HeaderValueParam;
import io.ktor.http.HeaderValueWithParameters;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0015\u0010\f\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lio/ktor/http/header/AcceptEncoding;", "Lio/ktor/http/HeaderValueWithParameters;", "", "acceptEncoding", "", "Lio/ktor/http/HeaderValueParam;", "parameters", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "", "qValue", "(Ljava/lang/String;D)V", "withQValue", "(D)Lio/ktor/http/header/AcceptEncoding;", "pattern", "", "match", "(Lio/ktor/http/header/AcceptEncoding;)Z", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Ljava/lang/String;", "getAcceptEncoding", "()Ljava/lang/String;", "Companion", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nAcceptEncoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcceptEncoding.kt\nio/ktor/http/header/AcceptEncoding\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1761#2,3:133\n*S KotlinDebug\n*F\n+ 1 AcceptEncoding.kt\nio/ktor/http/header/AcceptEncoding\n*L\n102#1:133,3\n*E\n"})
public final class AcceptEncoding
extends HeaderValueWithParameters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String acceptEncoding;
    @NotNull
    private static final AcceptEncoding Gzip = new AcceptEncoding("gzip", null, 2, null);
    @NotNull
    private static final AcceptEncoding Compress = new AcceptEncoding("compress", null, 2, null);
    @NotNull
    private static final AcceptEncoding Deflate = new AcceptEncoding("deflate", null, 2, null);
    @NotNull
    private static final AcceptEncoding Br = new AcceptEncoding("br", null, 2, null);
    @NotNull
    private static final AcceptEncoding Zstd = new AcceptEncoding("zstd", null, 2, null);
    @NotNull
    private static final AcceptEncoding Identity = new AcceptEncoding("identity", null, 2, null);
    @NotNull
    private static final AcceptEncoding All = new AcceptEncoding("*", null, 2, null);

    public AcceptEncoding(@NotNull String acceptEncoding, @NotNull List<HeaderValueParam> parameters) {
        Intrinsics.checkNotNullParameter(acceptEncoding, "acceptEncoding");
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        super(acceptEncoding, parameters);
        this.acceptEncoding = acceptEncoding;
    }

    public /* synthetic */ AcceptEncoding(String string, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(string, list2);
    }

    @NotNull
    public final String getAcceptEncoding() {
        return this.acceptEncoding;
    }

    public AcceptEncoding(@NotNull String acceptEncoding, double qValue) {
        Intrinsics.checkNotNullParameter(acceptEncoding, "acceptEncoding");
        this(acceptEncoding, CollectionsKt.listOf(new HeaderValueParam("q", String.valueOf(qValue))));
    }

    @NotNull
    public final AcceptEncoding withQValue(double qValue) {
        if (Intrinsics.areEqual(String.valueOf(qValue), this.parameter("q"))) {
            return this;
        }
        return new AcceptEncoding(this.acceptEncoding, qValue);
    }

    public final boolean match(@NotNull AcceptEncoding pattern) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        if (!Intrinsics.areEqual(pattern.acceptEncoding, "*") && !StringsKt.equals(pattern.acceptEncoding, this.acceptEncoding, true)) {
            return false;
        }
        for (HeaderValueParam headerValueParam : pattern.getParameters()) {
            boolean matches;
            boolean bl;
            block9: {
                String patternName = headerValueParam.component1();
                String patternValue = headerValueParam.component2();
                if (Intrinsics.areEqual(patternName, "*")) {
                    if (Intrinsics.areEqual(patternValue, "*")) {
                        bl = true;
                    } else {
                        Iterable $this$any$iv = this.getParameters();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                HeaderValueParam p = (HeaderValueParam)element$iv;
                                boolean bl2 = false;
                                if (!StringsKt.equals(p.getValue(), patternValue, true)) continue;
                                bl = true;
                                break block9;
                            }
                            bl = false;
                        }
                    }
                } else {
                    String value = this.parameter(patternName);
                    bl = Intrinsics.areEqual(patternValue, "*") ? value != null : StringsKt.equals(value, patternValue, true);
                }
            }
            if (matches = bl) continue;
            return false;
        }
        return true;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof AcceptEncoding && StringsKt.equals(this.acceptEncoding, ((AcceptEncoding)other).acceptEncoding, true) && Intrinsics.areEqual(this.getParameters(), ((AcceptEncoding)other).getParameters());
    }

    public int hashCode() {
        String string = this.acceptEncoding.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        int hashCode = string.hashCode();
        return hashCode += 31 * ((Object)this.getParameters()).hashCode();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\b\u001a\u00020\u00072\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\u0010\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u0011\u0010\rR\u0017\u0010\u0012\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u0013\u0010\rR\u0017\u0010\u0014\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000b\u001a\u0004\b\u0015\u0010\rR\u0017\u0010\u0016\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000b\u001a\u0004\b\u0017\u0010\rR\u0017\u0010\u0018\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000b\u001a\u0004\b\u0019\u0010\r\u00a8\u0006\u001a"}, d2={"Lio/ktor/http/header/AcceptEncoding$Companion;", "", "<init>", "()V", "", "Lio/ktor/http/header/AcceptEncoding;", "encodings", "", "mergeAcceptEncodings", "([Lio/ktor/http/header/AcceptEncoding;)Ljava/lang/String;", "Gzip", "Lio/ktor/http/header/AcceptEncoding;", "getGzip", "()Lio/ktor/http/header/AcceptEncoding;", "Compress", "getCompress", "Deflate", "getDeflate", "Br", "getBr", "Zstd", "getZstd", "Identity", "getIdentity", "All", "getAll", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AcceptEncoding getGzip() {
            return Gzip;
        }

        @NotNull
        public final AcceptEncoding getCompress() {
            return Compress;
        }

        @NotNull
        public final AcceptEncoding getDeflate() {
            return Deflate;
        }

        @NotNull
        public final AcceptEncoding getBr() {
            return Br;
        }

        @NotNull
        public final AcceptEncoding getZstd() {
            return Zstd;
        }

        @NotNull
        public final AcceptEncoding getIdentity() {
            return Identity;
        }

        @NotNull
        public final AcceptEncoding getAll() {
            return All;
        }

        @NotNull
        public final String mergeAcceptEncodings(AcceptEncoding ... encodings) {
            Intrinsics.checkNotNullParameter(encodings, "encodings");
            return ArraysKt.joinToString$default(encodings, (CharSequence)", ", null, null, 0, null, null, 62, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

