/**
 * Enable the lookup of test mock objects if requested
 * @param enabled
 */
export declare function setEnableEnvMocks(enabled: boolean): void;
/**
 * Return the named global object if available, will return null if the object is not available.
 * @param name The globally named object
 */
export declare function getGlobalInst<T>(name: string): T;
/**
 * Checks if window object is available, this is required as we support the API running without a
 * window /document (eg. Node server, electron webworkers) and if we attempt to assign a window
 * object to a local variable or pass as an argument an "Uncaught ReferenceError: window is not defined"
 * exception will be thrown.
 * Defined as a function to support lazy / late binding environments.
 */
export declare function hasWindow(): boolean;
/**
 * Returns the global window object if it is present otherwise null.
 * This helper is used to access the window object without causing an exception
 * "Uncaught ReferenceError: window is not defined"
 */
export declare function getWindow(): Window | null;
/**
 * Checks if document object is available, this is required as we support the API running without a
 * window /document (eg. Node server, electron webworkers) and if we attempt to assign a document
 * object to a local variable or pass as an argument an "Uncaught ReferenceError: document is not defined"
 * exception will be thrown.
 * Defined as a function to support lazy / late binding environments.
 */
export declare function hasDocument(): boolean;
/**
 * Returns the global document object if it is present otherwise null.
 * This helper is used to access the document object without causing an exception
 * "Uncaught ReferenceError: document is not defined"
 */
export declare function getDocument(): Document | null;
/**
 * Checks if navigator object is available, this is required as we support the API running without a
 * window /document (eg. Node server, electron webworkers) and if we attempt to assign a navigator
 * object to a local variable or pass as an argument an "Uncaught ReferenceError: navigator is not defined"
 * exception will be thrown.
 * Defined as a function to support lazy / late binding environments.
 */
export declare function hasNavigator(): boolean;
/**
 * Returns the global navigator object if it is present otherwise null.
 * This helper is used to access the navigator object without causing an exception
 * "Uncaught ReferenceError: navigator is not defined"
 */
export declare function getNavigator(): Navigator | null;
/**
 * Checks if history object is available, this is required as we support the API running without a
 * window /document (eg. Node server, electron webworkers) and if we attempt to assign a history
 * object to a local variable or pass as an argument an "Uncaught ReferenceError: history is not defined"
 * exception will be thrown.
 * Defined as a function to support lazy / late binding environments.
 */
export declare function hasHistory(): boolean;
/**
 * Returns the global history object if it is present otherwise null.
 * This helper is used to access the history object without causing an exception
 * "Uncaught ReferenceError: history is not defined"
 */
export declare function getHistory(): History | null;
/**
 * Returns the global location object if it is present otherwise null.
 * This helper is used to access the location object without causing an exception
 * "Uncaught ReferenceError: location is not defined"
 */
export declare function getLocation(checkForMock?: boolean): Location | null;
/**
 * Returns the global console object
 */
export declare function getConsole(): Console | null;
/**
 * Returns the performance object if it is present otherwise null.
 * This helper is used to access the performance object from the current
 * global instance which could be window or globalThis for a web worker
 */
export declare function getPerformance(): Performance | null;
/**
 * Checks if JSON object is available, this is required as we support the API running without a
 * window /document (eg. Node server, electron webworkers) and if we attempt to assign a history
 * object to a local variable or pass as an argument an "Uncaught ReferenceError: JSON is not defined"
 * exception will be thrown.
 * Defined as a function to support lazy / late binding environments.
 */
export declare function hasJSON(): boolean;
/**
 * Returns the global JSON object if it is present otherwise null.
 * This helper is used to access the JSON object without causing an exception
 * "Uncaught ReferenceError: JSON is not defined"
 */
export declare function getJSON(): JSON | null;
/**
 * Returns the crypto object if it is present otherwise null.
 * This helper is used to access the crypto object from the current
 * global instance which could be window or globalThis for a web worker
 */
export declare function getCrypto(): Crypto | null;
/**
 * Returns the crypto object if it is present otherwise null.
 * This helper is used to access the crypto object from the current
 * global instance which could be window or globalThis for a web worker
 */
export declare function getMsCrypto(): Crypto | null;
/**
 * Returns whether the environment is reporting that we are running in a React Native Environment
 */
export declare function isReactNative(): boolean;
/**
 * Identifies whether the current environment appears to be IE
 */
export declare function isIE(): boolean;
/**
 * Gets IE version returning the document emulation mode if we are running on IE, or null otherwise
 */
export declare function getIEVersion(userAgentStr?: string): number;
/**
 * Returns string representation of an object suitable for diagnostics logging.
 */
export declare function dumpObj(object: any): string;
export declare function isSafari(userAgentStr?: string): boolean;
/**
 * Checks if HTML5 Beacons are supported in the current environment.
 * @returns True if supported, false otherwise.
 */
export declare function isBeaconsSupported(): boolean;
/**
 * Checks if the Fetch API is supported in the current environment.
 * @param withKeepAlive - [Optional] If True, check if fetch is available and it supports the keepalive feature, otherwise only check if fetch is supported
 * @returns True if supported, otherwise false
 */
export declare function isFetchSupported(withKeepAlive?: boolean): boolean;
export declare function useXDomainRequest(): boolean | undefined;
/**
 * Checks if XMLHttpRequest is supported
 * @returns True if supported, otherwise false
 */
export declare function isXhrSupported(): boolean;
/**
 * Helper function to fetch the named meta-tag from the page.
 * @param name
 */
export declare function findMetaTag(name: string): any;
/**
 * Helper function to fetch the named server timing value from the page response (first navigation event).
 * @param name
 */
export declare function findNamedServerTiming(name: string): any;
export declare function dispatchEvent(target: EventTarget, evnt: Event | CustomEvent): boolean;
export declare function createCustomDomEvent(eventName: string, details?: any): CustomEvent;
export declare function sendCustomEvent(evtName: string, cfg?: any, customDetails?: any): boolean;
