#include "my_application.h"

#include <flutter_linux/flutter_linux.h>

#ifdef GDK_WINDOWING_X11
#include <gdk/gdkx.h>
#endif

#include "flutter/generated_plugin_registrant.h"

struct _MyApplication {
    GtkApplication parent_instance;
    char **dart_entrypoint_arguments;
};

G_DEFINE_TYPE(MyApplication, my_application, GTK_TYPE_APPLICATION
)

// Implements GApplication::activate.
static void my_application_activate(GApplication *application) {
  MyApplication * self = MY_APPLICATION(application);

    // >>> Required by app_links
    GList *windows = gtk_application_get_windows(GTK_APPLICATION(application));
    if (windows) {
        gtk_window_present(GTK_WINDOW(windows->data));
        return;
    }
    // <<< Required by app_links

  GtkWindow *window =
          GTK_WINDOW(gtk_application_window_new(GTK_APPLICATION(application)));

  // Copied from: https://github.com/localsend/localsend/blob/main/app/linux/my_application.cc
  // If have GTK_CSD in env and it is equal to 1 then add the gtk header bar
  // to always use client side decorations
  const char* gtk_csd = getenv("GTK_CSD");
  if (gtk_csd && strcmp(gtk_csd, "1") == 0) {
    GtkHeaderBar *header_bar = GTK_HEADER_BAR(gtk_header_bar_new());
    gtk_widget_show(GTK_WIDGET(header_bar));
    gtk_header_bar_set_title(header_bar, "dan_xi");
    gtk_header_bar_set_show_close_button(header_bar, TRUE);
    gtk_window_set_titlebar(window, GTK_WIDGET(header_bar));
  } else {
    gtk_window_set_title(window, "dan_xi");
  }

  gtk_window_set_default_size(window, 1280, 720);
  gtk_widget_show(GTK_WIDGET(window));

  g_autoptr(FlDartProject)
  project = fl_dart_project_new();
  fl_dart_project_set_dart_entrypoint_arguments(project, self->dart_entrypoint_arguments);

  FlView *view = fl_view_new(project);
  gtk_widget_show(GTK_WIDGET(view));
  gtk_container_add(GTK_CONTAINER(window), GTK_WIDGET(view));

  fl_register_plugins(FL_PLUGIN_REGISTRY(view));

  gtk_widget_grab_focus(GTK_WIDGET(view));
}

// Implements GApplication::local_command_line.
static gboolean
my_application_local_command_line(GApplication *application, gchar ***arguments, int *exit_status) {
  MyApplication * self = MY_APPLICATION(application);
  // Strip out the first argument as it is the binary name.
  self->dart_entrypoint_arguments = g_strdupv(*arguments + 1);

  g_autoptr(GError)
  error = nullptr;
  if (!g_application_register(application, nullptr, &error)) {
    g_warning("Failed to register: %s", error->message);
    *exit_status = 1;
    return TRUE;
  }

  g_application_activate(application);
  *exit_status = 0;

    // >>> Required by app_links
    return FALSE;
    // <<< Required by app_links
}

// Implements GObject::dispose.
static void my_application_dispose(GObject *object) {
  MyApplication * self = MY_APPLICATION(object);
  g_clear_pointer(&self->dart_entrypoint_arguments, g_strfreev);
  G_OBJECT_CLASS(my_application_parent_class)->dispose(object);
}

static void my_application_class_init(MyApplicationClass *klass) {
  G_APPLICATION_CLASS(klass)->activate = my_application_activate;
  G_APPLICATION_CLASS(klass)->local_command_line = my_application_local_command_line;
  G_OBJECT_CLASS(klass)->dispose = my_application_dispose;
}

static void my_application_init(MyApplication * self) {}

MyApplication *my_application_new() {
  return MY_APPLICATION(g_object_new(my_application_get_type(),
                                     "application-id", APPLICATION_ID,
          // >>> Required by app_links
                                     "flags", G_APPLICATION_HANDLES_COMMAND_LINE |
                                              G_APPLICATION_HANDLES_OPEN,
          // <<< Required by app_links
                                     nullptr));
}
