"use strict";
// Copyright 2022 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppserviceRemoveCommand = exports.AppserviceAllowCommand = void 0;
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const AppserviceBotInterfaceAdaptor_1 = require("./AppserviceBotInterfaceAdaptor");
exports.AppserviceAllowCommand = (0, interface_manager_1.describeCommand)({
    parameters: (0, interface_manager_1.tuple)({
        name: "user",
        acceptor: interface_manager_1.MatrixUserIDPresentationType,
        description: "The user that should be allowed to provision a bot",
    }),
    summary: "Allow a user to provision themselves a draupnir using the appservice.",
    async executor(context, _info, _keywords, _rest, user) {
        return await context.appservice.accessControl.allow(user.toString());
    },
});
AppserviceBotInterfaceAdaptor_1.AppserviceBotInterfaceAdaptor.describeRenderer(exports.AppserviceAllowCommand, {
    isAlwaysSupposedToUseDefaultRenderer: true,
});
exports.AppserviceRemoveCommand = (0, interface_manager_1.describeCommand)({
    parameters: (0, interface_manager_1.tuple)({
        name: "user",
        acceptor: interface_manager_1.MatrixUserIDPresentationType,
        description: "The user which shall not be allowed to provision bots anymore",
    }),
    summary: "Stop a user from using any provisioned draupnir in the appservice.",
    async executor(context, _info, _keywords, _rest, user) {
        return await context.appservice.accessControl.remove(user.toString());
    },
});
AppserviceBotInterfaceAdaptor_1.AppserviceBotInterfaceAdaptor.describeRenderer(exports.AppserviceRemoveCommand, {
    isAlwaysSupposedToUseDefaultRenderer: true,
});
//# sourceMappingURL=AccessCommands.js.map