"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractRendererMessageCollector = exports.MessageType = void 0;
var MessageType;
(function (MessageType) {
    MessageType["Document"] = "Document";
    MessageType["OneLine"] = "OneLine";
    MessageType["SingleEffectError"] = "SingleEffectError";
})(MessageType || (exports.MessageType = MessageType = {}));
/**
 * Used by capabilities to send messages to the users of Draupnir.
 */
class AbstractRendererMessageCollector {
    constructor() {
        this.messages = [];
    }
    getMessages() {
        return this.messages;
    }
    addMessage(protection, capability, message) {
        this.messages.push({
            protection,
            capability,
            message,
            type: MessageType.Document,
        });
    }
    addOneliner(protection, capability, message) {
        this.messages.push({
            protection,
            capability,
            message,
            type: MessageType.OneLine,
        });
    }
}
exports.AbstractRendererMessageCollector = AbstractRendererMessageCollector;
//# sourceMappingURL=RendererMessageCollector.js.map