"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoomTakedownCapability = void 0;
const typebox_1 = require("@sinclair/typebox");
const matrix_protection_suite_1 = require("matrix-protection-suite");
exports.RoomTakedownCapability = typebox_1.Type.Intersect([
    typebox_1.Type.Object({
        isRoomTakendown: matrix_protection_suite_1.CapabilityMethodSchema,
        takedownRoom: matrix_protection_suite_1.CapabilityMethodSchema,
    }),
    matrix_protection_suite_1.Capability,
]);
(0, matrix_protection_suite_1.describeCapabilityInterface)({
    name: "RoomTakedownCapability",
    description: "Capability that targets matrix rooms",
    schema: exports.RoomTakedownCapability,
});
//# sourceMappingURL=RoomTakedownCapability.js.map