"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from @the-draupnir-project/interface-manager
// https://github.com/the-draupnir-project/interface-manager
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardCommandInvoker = void 0;
const typescript_result_1 = require("@gnuxie/typescript-result");
const TextReader_1 = require("../TextReader");
class StandardCommandInvoker {
    constructor(callbacks) {
        this.callbacks = callbacks;
    }
    parseCommand(commandInformation, partialCommand) {
        return partialCommand.description.parametersDescription.parse(partialCommand);
    }
    async invoke(commandContext, commandInformation, command) {
        var _a, _b, _c;
        try {
            return await command.description.executor(commandContext, commandInformation, command.keywords, (_a = command.rest) !== null && _a !== void 0 ? _a : [], ...command.immediateArguments);
        }
        catch (error) {
            if (error instanceof Error) {
                (_c = (_b = this.callbacks).commandUncaughtErrorCB) === null || _c === void 0 ? void 0 : _c.call(_b, commandInformation, command
                    .toPartialCommand()
                    .stream.source.map((p) => TextReader_1.TextPresentationRenderer.render(p))
                    .join(" "), error);
                if (this.callbacks.convertUncaughtErrorToResultError) {
                    return (0, typescript_result_1.Err)(this.callbacks.convertUncaughtErrorToResultError(error));
                }
                else {
                    throw new TypeError(`Caught an error when executing a command, please use convertUncaughtErrorToResultError to handle this error and extract information from it.`);
                }
            }
            else {
                throw new TypeError(
                // I don't know what else we're going to do with it...
                // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
                `Something is throwing things that are not errors ${error})}`);
            }
        }
    }
}
exports.StandardCommandInvoker = StandardCommandInvoker;
//# sourceMappingURL=StandardCommandInvoker.js.map