import { Result } from "@gnuxie/typescript-result";
import { ParameterDescription } from "./ParameterDescription";
import { DescribeRestParameters, RestDescription } from "./RestParameterDescription";
import { DescribeKeywordParametersOptions, KeywordParametersDescription } from "./KeywordParameterDescription";
import { CompleteCommand, PartialCommand } from "./Command";
import { PresentationTypeWithoutWrap } from "./Presentation";
import { PresentationSchema } from "./PresentationSchema";
import { ObjectTypeFromAcceptor } from "./PresentationSchema";
import { KeywordsMeta } from "./CommandMeta";
export type ParameterParseFunction = (partialCommand: PartialCommand) => Result<CompleteCommand>;
export interface CommandParametersDescription<TImmediateArgumentsObjectTypes extends unknown[] = unknown[], TRestArgumentObjectType = unknown, TKeywordsMeta extends KeywordsMeta = KeywordsMeta> {
    readonly parse: ParameterParseFunction;
    readonly descriptions: {
        [I in keyof TImmediateArgumentsObjectTypes]: ParameterDescription<TImmediateArgumentsObjectTypes[I]>;
    };
    readonly rest?: RestDescription<TRestArgumentObjectType> | undefined;
    readonly keywords: KeywordParametersDescription<TKeywordsMeta>;
}
export declare class StandardCommandParametersDescription<TImmediateArgumentsObjectTypes extends unknown[] = unknown[], TRestArgumentObjectType = unknown, TKeywordsMeta extends KeywordsMeta = KeywordsMeta> implements CommandParametersDescription<TImmediateArgumentsObjectTypes, TRestArgumentObjectType, TKeywordsMeta> {
    readonly descriptions: {
        [I in keyof TImmediateArgumentsObjectTypes]: ParameterDescription<TImmediateArgumentsObjectTypes[I]>;
    };
    readonly keywords: KeywordParametersDescription<TKeywordsMeta>;
    readonly rest?: RestDescription<TRestArgumentObjectType> | undefined;
    constructor(descriptions: {
        [I in keyof TImmediateArgumentsObjectTypes]: ParameterDescription<TImmediateArgumentsObjectTypes[I]>;
    }, keywords: KeywordParametersDescription<TKeywordsMeta>, rest?: RestDescription<TRestArgumentObjectType> | undefined);
    parse(partialCommand: PartialCommand): Result<CompleteCommand>;
}
export type DescribeCommandParametersOptions<TImmediateArgumentsObjectTypes extends unknown[] = unknown[], TRestArgumentObjectType = unknown, TKeywordsMeta extends KeywordsMeta = KeywordsMeta> = {
    readonly parameters: {
        [I in keyof TImmediateArgumentsObjectTypes]: DescribeParameter<TImmediateArgumentsObjectTypes[I]>;
    };
    readonly rest?: DescribeRestParameters<TRestArgumentObjectType> | undefined;
    readonly keywords?: DescribeKeywordParametersOptions<TKeywordsMeta> | undefined;
};
export declare function describeCommandParameters<TImmediateArgumentsObjectTypes extends unknown[] = unknown[], TRestArgumentObjectType = unknown, TKeywordsMeta extends KeywordsMeta = KeywordsMeta>(options: DescribeCommandParametersOptions<TImmediateArgumentsObjectTypes, TRestArgumentObjectType, TKeywordsMeta>): CommandParametersDescription<TImmediateArgumentsObjectTypes, TRestArgumentObjectType, TKeywordsMeta>;
export type DescribeParameter<ObjectType> = Omit<ParameterDescription<ObjectType>, "acceptor"> & {
    acceptor: PresentationSchema<ObjectType> | PresentationTypeWithoutWrap<ObjectType>;
};
export type ExtractParameterObjectType<T extends DescribeParameter<never>> = ObjectTypeFromAcceptor<T["acceptor"]>;
/**
 * For some reason typescript really struggles to infer tuples.
 * So we have to use a function to guide the inference.
 * This is supposed to be used on parameter descriptions.
 */
export declare function tuple<T extends unknown[]>(...args: T): T;
//# sourceMappingURL=ParameterParsing.d.ts.map