"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _StandardGatedBackgroundTask_isFinished, _StandardGatedBackgroundTask_isCancelled;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardGatedBackgroundTask = exports.StandardTimedGate = void 0;
// Copyright (C) 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-protection-suite
// https://github.com/Gnuxie/matrix-protection-suite
// </text>
const ConstantPeriodBatch_1 = require("./ConstantPeriodBatch");
/**
 * A linear gate around a background task.
 * 1. If it's been longer than the delayMS since the task was last run,
 *   it will run the task immediately (open the gate).
 * 2. If it's been less than the delayMS since the task was last run,
 *  the task will be scheduled to run after the remaining delayMS has elapsed.
 * 3. If the task is already running, we will not run it again until it finishes,
 *   but we will enqueue a follow-up task to run immediately after the current task finishes.
 *
 * This means that there will only ever be 1 task running and one task enqueued to
 * follow up. With no chains of follow-up tasks.
 */
class StandardTimedGate {
    constructor(cb, delayMS = 0) {
        this.cb = cb;
        this.delayMS = delayMS;
        this.gateLastOpenAt = 0;
        this.batch = null;
        this.backgroundTask = null;
        // nothing to do.
    }
    enqueueOpen() {
        var _a, _b;
        // house keeping first.
        if ((_a = this.backgroundTask) === null || _a === void 0 ? void 0 : _a.isFinished()) {
            this.backgroundTask = null;
        }
        (_b = this.backgroundTask) === null || _b === void 0 ? void 0 : _b.enqueueFollowUp();
        if (this.batch !== null && !this.batch.isFinished()) {
            return;
        }
        const now = Date.now();
        const msSinceLastOpen = now - this.gateLastOpenAt;
        const remainingDelayMS = Math.max(0, this.delayMS - msSinceLastOpen);
        this.batch = new ConstantPeriodBatch_1.ConstantPeriodBatch(() => {
            this.gateLastOpenAt = Date.now();
            this.backgroundTask = new StandardGatedBackgroundTask(this.cb, this);
        }, remainingDelayMS);
    }
    destroy() {
        var _a, _b;
        (_a = this.batch) === null || _a === void 0 ? void 0 : _a.cancel();
        (_b = this.backgroundTask) === null || _b === void 0 ? void 0 : _b.cancel();
    }
}
exports.StandardTimedGate = StandardTimedGate;
class StandardGatedBackgroundTask {
    constructor(taskFactory, parentGate) {
        _StandardGatedBackgroundTask_isFinished.set(this, false);
        _StandardGatedBackgroundTask_isCancelled.set(this, false);
        this.enqueueCalledWhileTaskActive = false;
        void taskFactory(this).finally(() => {
            __classPrivateFieldSet(this, _StandardGatedBackgroundTask_isFinished, true, "f");
            if (this.enqueueCalledWhileTaskActive) {
                parentGate.enqueueOpen();
            }
        });
    }
    isFinished() {
        return __classPrivateFieldGet(this, _StandardGatedBackgroundTask_isFinished, "f");
    }
    isCancelled() {
        return __classPrivateFieldGet(this, _StandardGatedBackgroundTask_isCancelled, "f");
    }
    enqueueFollowUp() {
        if (!__classPrivateFieldGet(this, _StandardGatedBackgroundTask_isCancelled, "f")) {
            this.enqueueCalledWhileTaskActive = true;
        }
    }
    cancel() {
        __classPrivateFieldSet(this, _StandardGatedBackgroundTask_isCancelled, true, "f");
        this.enqueueCalledWhileTaskActive = false;
    }
}
exports.StandardGatedBackgroundTask = StandardGatedBackgroundTask;
_StandardGatedBackgroundTask_isFinished = new WeakMap(), _StandardGatedBackgroundTask_isCancelled = new WeakMap();
//# sourceMappingURL=TimedGate.js.map