import { Evaluate, StaticDecode, TObject } from '@sinclair/typebox';
import { ConfigDescription } from './ConfigDescription';
import { EDStatic } from '../Interface/Static';
import { ConfigPropertyError } from './ConfigParseError';
import { Result } from '@gnuxie/typescript-result';
export interface ConfigMirror<TConfigSchema extends TObject = TObject> {
    readonly description: ConfigDescription<TConfigSchema>;
    setValue<TKey extends string>(config: EDStatic<TConfigSchema>, key: TKey, value: unknown): Result<EDStatic<TConfigSchema>, ConfigPropertyError>;
    setSerializedValue<TKey extends string>(config: EDStatic<TConfigSchema>, key: TKey, value: string): Result<EDStatic<TConfigSchema>, ConfigPropertyError>;
    addItem<TKey extends string>(config: EDStatic<TConfigSchema>, key: TKey, value: unknown): Result<EDStatic<TConfigSchema>, ConfigPropertyError>;
    addSerializedItem<TKey extends string>(config: EDStatic<TConfigSchema>, key: TKey, value: string): Result<EDStatic<TConfigSchema>, ConfigPropertyError>;
    removeProperty<TKey extends string>(key: TKey, config: Record<TKey, unknown>): Record<TKey, unknown>;
    removeItem<TKey extends string>(config: Record<TKey, unknown[]>, key: TKey, index: number): Record<TKey, unknown[]>;
    filterItems<TKey extends string>(config: Record<TKey, unknown[]>, key: TKey, callbackFn: Parameters<Array<unknown>['filter']>[0]): Record<TKey, unknown[]>;
}
export declare class StandardConfigMirror<TConfigSchema extends TObject> implements ConfigMirror<TConfigSchema> {
    readonly description: ConfigDescription<TConfigSchema>;
    constructor(description: ConfigDescription<TConfigSchema>);
    setValue(config: Evaluate<StaticDecode<TConfigSchema>>, key: string, value: unknown): Result<Evaluate<StaticDecode<TConfigSchema>>, ConfigPropertyError>;
    private addUnparsedItem;
    addItem(config: Evaluate<StaticDecode<TConfigSchema>>, key: string, value: unknown): Result<Evaluate<StaticDecode<TConfigSchema>>, ConfigPropertyError>;
    addSerializedItem<TKey extends string>(config: EDStatic<TConfigSchema>, key: TKey, value: string): Result<EDStatic<TConfigSchema>, ConfigPropertyError>;
    setSerializedValue<TKey extends string>(config: EDStatic<TConfigSchema>, key: TKey, value: string): Result<EDStatic<TConfigSchema>, ConfigPropertyError>;
    removeProperty<TKey extends string>(key: TKey, config: Record<TKey, unknown>): Record<string, unknown>;
    removeItem<TKey extends string>(config: Record<TKey, unknown[]>, key: TKey, index: number): Record<TKey, unknown[]>;
    filterItems<TKey extends string>(config: Record<TKey, unknown[]>, key: TKey, callbackFn: Parameters<Array<unknown>['filter']>[0]): Record<TKey, unknown[]>;
}
//# sourceMappingURL=ConfigMirror.d.ts.map