import { TSchema, StaticDecode, Static, StaticEncode } from '@sinclair/typebox';
import { TypeCheck, ValueError, ValueErrorIterator } from '@sinclair/typebox/compiler';
import { ActionResult } from './Action';
import { ActionException } from './ActionException';
export declare class DecodeException extends ActionException {
    readonly errors: ValueError[];
    private static log;
    constructor(message: string, exception: unknown, errors: ValueError[], suppressLog?: boolean);
}
export declare class Value {
    private static compiledSchema;
    static Compile<T extends TSchema>(schema: T): TypeCheck<T>;
    static Decode<T extends TSchema, D = StaticDecode<T>>(schema: T, value: unknown, { suppressLogOnError }?: {
        suppressLogOnError?: boolean;
    }): ActionResult<D, DecodeException>;
    static Check<T extends TSchema>(schema: T, value: unknown): value is Static<T>;
    static Encode<T extends TSchema>(schema: T, value: StaticDecode<T>): ActionResult<StaticEncode<T>>;
    static Errors<T extends TSchema>(schema: T, value: unknown): ValueErrorIterator;
    private static resultify;
}
//# sourceMappingURL=Value.d.ts.map