import EventEmitter from 'events';
import { ActionResult } from '../Interface/Action';
import { RoomMembershipRevision } from './MembershipRevision';
import { SetRoomMembership, SetRoomMembershipMirrorCord } from './SetRoomMembership';
import { RoomMembershipRevisionIssuer } from './MembershipRevisionIssuer';
import { RoomMembershipManager } from './RoomMembershipManager';
import { StringRoomID, MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
export declare class StandardSetRoomMembership extends EventEmitter implements SetRoomMembership {
    private readonly issuers;
    private readonly revisionListener;
    private constructor();
    getRevision(room: StringRoomID): RoomMembershipRevision | undefined;
    static create(roomMembershipManager: RoomMembershipManager, roomsSet: MatrixRoomID[]): Promise<ActionResult<SetRoomMembership>>;
    static blankSet(): StandardSetRoomMembership;
    [SetRoomMembershipMirrorCord.addRoom](room: MatrixRoomID, issuer: RoomMembershipRevisionIssuer): void;
    [SetRoomMembershipMirrorCord.removeRoom](room: MatrixRoomID): void;
    unregisterListeners(): void;
    get allRooms(): RoomMembershipRevision[];
    private membershipRevision;
}
//# sourceMappingURL=StandardSetRoomMembership.d.ts.map