/**
 * Represents a specific version of the state contained in `PolicyListRevision`.
 * These are unique and can be compared with `supersedes`.
 * We use a ULID to work out whether a revision supersedes another.
 * @see {@link PolicyListRevision}.
 */
export declare class Revision {
    /**
     * Ensures that ULIDs are monotonic.
     */
    private static makeULID;
    /**
     * Is only public for the comparison method,
     * I feel like I'm missing something here and it is possible without
     */
    readonly ulid: string;
    /**
     * Check whether this revision supersedes another revision.
     * @param revision The revision we want to check this supersedes.
     * @returns True if this Revision supersedes the other revision.
     */
    supersedes(revision: Revision): boolean;
    /**
     * The time that the revision was created in milliseconds.
     */
    get time(): number;
}
//# sourceMappingURL=Revision.d.ts.map