import { StringUserID } from '@the-draupnir-project/matrix-basic-types';
import { PolicyRuleType } from '../MatrixTypes/PolicyEvents';
import { ServerACLBuilder } from '../MatrixTypes/ServerACLBuilder';
import { PolicyListRevision } from '../PolicyList/PolicyListRevision';
import { PolicyRule } from '../PolicyList/PolicyRule';
export declare enum Access {
    Banned = 0,
    NotAllowed = 1,
    Allowed = 2
}
/**
 * A description of the access an entity has.
 * If the access is `Banned`, then a single rule that bans the entity will be included.
 */
export interface EntityAccess {
    readonly outcome: Access;
    readonly rule?: PolicyRule;
}
/**
 * This allows us to work out the access an entity has to some thing based on a set of watched/unwatched lists.
 */
export declare class AccessControl {
    /**
     * Test whether the server is allowed by the ACL unit.
     * @param domain The server name to test.
     * @returns A description of the access that the server has.
     */
    static getAccessForServer(revision: PolicyListRevision, domain: string): EntityAccess;
    /**
     * Get the level of access the user has for the ACL unit.
     * @param mxid The user id to test.
     * @param policy Whether to check the server part of the user id against server rules.
     * @returns A description of the access that the user has.
     */
    static getAccessForUser(revision: PolicyListRevision, userID: StringUserID, policy: 'CHECK_SERVER' | 'IGNORE_SERVER'): EntityAccess;
    static getAccessForEntity(revision: PolicyListRevision, entity: string, entityType: PolicyRuleType): EntityAccess;
    /**
     * Create a ServerAcl instance from the rules contained in this unit.
     * @param serverName The name of the server that you are operating from, used to ensure you cannot brick yourself.
     * @returns A new `ServerAcl` instance with deny and allow entries created from the rules in this unit.
     */
    static compileServerACL(serverName: string, revision: PolicyListRevision): ServerACLBuilder;
}
//# sourceMappingURL=AccessControl.d.ts.map