"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserConsequences = void 0;
exports.targetReason = targetReason;
// Copyright 2023 - 2024 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2022 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
const typebox_1 = require("@sinclair/typebox");
const CapabilityInterface_1 = require("../CapabilityInterface");
const CapabilityMethodSchema_1 = require("./CapabilityMethodSchema");
const CapabilityProvider_1 = require("../CapabilityProvider");
function targetReason(member) {
    var _a;
    if ('reason' in member) {
        return member.reason;
    }
    else {
        const reasonPolicy = member.policies.at(0);
        if (reasonPolicy === undefined) {
            throw new TypeError(`Some protection isn't providing matches properly`);
        }
        return (_a = reasonPolicy.reason) !== null && _a !== void 0 ? _a : '<no reason provided>';
    }
}
exports.UserConsequences = typebox_1.Type.Intersect([
    typebox_1.Type.Object({
        consequenceForUserInRoom: CapabilityMethodSchema_1.CapabilityMethodSchema,
        consequenceForUsersInRoomSet: CapabilityMethodSchema_1.CapabilityMethodSchema,
        consequenceForUsersInRoom: CapabilityMethodSchema_1.CapabilityMethodSchema,
        unbanUserFromRoomSet: CapabilityMethodSchema_1.CapabilityMethodSchema,
    }),
    CapabilityProvider_1.Capability,
]);
(0, CapabilityInterface_1.describeCapabilityInterface)({
    name: 'UserConsequences',
    description: 'Capabilities for taking consequences against a user',
    schema: exports.UserConsequences,
});
//# sourceMappingURL=UserConsequences.js.map