import { Revision } from '../PolicyList/Revision';
import { Map as PersistentMap } from 'immutable';
import { StateEvent } from '../MatrixTypes/Events';
import { RoomStateRevision, StateChange } from './StateRevisionIssuer';
import { MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
/**
 * A map interning rules by their rule type, and then their state key.
 */
type StateEventMap = PersistentMap<string, PersistentMap<string, StateEvent>>;
/**
 * A map interning rules by their event id.
 */
type StateEventByEventIDMap = PersistentMap<string, StateEvent>;
/**
 * A standard implementation of a `PolicyListRevision` using immutable's persistent maps.
 */
export declare class StandardRoomStateRevision implements RoomStateRevision {
    readonly room: MatrixRoomID;
    readonly revisionID: Revision;
    /**
     * A map of state events indexed first by state type and then state keys.
     */
    private readonly stateEvents;
    /**
     * Allow us to detect whether we have updated the state for this event.
     */
    private readonly stateEventsByEventID;
    /**
     * Use {@link StandardRoomStateRevision.blankRevision} to get started.
     * Only use this constructor if you are implementing a variant of PolicyListRevision.
     * @param revisionID A revision ID to represent this revision.
     * @param policyRules A map containing the rules for this revision by state type and then state key.
     * @param policyRuleByEventId A map containing the rules ofr this revision by event id.
     */
    constructor(room: MatrixRoomID, revisionID: Revision, 
    /**
     * A map of state events indexed first by state type and then state keys.
     */
    stateEvents: StateEventMap, 
    /**
     * Allow us to detect whether we have updated the state for this event.
     */
    stateEventsByEventID: StateEventByEventIDMap);
    /**
     * @returns An empty revision.
     */
    static blankRevision(room: MatrixRoomID): StandardRoomStateRevision;
    isBlankRevision(): boolean;
    get allState(): {
        type: string;
        content: {};
        unsigned?: {
            age?: number;
            redacted_because?: unknown;
            transaction_id?: string;
            prev_content?: unknown;
        };
        event_id: import("@the-draupnir-project/matrix-basic-types").StringEventID;
        sender: import("@the-draupnir-project/matrix-basic-types").StringUserID;
        origin_server_ts: number;
        room_id: import("@the-draupnir-project/matrix-basic-types").StringRoomID;
        state_key: string;
    }[];
    getStateEvent<T extends StateEvent>(type: string, key: string): T | undefined;
    getStateEventsOfType<T extends StateEvent>(type: string): T[];
    getStateEventsOfTypes<T extends StateEvent>(types: string[]): T[];
    reviseFromChanges(changes: StateChange[]): StandardRoomStateRevision;
    hasEvent(eventId: string): boolean;
    /**
     * Calculate the changes from this revision with a more recent set of state events.
     * Will only show the difference, if the set is the same then no changes will be returned.
     * @param state The state events that reflect a different revision of the list.
     * @returns Any changes between this revision and the new set of state events.
     */
    changesFromState(state: StateEvent[]): StateChange[];
    reviseFromState(state: StateEvent[]): RoomStateRevision;
}
export {};
//# sourceMappingURL=StandardRoomStateRevision.d.ts.map