import type * as ts from 'typescript';
type ImportDeclaration = ts.ImportEqualsDeclaration | ts.ImportOrExportSpecifier | ts.ImportClause;
export declare namespace TypescriptHelper {
    function IsLiteralOrPrimitive(typeNode: ts.Node): boolean;
    function GetDeclarationFromNode(node: ts.Node): ts.Declaration;
    function GetDeclarationFromSymbol(symbol: ts.Symbol): ts.Declaration;
    function GetConcreteDeclarationFromSymbol(symbol: ts.Symbol): ts.Declaration;
    function GetDeclarationForImport(node: ImportDeclaration): ts.Declaration;
    function GetConcreteDeclarationForImport(node: ImportDeclaration): ts.Declaration;
    function GetParameterOfNode(node: ts.EntityName): ts.NodeArray<ts.TypeParameterDeclaration>;
    function GetTypeParameterOwnerMock(declaration: ts.Declaration): ts.Declaration | undefined;
    function GetStringPropertyName(propertyName: ts.PropertyName): string;
    function GetAliasedSymbolSafe(alias: ts.Symbol): ts.Symbol;
    function getSignatureOfCallExpression(node: ts.CallExpression): ts.Signature | undefined;
    function hasTypeArguments(node: ts.CallExpression): boolean;
}
export {};
