"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeSafeModeCommandDispatcher = makeSafeModeCommandDispatcher;
exports.makeSafeModeJSDispatcher = makeSafeModeJSDispatcher;
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
const SafeModeCommands_1 = require("./commands/SafeModeCommands");
const HelpCommand_1 = require("./commands/HelpCommand");
const SafeModeAdaptor_1 = require("./commands/SafeModeAdaptor");
const DraupnirCommandDispatcher_1 = require("../commands/DraupnirCommandDispatcher");
function makeSafeModeCommandDispatcher(safeModeDraupnir) {
    return new interface_manager_1.StandardMatrixInterfaceCommandDispatcher(SafeModeAdaptor_1.SafeModeInterfaceAdaptor, safeModeDraupnir, SafeModeCommands_1.SafeModeCommands, HelpCommand_1.SafeModeHelpCommand, mps_interface_adaptor_1.invocationInformationFromMatrixEventcontext, {
        ...mps_interface_adaptor_1.MPSCommandDispatcherCallbacks,
        commandNormaliser: (0, DraupnirCommandDispatcher_1.makeDraupnirCommandNormaliser)(safeModeDraupnir.clientUserID, safeModeDraupnir, safeModeDraupnir.config),
    });
}
function makeSafeModeJSDispatcher(safeModeDraupnir) {
    return new interface_manager_1.StandardJSInterfaceCommandDispatcher(SafeModeCommands_1.SafeModeCommands, HelpCommand_1.SafeModeHelpCommand, safeModeDraupnir, {
        ...mps_interface_adaptor_1.MPSCommandDispatcherCallbacks,
        commandNormaliser: (0, DraupnirCommandDispatcher_1.makeDraupnirCommandNormaliser)(safeModeDraupnir.clientUserID, safeModeDraupnir, safeModeDraupnir.config),
    }, SafeModeAdaptor_1.SafeModeContextToCommandContextTranslator);
}
//# sourceMappingURL=SafeModeCommandDispatcher.js.map