"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from Draupnir
// https://github.com/the-draupnir-project/Draupnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeAppserviceBotCommandDispatcher = makeAppserviceBotCommandDispatcher;
exports.makeAppserviceJSCommandDispatcher = makeAppserviceJSCommandDispatcher;
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const AppserviceBotCommandTable_1 = require("./AppserviceBotCommandTable");
const AppserviceBotHelp_1 = require("./AppserviceBotHelp");
const AppserviceBotInterfaceAdaptor_1 = require("./AppserviceBotInterfaceAdaptor");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
function makeAppserviceCommandNormaliser(appserviceContext) {
    return (0, interface_manager_1.makeCommandNormaliser)(appserviceContext.clientUserID, {
        symbolPrefixes: ["!"],
        isAllowedOnlySymbolPrefixes: false,
        additionalPrefixes: ["admin"],
        getDisplayName: function () {
            // TODO: I don't nkow how we're going to do this yet but we'll
            // figure it out one day.
            return "admin";
        },
        normalisedPrefix: "admin",
    });
}
function makeAppserviceBotCommandDispatcher(appserviceContext) {
    return new interface_manager_1.StandardMatrixInterfaceCommandDispatcher(AppserviceBotInterfaceAdaptor_1.AppserviceBotInterfaceAdaptor, appserviceContext, AppserviceBotCommandTable_1.AppserviceBotCommands, AppserviceBotHelp_1.AppserviceBotHelpCommand, mps_interface_adaptor_1.invocationInformationFromMatrixEventcontext, {
        ...mps_interface_adaptor_1.MPSCommandDispatcherCallbacks,
        commandNormaliser: makeAppserviceCommandNormaliser(appserviceContext),
    });
}
function makeAppserviceJSCommandDispatcher(appserviceContext) {
    return new interface_manager_1.StandardJSInterfaceCommandDispatcher(AppserviceBotCommandTable_1.AppserviceBotCommands, AppserviceBotHelp_1.AppserviceBotHelpCommand, appserviceContext, {
        ...mps_interface_adaptor_1.MPSCommandDispatcherCallbacks,
        commandNormaliser: makeAppserviceCommandNormaliser(appserviceContext),
    }, AppserviceBotInterfaceAdaptor_1.AppserviceAdaptorContextToCommandContextTranslator);
}
//# sourceMappingURL=AppserviceBotCommandDispatcher.js.map