"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.DraupnirRendererMessageCollector = void 0;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
class DraupnirRendererMessageCollector {
    constructor(roomMessageSender, managementRoomID) {
        this.roomMessageSender = roomMessageSender;
        this.managementRoomID = managementRoomID;
        // nothing to do.
    }
    sendMessage(capability, document) {
        void (0, matrix_protection_suite_1.Task)((0, mps_interface_adaptor_1.sendMatrixEventsFromDeadDocument)(this.roomMessageSender, this.managementRoomID, interface_manager_1.DeadDocumentJSX.JSXFactory("root", null,
            capability.isSimulated ? (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null, "\u26A0\uFE0F (preview) ")) : (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null)),
            document), {}));
    }
    addMessage(protection, capability, message) {
        this.sendMessage(capability, message);
    }
    addOneliner(protection, capability, message) {
        this.sendMessage(capability, interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null,
            interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, protection.name),
            ": ",
            message));
    }
    getMessages() {
        return [];
    }
}
exports.DraupnirRendererMessageCollector = DraupnirRendererMessageCollector;
//# sourceMappingURL=DraupnirRendererMessageCollector.js.map