"use strict";
// Copyright 2022 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2020 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.DraupnirResolveAliasCommand = void 0;
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const typescript_result_1 = require("@gnuxie/typescript-result");
const DraupnirCommandPrerequisites_1 = require("./DraupnirCommandPrerequisites");
exports.DraupnirResolveAliasCommand = (0, interface_manager_1.describeCommand)({
    summary: "Resolve a room alias.",
    parameters: (0, interface_manager_1.tuple)({
        name: "alias",
        acceptor: interface_manager_1.MatrixRoomAliasPresentationType,
    }),
    async executor({ clientPlatform }, _info, _keywords, _rest, alias) {
        return await clientPlatform.toRoomResolver().resolveRoom(alias);
    },
});
DraupnirCommandPrerequisites_1.DraupnirInterfaceAdaptor.describeRenderer(exports.DraupnirResolveAliasCommand, {
    JSXRenderer(result) {
        if ((0, typescript_result_1.isError)(result)) {
            return (0, typescript_result_1.Ok)(undefined);
        }
        else {
            return (0, typescript_result_1.Ok)(interface_manager_1.DeadDocumentJSX.JSXFactory("root", null,
                interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, result.ok.toRoomIDOrAlias()),
                " -",
                " ",
                (0, mps_interface_adaptor_1.renderRoomPill)(result.ok)));
        }
    },
});
//# sourceMappingURL=ResolveAlias.js.map