import { Presentation } from "./Presentation";
import { StandardPresentationArgumentStream } from "./PresentationStream";
export interface PromptOptions<ObjectType = unknown> {
    readonly suggestions: Presentation<ObjectType>[];
    readonly default?: Presentation<ObjectType>;
}
export interface RestPromptOptions<ObjectType = unknown> {
    readonly suggestions: Presentation<ObjectType>[][];
    readonly default?: Presentation<ObjectType>[];
}
/**
 * The idea is that the InterfaceAcceptor can use the presentation type
 * to derive the prompt, or use the prompt given by the ParameterDescription.
 */
export interface InterfaceAcceptor {
    readonly isPromptable: boolean;
}
export declare class PromptableArgumentStream extends StandardPresentationArgumentStream {
    private readonly interfaceAcceptor;
    constructor(source: Presentation[], interfaceAcceptor: InterfaceAcceptor, start?: number);
    rest(): Presentation<unknown>[];
    isPromptable(): boolean;
}
//# sourceMappingURL=PromptForAccept.d.ts.map