"use strict";
// Copyright 2023 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.HTML_RENDERER = void 0;
const DeadDocument_1 = require("./DeadDocument");
const DeadDocumentMarkdown_1 = require("./DeadDocumentMarkdown");
const escapeHTML_1 = require("./escapeHTML");
function writeAttributableNode(tagName, _fringe, node, context, _environment) {
    context.output.writeString(`<${tagName}`);
    if (node.attributeMap.size > 0) {
        for (const [key, value] of node.attributeMap.entries()) {
            context.output.writeString(` ${(0, escapeHTML_1.escapeHTML)(key)}="${(0, escapeHTML_1.escapeHTML)(value)}"`);
        }
    }
    context.output.writeString(">");
}
function attributableNode(tagName) {
    return function (fringe, node, context, environment) {
        writeAttributableNode(tagName, fringe, node, context, environment);
    };
}
exports.HTML_RENDERER = new DeadDocument_1.SimpleFringeRenderer();
exports.HTML_RENDERER.registerRenderer(DeadDocument_1.FringeType.Leaf, DeadDocument_1.NodeTag.TextNode, function (_tag, node, context) {
    context.output.writeString((0, escapeHTML_1.escapeHTML)(node.data));
})
    .registerInnerNode(DeadDocument_1.NodeTag.Emphasis, (0, DeadDocumentMarkdown_1.staticString)("<em>"), (0, DeadDocumentMarkdown_1.staticString)("</em>"))
    .registerInnerNode(DeadDocument_1.NodeTag.HeadingOne, (0, DeadDocumentMarkdown_1.staticString)("<h1>"), (0, DeadDocumentMarkdown_1.staticString)("</h1>"))
    .registerInnerNode(DeadDocument_1.NodeTag.HeadingTwo, (0, DeadDocumentMarkdown_1.staticString)("<h2>"), (0, DeadDocumentMarkdown_1.staticString)("</h2>"))
    .registerInnerNode(DeadDocument_1.NodeTag.HeadingThree, (0, DeadDocumentMarkdown_1.staticString)("<h3>"), (0, DeadDocumentMarkdown_1.staticString)("</h3>"))
    .registerInnerNode(DeadDocument_1.NodeTag.HeadingFour, (0, DeadDocumentMarkdown_1.staticString)("<h4>"), (0, DeadDocumentMarkdown_1.staticString)("</h4>"))
    .registerInnerNode(DeadDocument_1.NodeTag.HeadingFive, (0, DeadDocumentMarkdown_1.staticString)("<h5>"), (0, DeadDocumentMarkdown_1.staticString)("</h5>"))
    .registerInnerNode(DeadDocument_1.NodeTag.HeadingSix, (0, DeadDocumentMarkdown_1.staticString)("<h6>"), (0, DeadDocumentMarkdown_1.staticString)("</h6>"))
    .registerInnerNode(DeadDocument_1.NodeTag.HorizontalRule, DeadDocumentMarkdown_1.blank, (0, DeadDocumentMarkdown_1.staticString)("<hr/>"))
    .registerInnerNode(DeadDocument_1.NodeTag.InlineCode, (0, DeadDocumentMarkdown_1.staticString)("<code>"), (0, DeadDocumentMarkdown_1.staticString)("</code>"))
    .registerInnerNode(DeadDocument_1.NodeTag.Paragraph, (0, DeadDocumentMarkdown_1.staticString)("<p>"), (0, DeadDocumentMarkdown_1.staticString)("</p>"))
    .registerInnerNode(DeadDocument_1.NodeTag.PreformattedText, (0, DeadDocumentMarkdown_1.staticString)("<pre>"), (0, DeadDocumentMarkdown_1.staticString)("</pre>"))
    .registerInnerNode(DeadDocument_1.NodeTag.Strong, (0, DeadDocumentMarkdown_1.staticString)("<strong>"), (0, DeadDocumentMarkdown_1.staticString)("</strong>"))
    .registerInnerNode(DeadDocument_1.NodeTag.UnorderedList, (0, DeadDocumentMarkdown_1.staticString)("<ul>"), (0, DeadDocumentMarkdown_1.staticString)("</ul>"))
    .registerInnerNode(DeadDocument_1.NodeTag.OrderedList, (0, DeadDocumentMarkdown_1.staticString)("<ol>"), (0, DeadDocumentMarkdown_1.staticString)("</ol>"))
    .registerInnerNode(DeadDocument_1.NodeTag.ListItem, (0, DeadDocumentMarkdown_1.staticString)("<li>"), (0, DeadDocumentMarkdown_1.staticString)("</li>"))
    .registerInnerNode(DeadDocument_1.NodeTag.LineBreak, DeadDocumentMarkdown_1.blank, (0, DeadDocumentMarkdown_1.staticString)("<br/>"))
    .registerInnerNode(DeadDocument_1.NodeTag.BoldFace, (0, DeadDocumentMarkdown_1.staticString)("<b>"), (0, DeadDocumentMarkdown_1.staticString)("</b>"))
    .registerInnerNode(DeadDocument_1.NodeTag.ItalicFace, (0, DeadDocumentMarkdown_1.staticString)("<i>"), (0, DeadDocumentMarkdown_1.staticString)("</i>"))
    .registerInnerNode(DeadDocument_1.NodeTag.Anchor, attributableNode("a"), (0, DeadDocumentMarkdown_1.staticString)("</a>"))
    .registerInnerNode(DeadDocument_1.NodeTag.Font, attributableNode("font"), (0, DeadDocumentMarkdown_1.staticString)("</font>"))
    .registerInnerNode(DeadDocument_1.NodeTag.Root, DeadDocumentMarkdown_1.blank, DeadDocumentMarkdown_1.blank)
    .registerInnerNode(DeadDocument_1.NodeTag.Details, (0, DeadDocumentMarkdown_1.staticString)("<details>"), (0, DeadDocumentMarkdown_1.staticString)("</details>"))
    .registerInnerNode(DeadDocument_1.NodeTag.Summary, (0, DeadDocumentMarkdown_1.staticString)("<summary>"), (0, DeadDocumentMarkdown_1.staticString)("</summary>"))
    .registerInnerNode(DeadDocument_1.NodeTag.Span, attributableNode("span"), (0, DeadDocumentMarkdown_1.staticString)("</span>"));
//# sourceMappingURL=DeadDocumentHTML.js.map