"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from @the-draupnir-project/interface-manager
// https://github.com/the-draupnir-project/interface-manager
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderConfirmationPrompt = renderConfirmationPrompt;
const typescript_result_1 = require("@gnuxie/typescript-result");
const DeadDocument_1 = require("../DeadDocument");
function renderConfirmationPrompt(result) {
    if ((0, typescript_result_1.isError)(result)) {
        return (0, typescript_result_1.Ok)(undefined);
    }
    return (0, typescript_result_1.Ok)(DeadDocument_1.DeadDocumentJSX.JSXFactory("root", null,
        DeadDocument_1.DeadDocumentJSX.JSXFactory("h4", null, "This command requires confirmation"),
        DeadDocument_1.DeadDocumentJSX.JSXFactory("p", null, "Please consider the consequences of this command, do you wish to proceed?")));
}
//# sourceMappingURL=DefaultRenderers.js.map