"use strict";
// Copyright 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from @the-draupnir-project/interface-manager
// https://github.com/the-draupnir-project/interface-manager
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextPresentationRenderer = void 0;
const TEXT_PRESENTATION_RENDERERS = new Map();
exports.TextPresentationRenderer = Object.freeze({
    registerPresentationRenderer(type, renderFunction) {
        if (TEXT_PRESENTATION_RENDERERS.has(type)) {
            throw new TypeError(`There is already a text renderer registered for the presentation type ${type.name}`);
        }
        TEXT_PRESENTATION_RENDERERS.set(type, renderFunction);
        return this;
    },
    findPresentationRenderer(type) {
        return TEXT_PRESENTATION_RENDERERS.get(type);
    },
    render(presentation) {
        const renderer = this.findPresentationRenderer(presentation.presentationType);
        if (renderer === undefined) {
            throw new TypeError(`Render is being called for the presentation type ${presentation.presentationType.name} but no renderer has been registered for this type`);
        }
        return renderer(presentation);
    },
});
//# sourceMappingURL=TextPresentationRenderer.js.map