"use strict";
// Copyright 2023 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from Draupnir
// https://github.com/the-draupnir-project/Draupnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.ARGUMENT_PROMPT_LISTENER = exports.DEFAUILT_ARGUMENT_PROMPT_LISTENER = exports.CommandPromptContext = void 0;
exports.continueCommandAcceptingPrompt = continueCommandAcceptingPrompt;
exports.makeListenerForPromptDefault = makeListenerForPromptDefault;
exports.makeListenerForArgumentPrompt = makeListenerForArgumentPrompt;
exports.promptDefault = promptDefault;
exports.promptSuggestions = promptSuggestions;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const MatrixReactionHandler_1 = require("./MatrixReactionHandler");
const typebox_1 = require("@sinclair/typebox");
const MPSMatrixInterfaceAdaptor_1 = require("./MPSMatrixInterfaceAdaptor");
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const typescript_result_1 = require("@gnuxie/typescript-result");
const log = new matrix_protection_suite_1.Logger("MatrixPromptForAccept");
exports.CommandPromptContext = typebox_1.Type.Object({
    command_designator: typebox_1.Type.Array(typebox_1.Type.String()),
    read_items: typebox_1.Type.Array(typebox_1.Type.String()),
});
const DefaultPromptContext = typebox_1.Type.Composite([
    exports.CommandPromptContext,
    typebox_1.Type.Object({
        default: typebox_1.Type.String(),
    }),
]);
function continueCommandAcceptingPrompt(eventContext, promptContext, serializedPrompt, commandDispatcher, reactionHandler) {
    const stream = new interface_manager_1.StandardPresentationArgumentStream((0, interface_manager_1.readCommand)([
        ...promptContext.command_designator,
        ...promptContext.read_items,
        serializedPrompt,
    ].join(" ")));
    commandDispatcher.handleCommandFromPresentationStream(eventContext, stream);
    void (0, matrix_protection_suite_1.Task)(reactionHandler.completePrompt(eventContext.roomID, eventContext.event.event_id));
}
exports.DEFAUILT_ARGUMENT_PROMPT_LISTENER = "ge.applied-langua.ge.draupnir.default_argument_prompt";
function makeListenerForPromptDefault(commandRoomID, commandDispatcher, reactionHandler) {
    return function (reactionKey, item, context, reactionMap, annotatedEvent) {
        if (annotatedEvent.room_id !== commandRoomID) {
            return;
        }
        if (item !== "ok") {
            return;
        }
        const promptContext = matrix_protection_suite_1.Value.Decode(DefaultPromptContext, context);
        if ((0, matrix_protection_suite_1.isError)(promptContext)) {
            log.error(`malformed event context when trying to accept a default prompt`, context);
            return;
        }
        continueCommandAcceptingPrompt({ event: annotatedEvent, roomID: annotatedEvent.room_id }, promptContext.ok, item, commandDispatcher, reactionHandler);
    };
}
exports.ARGUMENT_PROMPT_LISTENER = "ge.applied-langua.ge.draupnir.argument_prompt";
function makeListenerForArgumentPrompt(commandRoomID, commandDispatcher, reactionHandler) {
    return function (reactionKey, item, context, reactionMap, annotatedEvent) {
        if (annotatedEvent.room_id !== commandRoomID) {
            return;
        }
        const promptContext = matrix_protection_suite_1.Value.Decode(exports.CommandPromptContext, context);
        if ((0, matrix_protection_suite_1.isError)(promptContext)) {
            log.error(`malformed event context when trying to accept a prompted argument`, context);
            return;
        }
        continueCommandAcceptingPrompt({ event: annotatedEvent, roomID: annotatedEvent.room_id }, promptContext.ok, item, commandDispatcher, reactionHandler);
    };
}
async function promptDefault({ clientPlatform, reactionHandler }, eventContext, parameter, command, defaultPrompt, existingArguments) {
    const reactionMap = new Map(Object.entries({
        Ok: "ok",
    }));
    const sendResult = await (0, MPSMatrixInterfaceAdaptor_1.sendMatrixEventsFromDeadDocument)(clientPlatform.toRoomMessageSender(), eventContext.event.room_id, interface_manager_1.DeadDocumentJSX.JSXFactory("root", null,
        "No argument was provided for the parameter ",
        parameter.name,
        ", would you like to accept the default?",
        interface_manager_1.DeadDocumentJSX.JSXFactory("br", null),
        interface_manager_1.TextPresentationRenderer.render(defaultPrompt)), {
        replyToEvent: eventContext.event,
        additionalContent: reactionHandler.createAnnotation(exports.DEFAUILT_ARGUMENT_PROMPT_LISTENER, reactionMap, {
            command_designator: command.designator,
            read_items: existingArguments.map((p) => interface_manager_1.TextPresentationRenderer.render(p)),
            default: interface_manager_1.TextPresentationRenderer.render(defaultPrompt),
        }),
    });
    if ((0, matrix_protection_suite_1.isError)(sendResult)) {
        return sendResult;
    }
    if (sendResult.ok[0] === undefined) {
        throw new TypeError(`Something is really wrong with the code`);
    }
    await reactionHandler.addReactionsToEvent(eventContext.event.room_id, sendResult.ok[0], reactionMap);
    return (0, typescript_result_1.Ok)(undefined);
}
// FIXME: <ol> raw tags will not work if the message is sent across events.
// If there isn't a start attribute for `ol` then we'll need to take this into our own hands.
async function promptSuggestions({ clientPlatform, reactionHandler }, eventContext, parameter, command, suggestions, existingArguments) {
    const reactionMap = MatrixReactionHandler_1.MatrixReactionHandler.createItemizedReactionMap(suggestions.map((suggestion) => interface_manager_1.TextPresentationRenderer.render(suggestion)));
    const sendResult = await (0, MPSMatrixInterfaceAdaptor_1.sendMatrixEventsFromDeadDocument)(clientPlatform.toRoomMessageSender(), eventContext.event.room_id, interface_manager_1.DeadDocumentJSX.JSXFactory("root", null,
        "Please select one of the following options to provide as an argument for the parameter ",
        interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, parameter.name),
        ":",
        interface_manager_1.DeadDocumentJSX.JSXFactory("ol", null, suggestions.map((suggestion) => {
            return interface_manager_1.DeadDocumentJSX.JSXFactory("li", null, interface_manager_1.TextPresentationRenderer.render(suggestion));
        }))), {
        replyToEvent: eventContext.event,
        additionalContent: reactionHandler.createAnnotation(exports.ARGUMENT_PROMPT_LISTENER, reactionMap, {
            command_designator: command.designator,
            read_items: existingArguments.map((p) => interface_manager_1.TextPresentationRenderer.render(p)),
        }),
    });
    if ((0, matrix_protection_suite_1.isError)(sendResult)) {
        return sendResult;
    }
    if (sendResult.ok[0] === undefined) {
        throw new TypeError(`Something is really wrong with the code`);
    }
    await reactionHandler.addReactionsToEvent(eventContext.event.room_id, sendResult.ok[0], reactionMap);
    return (0, typescript_result_1.Ok)(undefined);
}
//# sourceMappingURL=MatrixPromptForAccept.js.map