/**
 * Copyright (C) 2023 Gnuxie <Gnuxie@protonmail.com>
 * All rights reserved.
 */
import { ActionResult, ClientRooms, ClientsInRoomMap } from 'matrix-protection-suite';
import { MatrixSendClient } from '../MatrixEmitter';
import { StringRoomID, StringUserID } from '@the-draupnir-project/matrix-basic-types';
export type ClientForUserID = (clientUserID: StringUserID) => Promise<MatrixSendClient>;
export interface ClientManagement {
    clientsInRoomMap: ClientsInRoomMap;
    getClientRooms(clientUserID: StringUserID): Promise<ActionResult<ClientRooms>>;
}
export declare function joinedRoomsSafe(client: MatrixSendClient): Promise<ActionResult<StringRoomID[]>>;
//# sourceMappingURL=ClientManagement.d.ts.map