import { StringRoomID, StringUserID } from '@the-draupnir-project/matrix-basic-types';
export interface JoinedRoomsChange {
    joined: StringRoomID[];
    parted: StringRoomID[];
}
export interface JoinedRoomsRevision {
    readonly allJoinedRooms: StringRoomID[];
    readonly clientUserID: StringUserID;
    isEmpty(): boolean;
    changesFromJoinedRooms(roomIDs: StringRoomID[]): JoinedRoomsChange;
    reviseFromJoinedRooms(roomIDs: StringRoomID[]): JoinedRoomsRevision;
    isJoinedRoom(roomID: StringRoomID): boolean;
}
export declare class StandardJoinedRoomsRevision {
    readonly clientUserID: StringUserID;
    private readonly joinedRooms;
    private constructor();
    get allJoinedRooms(): StringRoomID[];
    isEmpty(): boolean;
    isJoinedRoom(roomID: StringRoomID): boolean;
    isPreemptivelyJoinedRoom(roomID: StringRoomID): boolean;
    changesFromJoinedRooms(roomIDs: StringRoomID[]): JoinedRoomsChange;
    reviseFromJoinedRooms(roomIDs: StringRoomID[]): JoinedRoomsRevision;
    static blankRevision(clientUserID: StringUserID): JoinedRoomsRevision;
}
//# sourceMappingURL=JoinedRoomsRevision.d.ts.map