import { Result } from '@gnuxie/typescript-result';
export type KeyedBatchRequest<Value extends string = string> = {
    value: Value;
    resolve: (result: Result<void>) => void;
};
export type KeyedBatchProcessor<Key extends string = string, Value extends string = string> = (key: Key, batchedValues: Value[]) => Promise<Result<void>>;
export declare class KeyedBatchQueue<Key extends string = string, Value extends string = string> {
    private batchProcessor;
    private queues;
    private processing;
    constructor(batchProcessor: KeyedBatchProcessor<Key, Value>);
    enqueue(key: Key, value: Value): Promise<Result<void>>;
    private maybeProcess;
    private flush;
}
//# sourceMappingURL=KeyedBatchQueue.d.ts.map